# Como Corrigir o Erro 500 ao Salvar Usuário como Produtor

## Problema

Ao tentar mudar um usuário para o role "Produtor" em `admin_usuarios.php`, a página retorna erro 500.

## Causa Provável

A coluna `role` na tabela `users` está configurada como `ENUM` e não inclui o valor `'produtor'` entre os valores aceitos. Isso faz com que o `UPDATE` falhe ao tentar salvar.

## Solução

Execute o script SQL `fix_role_produtor.sql` no seu banco de dados:

### Opção 1: Via phpMyAdmin

1. Acesse o phpMyAdmin
2. Selecione o banco de dados `luminainkcom_promoters_system`
3. Vá na aba "SQL"
4. Copie e cole o conteúdo do arquivo `fix_role_produtor.sql`
5. Clique em "Executar"

### Opção 2: Via linha de comando MySQL

```bash
mysql -u luminainkcom_promoter_user -p luminainkcom_promoters_system < fix_role_produtor.sql
```

### Opção 3: Executar comando direto

Execute este comando SQL diretamente:

```sql
ALTER TABLE `users`
MODIFY COLUMN `role` ENUM('admin', 'user', 'gerente', 'produtor') NOT NULL DEFAULT 'user';
```

## Verificação

Após executar o script, verifique se funcionou:

```sql
SELECT COLUMN_TYPE
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = 'luminainkcom_promoters_system'
  AND TABLE_NAME = 'users'
  AND COLUMN_NAME = 'role';
```

Você deve ver: `enum('admin','user','gerente','produtor')`

## Testando

1. Acesse `admin_usuarios.php`
2. Selecione um usuário
3. Mude o role para "Produtor"
4. Clique em "Salvar"
5. A página deve recarregar com sucesso
6. Uma seção "🎭 Eventos Associados" deve aparecer abaixo do formulário

## Observações

- Todos os códigos PHP já foram corrigidos para usar `produtor_eventos` ao invés de `promoter_eventos`
- O tratamento de erro foi adicionado para exibir mensagens mais claras
- A funcionalidade de associação de produtor a evento já está implementada e funcionará após corrigir a coluna `role`
