# Estimativas de Tempo - Melhorias do Sistema

## 1️⃣ PADRONIZAÇÃO DE DESIGN (Dashboard Layout em Todo o Sistema)

### Escopo do Trabalho

Aplicar o design e layout atual da `dashboard.php` em todas as 23 páginas principais do sistema, preservando:
- Menu navbar responsivo (desktop e mobile)
- Esquema de cores (preto, dourado, cards)
- Animações e efeitos hover
- Ícones e tipografia
- Grid responsivo

### Páginas a Serem Atualizadas (23 páginas)

#### Área Admin (8 páginas)
1. `admin_checkin.php` - Check-in de convidados
2. `admin_checkin_manual.php` - Check-in manual
3. `admin_convidados.php` - Gerenciar convidados
4. `admin_eventos.php` - Gerenciar eventos
5. `admin_perfil_promoter.php` - Perfil detalhado de promoter
6. `admin_relatorios.php` - Relatórios e estatísticas
7. `admin_saques.php` - Gerenciar saques
8. `admin_usuarios.php` - Gerenciar usuários

#### Área Promoter (6 páginas)
9. `eventos.php` - Listar eventos disponíveis
10. `financeiro.php` - Dashboard financeiro
11. `meus_saques.php` - Solicitar e gerenciar saques
12. `minhas_listas.php` - Ver listas de convidados
13. `ranking.php` - Ranking de promoters
14. `convite.php` - Página de cadastro de convidados

#### Área Produtor (3 páginas)
15. `produtor_eventos.php` - Eventos do produtor
16. `produtor_financeiro.php` - Financeiro do produtor
17. `produtor_listas.php` - Listas do produtor

#### Utilitários e Outras (6 páginas)
18. `configuracoes.php` - Configurações do sistema
19. `convite_qrcode.php` - Gerar QR code
20. `baixar_qrcode.php` - Download de QR code
21. `login.php` - Tela de login/registro
22. `loginx.php` - Login alternativo
23. `dashboard.php` - ✅ Já tem o design padrão

### Complexidade por Tipo de Página

**Simples (10-15 min/página):**
- Páginas de listagem básica: eventos.php, ranking.php
- Páginas de formulário simples: meus_saques.php

**Média (20-30 min/página):**
- Páginas com tabelas e filtros: admin_usuarios.php, admin_convidados.php
- Páginas com cards e estatísticas: financeiro.php, produtor_financeiro.php

**Complexa (30-45 min/página):**
- Páginas com múltiplas seções: admin_relatorios.php, admin_perfil_promoter.php
- Páginas com gráficos: minhas_listas.php
- Páginas de check-in: admin_checkin.php

### Estimativa de Tempo

| Complexidade | Páginas | Tempo/Página | Total |
|--------------|---------|--------------|-------|
| Simples      | 8       | 15 min       | 2h    |
| Média        | 10      | 25 min       | 4h    |
| Complexa     | 5       | 40 min       | 3h    |

**TOTAL ESTIMADO: 8-10 horas de trabalho**

### Processo de Implementação

1. **Criar arquivo CSS compartilhado** (1h)
   - Extrair todo CSS da dashboard para `assets/dashboard-style.css`
   - Criar variáveis CSS reutilizáveis
   - Menu navbar como componente

2. **Atualizar páginas por prioridade** (7-9h)
   - Fase 1: Páginas admin (mais usadas)
   - Fase 2: Páginas promoter
   - Fase 3: Páginas produtor e utilitários

3. **Testes e ajustes finais** (1h)
   - Testar responsividade em mobile
   - Verificar navegação entre páginas
   - Corrigir inconsistências

---

## 2️⃣ SISTEMA DE SUB-PROMOTERS

### Conceito

Permitir que um promoter principal possa ter "sub-promoters" (subordinados) que trabalham sob sua supervisão. O promoter principal ganha comissões sobre os convidados trazidos por seus sub-promoters.

### Funcionalidades Necessárias

#### Backend (Banco de Dados)
1. **Nova tabela `sub_promoters`**
   ```sql
   - id
   - promoter_principal_id (quem é o líder)
   - sub_promoter_id (quem é o subordinado)
   - percentual_comissao (% que o líder ganha)
   - status (ativo/inativo)
   - created_at
   ```

2. **Alterar tabela `comissoes`**
   - Adicionar campo `promoter_principal_id` (comissão do líder)
   - Adicionar campo `tipo` (direta ou indireta)

3. **Lógica de comissões hierárquicas**
   - Quando sub-promoter gera comissão, calcular % para o líder
   - Registrar comissão do sub-promoter (100%)
   - Registrar comissão do líder (ex: 10-20% do sub)

#### Frontend (Interface)

1. **Página "Minha Equipe"** (nova)
   - Listar sub-promoters ativos
   - Adicionar novo sub-promoter (via código de convite)
   - Ver estatísticas da equipe
   - Ranking interno da equipe

2. **Dashboard com estatísticas de equipe**
   - Total de sub-promoters
   - Total de convidados da equipe
   - Comissões diretas vs indiretas

3. **Sistema de convite para sub-promoters**
   - Gerar código único de convite
   - Link de cadastro especial
   - Aprovação automática ou manual

4. **Relatórios hierárquicos**
   - Ver performance individual de cada sub
   - Comparar resultados
   - Exportar dados da equipe

#### Regras de Negócio

1. **Hierarquia de níveis**
   - Quantos níveis permitir? (1 nível = sub direto, 2 níveis = sub do sub)
   - Porcentagens de comissão por nível

2. **Limites e validações**
   - Um promoter pode ter no máximo quantos subs?
   - Sub-promoter pode virar líder?
   - Como funciona se um sub-promoter já existe no sistema?

3. **Comissões**
   - % fixo ou configurável por líder?
   - Mínimo e máximo de comissão?
   - Como fica o saque (separado ou junto)?

### Complexidade Técnica

**Alta** - Envolve:
- Alteração estrutural do banco de dados
- Lógica complexa de cálculo de comissões
- Múltiplas telas novas
- Sistema de permissões hierárquicas
- Relatórios com filtros avançados

### Estimativa de Tempo

| Etapa | Tempo |
|-------|-------|
| Modelagem e SQL (tabelas, constraints) | 1-2h |
| Lógica de comissões hierárquicas | 3-4h |
| Tela "Minha Equipe" | 2h |
| Sistema de convite/código | 2h |
| Atualizar dashboard com stats de equipe | 1h |
| Relatórios e filtros | 2-3h |
| Testes e ajustes | 2h |

**TOTAL ESTIMADO: 12-15 horas de trabalho**

### Questões Importantes a Definir ANTES

1. **Estrutura hierárquica:**
   - Apenas 1 nível (líder → sub) ou múltiplos níveis (líder → sub → sub-sub)?

2. **Comissões:**
   - Líder ganha % fixo (ex: 10%) de TUDO que o sub fizer?
   - Ou % variável configurável?
   - Exemplo: Sub ganha R$ 100 → Líder ganha R$ 10 (10%)

3. **Convite:**
   - Sub-promoter se cadastra com código especial?
   - Ou promoter existente pode virar sub de alguém?

4. **Limites:**
   - Máximo de subs por líder? (ex: 20 subs)
   - Sub pode ter apenas 1 líder ou múltiplos?

5. **Saque:**
   - Comissões de líder e sub são separadas ou unificadas?

---

## RECOMENDAÇÕES

### Para Padronização de Design (Pergunta 1)
✅ **RECOMENDADO FAZER PRIMEIRO**
- Baixa complexidade
- Alto impacto visual
- Melhora experiência do usuário
- Não afeta regras de negócio
- Pode ser feito em etapas

### Para Sub-Promoters (Pergunta 2)
⚠️ **REQUER PLANEJAMENTO DETALHADO**
- Alta complexidade
- Afeta diretamente o financeiro
- Precisa definir regras de negócio primeiro
- Recomendo fazer DEPOIS da padronização de design
- Ideal dividir em fases (MVP → Completo)

---

## CRONOGRAMA SUGERIDO

### Opção 1: Tudo de Uma Vez
- Semana 1: Padronização de Design (8-10h)
- Semana 2: Sub-Promoters - Planejamento e Modelagem (3h)
- Semana 3: Sub-Promoters - Desenvolvimento Backend (5-6h)
- Semana 4: Sub-Promoters - Desenvolvimento Frontend (4-5h)
- Semana 5: Testes e Ajustes Finais (2-3h)

**Total: 22-27 horas distribuídas em 5 semanas**

### Opção 2: Faseado (Recomendado)
**Fase 1 (Prioridade Alta):**
- Padronização completa de design (8-10h)

**Fase 2 (Após validação do design):**
- Planejamento detalhado de Sub-Promoters (reunião/doc)
- Implementação MVP (funcionalidade básica) (8-10h)

**Fase 3 (Incremento):**
- Adicionar funcionalidades avançadas (relatórios, analytics) (4-5h)

---

## PRÓXIMOS PASSOS

### Se quiser começar a Padronização de Design:
1. Confirmar se quer manter exatamente o design da dashboard atual
2. Definir prioridade das páginas (quais fazer primeiro)
3. Iniciar implementação

### Se quiser planejar Sub-Promoters:
1. Responder as 5 questões importantes acima
2. Validar regras de comissão
3. Criar documento de requisitos
4. Depois iniciar desenvolvimento

**Posso começar imediatamente com qualquer uma das duas tarefas!**
