# 🚀 Guia Completo de Instalação
## Sistema de Gestão de Promoters

---

## 📋 Requisitos do Servidor

### Mínimos:
- ✅ PHP 7.4 ou superior
- ✅ MySQL 5.7 ou superior / MariaDB 10.2+
- ✅ Apache com mod_rewrite ativado
- ✅ Extensões PHP: PDO, PDO_MySQL, OpenSSL, cURL, GD
- ✅ 50MB de espaço em disco
- ✅ SSL/HTTPS (recomendado)

### Recomendados:
- PHP 8.0+
- MySQL 8.0+
- 100MB de espaço
- RAM: 256MB mínimo

---

## 🔧 Instalação em cPanel (Método Recomendado)

### Passo 1: Preparar o Ambiente

1. **Fazer login no cPanel**
   - Acesse: `seu-dominio.com:2083`
   - Use suas credenciais de hospedagem

2. **Criar Banco de Dados MySQL**
   - Vá em: **MySQL Databases** ou **Banco de Dados MySQL**
   - Criar novo banco: `promoters_db` (ou nome de sua preferência)
   - Criar novo usuário: `promoters_user`
   - Criar senha forte e anotá-la
   - Adicionar usuário ao banco com **TODOS OS PRIVILÉGIOS**

### Passo 2: Upload dos Arquivos

**Opção A: Via Gerenciador de Arquivos (mais fácil)**

1. No cPanel, acesse **Gerenciador de Arquivos** (File Manager)
2. Navegue até **public_html** (ou pasta do seu domínio)
3. Faça upload do arquivo ZIP do sistema
4. Clique com botão direito → **Extract** (Extrair)
5. Mova todos os arquivos para a raiz (se necessário)

**Opção B: Via FTP**

1. Use FileZilla ou outro cliente FTP
2. Conecte usando suas credenciais de hospedagem
3. Envie todos os arquivos para `/public_html`

### Passo 3: Executar o Instalador

1. **Acesse o instalador no navegador:**
   ```
   http://seu-dominio.com/install.php
   ```

2. **Siga os 4 passos:**

   **① Verificar Requisitos**
   - O sistema verifica automaticamente
   - Todos devem estar ✅ OK
   - Se houver ❌ ERRO, contate sua hospedagem

   **② Configurar Banco de Dados**
   - Host: `localhost` (padrão cPanel)
   - Porta: `3306` (padrão)
   - Nome do Banco: o que você criou (ex: `promoters_db`)
   - Usuário: o que você criou (ex: `promoters_user`)
   - Senha: a senha que você definiu

   **③ Criar Administrador**
   - Nome completo do admin
   - Email (será usado para login)
   - Senha forte (mínimo 6 caracteres)

   **④ Concluído!**
   - Sistema instalado com sucesso

### Passo 4: Segurança Pós-Instalação

⚠️ **MUITO IMPORTANTE - NÃO PULE ESTE PASSO!**

1. **Apagar o instalador:**
   ```bash
   # Via Gerenciador de Arquivos:
   # Apague o arquivo: install.php

   # Via SSH (se tiver acesso):
   rm -f install.php
   ```

2. **Proteger o instalador no .htaccess:**
   - Abra o arquivo `.htaccess`
   - Localize estas linhas (aprox. linha 30):
   ```apache
   # <Files "install.php">
   #     Order allow,deny
   #     Deny from all
   # </Files>
   ```
   - Remova os `#` para descomentar:
   ```apache
   <Files "install.php">
       Order allow,deny
       Deny from all
   </Files>
   ```

3. **Ativar HTTPS (se disponível):**
   - No `.htaccess`, localize:
   ```apache
   # RewriteCond %{HTTPS} off
   # RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
   ```
   - Descomente para ativar:
   ```apache
   RewriteCond %{HTTPS} off
   RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
   ```

4. **Permissões de arquivos:**
   ```bash
   # Via SSH (se tiver acesso):
   chmod 644 config.php
   chmod 755 uploads
   chmod 755 uploads/perfil
   chmod 755 uploads/sistema
   chmod 644 .htaccess

   # Via cPanel:
   # Gerenciador de Arquivos → Selecionar arquivo → Permissões → 644 ou 755
   ```

---

## 🌐 Acessar o Sistema

Após a instalação:

1. **Login:**
   ```
   http://seu-dominio.com
   ou
   http://seu-dominio.com/login
   ```
   Ambos funcionam! O sistema redireciona automaticamente.

2. **Credenciais:**
   - Email: o que você definiu no passo 3
   - Senha: a que você definiu no passo 3

3. **Dashboard Admin:**
   ```
   http://seu-dominio.com/dashboard
   ```

---

## 🔒 Recursos de Segurança Incluídos

✅ **Proteções Automáticas:**
- Bloqueio de injeção SQL
- Proteção XSS (Cross-Site Scripting)
- Proteção contra clickjacking
- Bloqueio de bots maliciosos
- Proteção de arquivos sensíveis
- Sessões seguras com tokens
- Senhas com hash bcrypt
- CSRF protection
- Bloqueio de listagem de diretórios
- Sanitização de inputs

✅ **Arquivo .htaccess Inclui:**
- Rewrite rules para URLs limpas
- Bloqueio de acesso a .sql, .log, .bak
- Proteção contra query strings maliciosas
- Bloqueio de user agents suspeitos
- Headers de segurança HTTP

---

## 📁 Estrutura de Diretórios

```
/public_html/
├── .htaccess                    # Configurações Apache + Segurança
├── index.php                    # Página inicial (redireciona)
├── login.php                    # Login
├── dashboard.php                # Dashboard
├── config.php                   # Configurações (gerado na instalação)
├── install.php                  # Instalador (APAGAR após instalar!)
├── install_database.sql         # SQL completo
├── assets/                      # CSS, JS, imagens
├── uploads/                     # Uploads de usuários
│   ├── perfil/                 # Fotos de perfil
│   └── sistema/                # Logo, banner
├── migration_*.sql              # Migrações do banco
└── [outros arquivos PHP]
```

---

## 🆘 Resolução de Problemas

### Erro: "Erro na conexão com o banco de dados"

**Solução:**
1. Verifique se o banco foi criado no cPanel
2. Confirme usuário e senha
3. Verifique se o usuário tem privilégios no banco
4. Tente host: `localhost` ou `127.0.0.1`

### Erro 500 (Internal Server Error)

**Solução:**
1. Verifique permissões dos arquivos (644 para PHP, 755 para pastas)
2. Verifique se há erro no .htaccess
3. Ative display_errors no PHP temporariamente
4. Veja os logs de erro no cPanel

### URLs não funcionam (404)

**Solução:**
1. Verifique se o mod_rewrite está ativo
2. Verifique se o .htaccess foi enviado
3. Tente renomear .htaccess temporariamente
4. Contate sua hospedagem para ativar mod_rewrite

### Página em branco

**Solução:**
1. Ative exibição de erros no PHP
2. Verifique logs de erro do servidor
3. Confirme versão do PHP (mínimo 7.4)
4. Verifique extensões PDO e PDO_MySQL

---

## 🔄 Executar Migrações Pendentes

Se houver migrações SQL pendentes:

1. **Via phpMyAdmin:**
   - Acesse phpMyAdmin no cPanel
   - Selecione o banco de dados
   - Vá em SQL
   - Cole o conteúdo do arquivo `migration_*.sql`
   - Execute

2. **Migrações necessárias:**
   - `migration_add_cartao_consumo.sql` - Tipos de saque
   - `migration_fix_status_saques.sql` - Status de saque

---

## 📞 Suporte

Se encontrar problemas:

1. Verifique os logs de erro do servidor
2. Ative display_errors temporariamente
3. Consulte a documentação da sua hospedagem
4. Verifique se todos os requisitos estão atendidos

---

## ✅ Checklist Pós-Instalação

- [ ] Sistema instalado com sucesso
- [ ] Login funcionando
- [ ] Arquivo install.php APAGADO
- [ ] .htaccess protegendo install.php
- [ ] HTTPS ativado (se disponível)
- [ ] Senha do admin alterada
- [ ] Migrações SQL executadas
- [ ] Permissões de arquivos corretas
- [ ] Backup do banco de dados criado

---

## 🎉 Pronto!

Seu sistema está instalado e protegido. Acesse e comece a usar!

**Primeiro acesso:**
```
http://seu-dominio.com
```

Faça login com as credenciais de administrador que você criou.
