# 🚀 INSTRUÇÕES DE INSTALAÇÃO - PromoTaal White Label v2.0

## ✅ Status das Correções

Todos os erros foram corrigidos no repositório:

1. ✅ `.htaccess` simplificado (de 158 para 27 linhas)
2. ✅ SQL corrigido: removido `YEAR(CURDATE())` incompatível
3. ✅ `config.php` corrigido: `PHP_SESSION_NONE` ao invés de `PHP_STATUS_NONE`
4. ✅ Credenciais do banco de dados atualizadas
5. ✅ Tratamento de erros para tabelas inexistentes

---

## 📋 PASSO A PASSO PARA INSTALAÇÃO

### **OPÇÃO 1: Instalação Nova (Sistema Vazio)**

#### **Passo 1: Verificar Arquivos no Servidor**
Certifique-se de que todos os arquivos estão em `/public_html/sis/`

#### **Passo 2: Importar Banco de Dados**
1. Acesse **phpMyAdmin** no cPanel
2. Selecione o banco: `invitmecom_promosis`
3. Vá em **Importar**
4. Escolha o arquivo: `install_database.sql`
5. Clique em **Executar**

#### **Passo 3: Verificar Instalação**
1. Acesse: `https://promo.taal.luminaink.com.br/sis/login.php`
2. Se der erro de tabelas, vá para o Passo 4

#### **Passo 4: Usar o Instalador Automático (Alternativa)**
1. Acesse: `https://promo.taal.luminaink.com.br/sis/install.php`
2. Siga as instruções na tela
3. Crie o primeiro usuário admin

---

### **OPÇÃO 2: Atualizar Sistema Existente (Já tem dados)**

Se você JÁ tem um banco de dados com promoters/eventos/usuários:

#### **Passo 1: Fazer Backup**
```sql
-- No phpMyAdmin, exporte o banco atual antes de qualquer alteração
```

#### **Passo 2: Executar Migration**
1. Acesse **phpMyAdmin**
2. Selecione o banco: `invitmecom_promosis`
3. Vá em **SQL**
4. Cole o conteúdo de: `migration_whitelabel_v2.sql`
5. Clique em **Executar**

Isso adicionará as tabelas do White Label v2.0:
- `configuracoes_visual` - Cores e tema
- `paletas_cores` - 7 paletas pré-definidas
- `artigos_ajuda` - Sistema de tutoriais
- `rodape_sistema` - Rodapé customizável

---

## 🔧 VERIFICAÇÕES IMPORTANTES

### **1. Verificar config.php no Servidor**

O arquivo `config.php` no servidor DEVE ter estas linhas EXATAS:

```php
// Linha 11 - CORRETA
if (session_status() === PHP_SESSION_NONE) {

// Linhas 16-20 - Credenciais CORRETAS
define('DB_HOST', 'localhost');
define('DB_PORT', '3306');
define('DB_NAME', 'invitmecom_promosis');
define('DB_USER', 'invitmecom_promosis');
define('DB_PASS', 'rH]&iG%{ysipNDnB');
```

**⚠️ SE ESTIVER DIFERENTE:**
1. Baixe o `config.php` do repositório
2. Faça upload para `/public_html/sis/config.php`
3. Substitua o arquivo antigo

### **2. Verificar .htaccess**

O `.htaccess` deve ter apenas 27 linhas (versão simplificada).

**Se ainda der Erro 500:**
1. Renomeie `.htaccess` para `_htaccess.disabled`
2. Teste o sistema
3. Se funcionar, o problema era o .htaccess mesmo

---

## 🎨 WHITE LABEL v2.0 - Funcionalidades

Após a instalação, você terá:

### **1. Personalização Visual**
- Acesse: `Configurações > Personalização Visual`
- 7 paletas de cores prontas:
  - 🟡 Nubank (Roxo)
  - 🟢 Next (Verde)
  - 🔵 Neon (Azul Neon)
  - 🟠 Rico (Laranja)
  - 🟣 Aurora (Rosa/Roxo)
  - 🌊 Oceano (Azul Oceano)
  - 🌿 Menta (Verde Menta)
- Ou crie sua própria paleta personalizada

### **2. Sistema de Ajuda**
- Gerenciar em: `Admin > Artigos de Ajuda`
- Usuários acessam em: `Ajuda` no menu
- Tutoriais em accordion com busca

### **3. Rodapé Customizável**
- Edite em: `dev_footer.php` (página secreta)
- Configure desenvolvedor, ano, versão
- **⚠️ DELETE o arquivo dev_footer.php após usar** (por segurança)

---

## 🆘 RESOLUÇÃO DE PROBLEMAS

### **Erro 500 - Internal Server Error**
✅ **Solução:** Renomeie `.htaccess` para `_htaccess.disabled`

### **"Undefined constant PHP_STATUS_NONE"**
✅ **Solução:** Substitua o `config.php` pela versão correta do repositório

### **"SQLSTATE[42000]: Syntax error... YEAR(CURDATE())"**
✅ **Solução:** Use os arquivos SQL corrigidos (já está corrigido no repositório)

### **"Table doesn't exist" após instalação**
✅ **Solução:** Importe `install_database.sql` via phpMyAdmin

### **Cores não mudam / White Label não funciona**
✅ **Solução:** Execute `migration_whitelabel_v2.sql` via phpMyAdmin

---

## 📞 PRÓXIMOS PASSOS

1. ✅ Importe o banco de dados (`install_database.sql` OU `migration_whitelabel_v2.sql`)
2. ✅ Acesse `login.php` e teste
3. ✅ Configure o White Label em `Configurações > Personalização Visual`
4. ✅ Crie artigos de ajuda em `Admin > Artigos de Ajuda`
5. ✅ Personalize o rodapé em `dev_footer.php` (depois delete o arquivo)

---

## 📊 CREDENCIAIS DO BANCO (Confirmadas)

```
Host: localhost
Porta: 3306
Banco: invitmecom_promosis
Usuário: invitmecom_promosis
Senha: rH]&iG%{ysipNDnB
```

✅ Já configuradas corretamente no `config.php` do repositório!

---

**🎉 Pronto! O sistema está corrigido e pronto para instalação.**

Se após seguir estes passos ainda houver erros, me envie a mensagem de erro COMPLETA para análise.
