# Correção do Erro 500 em Cartão de Consumo

## Problema Identificado

**Erro:** `SQLSTATE[01000]: Warning: 1265 Data truncated for column 'tipo' at row 1`

**Causa:** A coluna `tipo` na tabela `saques` está definida como ENUM com valores limitados e não inclui 'cartao_consumo'.

## Solução

Execute a migração SQL no seu banco de dados MySQL.

### Opção 1: Via PhpMyAdmin

1. Acesse seu PhpMyAdmin
2. Selecione o banco de dados do sistema
3. Clique em "SQL" no menu superior
4. Copie e cole o conteúdo do arquivo `migration_add_cartao_consumo.sql`
5. Clique em "Executar"

### Opção 2: Via MySQL CLI

```bash
mysql -u seu_usuario -p seu_banco_de_dados < migration_add_cartao_consumo.sql
```

### Opção 3: Via Terminal MySQL

```bash
mysql -u seu_usuario -p
```

Depois dentro do MySQL:

```sql
USE seu_banco_de_dados;
SOURCE /caminho/para/migration_add_cartao_consumo.sql;
```

## O que a Migração Faz

1. **Atualiza registros antigos** (se existirem) de 'consumacao_pix' para 'cartao_consumo'
2. **Modifica a coluna tipo** para aceitar os valores:
   - `pix` - Saque via PIX (transferência bancária)
   - `credito` - Crédito de Consumação (bônus)
   - `cartao_consumo` - Cartão de Consumo (uso do bônus)
   - `consumacao_pix` - Tipo antigo (mantido para compatibilidade)
3. **Mostra contagem** de registros por tipo para verificação

## Verificação

Após executar a migração, teste:

1. Acesse como promoter
2. Vá em "Financeiro"
3. Se tiver crédito de consumação, clique em "Solicitar Cartão de Consumo"
4. Preencha o valor e clique em "Solicitar"
5. Deve aparecer mensagem de sucesso (sem erro 500)

## Observações

- A migração é **segura** e não remove dados existentes
- Mantém compatibilidade com registros antigos
- Adiciona valor DEFAULT para novos registros
- Inclui query de verificação ao final

## Em caso de Erro

Se preferir usar VARCHAR ao invés de ENUM (mais flexível), execute:

```sql
ALTER TABLE saques MODIFY COLUMN tipo VARCHAR(30) NOT NULL DEFAULT 'pix';
```

Isso permite adicionar novos tipos no futuro sem precisar de migração.
