# Correção Completa dos Erros 500 no Sistema de Saques

## Problemas Identificados

### Erro 1: Coluna 'tipo'
**Erro:** `SQLSTATE[01000]: Warning: 1265 Data truncated for column 'tipo' at row 1`
**Quando:** Ao solicitar cartão de consumo em financeiro.php
**Causa:** ENUM de 'tipo' não inclui 'cartao_consumo'

### Erro 2: Coluna 'status'
**Erro:** `SQLSTATE[01000]: Warning: 1265 Data truncated for column 'status' at row 1`
**Quando:** Ao marcar saque como pago em admin_saques.php
**Causa:** ENUM de 'status' não inclui 'usado'

## Solução: Executar AMBAS as Migrações

É necessário executar **duas migrações SQL** no banco de dados, na ordem correta.

---

## 📋 Como Executar (PhpMyAdmin - Recomendado)

### Passo 1: Acesse PhpMyAdmin
1. Faça login no PhpMyAdmin
2. Selecione seu banco de dados do sistema

### Passo 2: Execute a Primeira Migração (tipo)
1. Clique na aba "SQL"
2. Copie **TODO** o conteúdo de `migration_add_cartao_consumo.sql`
3. Cole na área de texto
4. Clique em "Executar"
5. ✅ Deve aparecer "Query executada com sucesso"

### Passo 3: Execute a Segunda Migração (status)
1. **Ainda na aba "SQL"**
2. **Limpe** a área de texto
3. Copie **TODO** o conteúdo de `migration_fix_status_saques.sql`
4. Cole na área de texto
5. Clique em "Executar"
6. ✅ Deve aparecer "Query executada com sucesso"

---

## 📋 Como Executar (MySQL CLI)

```bash
# Migração 1: Corrigir tipo
mysql -u seu_usuario -p seu_banco < migration_add_cartao_consumo.sql

# Migração 2: Corrigir status
mysql -u seu_usuario -p seu_banco < migration_fix_status_saques.sql
```

---

## 📋 Como Executar (Terminal MySQL)

```bash
mysql -u seu_usuario -p
```

Dentro do MySQL:

```sql
USE seu_banco_de_dados;

-- Migração 1
SOURCE /caminho/completo/migration_add_cartao_consumo.sql;

-- Migração 2
SOURCE /caminho/completo/migration_fix_status_saques.sql;
```

---

## ✅ Verificação Após Executar

### Teste 1: Solicitar Cartão de Consumo
1. Acesse como **promoter**
2. Vá em **"Financeiro"**
3. Se tiver crédito de consumação, clique em **"Solicitar Cartão de Consumo"**
4. Preencha o valor e clique em **"Solicitar"**
5. ✅ Deve aparecer mensagem de sucesso (não erro 500)

### Teste 2: Marcar Saque como Pago
1. Acesse como **admin**
2. Vá em **"Saques"** → aba **"A Pagar"**
3. Clique em **"Marcar como PAGO"** em qualquer saque
4. ✅ Deve aparecer mensagem de sucesso (não erro 500)

---

## 📊 O que as Migrações Fazem

### Migração 1: `migration_add_cartao_consumo.sql`
- ✅ Atualiza registros antigos de 'consumacao_pix' para 'cartao_consumo'
- ✅ Adiciona valores ao ENUM de 'tipo': `pix`, `credito`, `cartao_consumo`, `consumacao_pix`
- ✅ Define DEFAULT 'pix'
- ✅ Mostra contagem de registros por tipo

### Migração 2: `migration_fix_status_saques.sql`
- ✅ Converte 'aprovado' para 'processando' (compatibilidade)
- ✅ Adiciona valores ao ENUM de 'status': `pendente`, `processando`, `concluido`, `cancelado`, `usado`, `aprovado`
- ✅ Define DEFAULT 'pendente'
- ✅ Mostra contagem de registros por status

---

## 🔄 Fluxo Completo do Sistema Após Migrações

### Para Promoters:
1. Ganha comissão por check-ins → **Saldo Disponível**
2. Pode solicitar:
   - **PIX** (dinheiro na conta) - tipo: 'pix', status: 'pendente'
   - **Crédito de Consumação** (bônus) - tipo: 'credito', status: 'pendente'
3. Com crédito aprovado, pode solicitar:
   - **Cartão de Consumo** (usar bônus na bilheteria) - tipo: 'cartao_consumo', status: 'pendente'

### Para Admins:
1. Aprova solicitação → status: 'processando'
2. Marca como pago → status: 'concluido'
3. Se for cartão de consumo → créditos usados ficam: status: 'usado'
4. Pode rejeitar → status: 'cancelado'

---

## ⚠️ IMPORTANTE

- Execute **AMBAS** as migrações
- Execute na **ordem correta** (tipo primeiro, status depois)
- As migrações são **seguras** e não apagam dados
- Mantém **compatibilidade** com registros antigos

---

## 💡 Alternativa: Usar VARCHAR

Se preferir mais flexibilidade para adicionar novos tipos/status no futuro sem migração:

```sql
-- Para tipo
ALTER TABLE saques MODIFY COLUMN tipo VARCHAR(30) NOT NULL DEFAULT 'pix';

-- Para status
ALTER TABLE saques MODIFY COLUMN status VARCHAR(20) NOT NULL DEFAULT 'pendente';
```

Isso permite adicionar novos valores diretamente no código PHP sem alterar o banco.

---

## 📞 Suporte

Se ainda houver erros após executar as migrações:
1. Verifique se **ambas** foram executadas
2. Confira se não há erros no log do MySQL
3. Teste com os passos de verificação acima
