# Padronização de Design - Sistema Promoters

## Status: EM ANDAMENTO (3/23 páginas - 13%)

### Objetivo
Aplicar o design padronizado preto/dourado em todas as 23 páginas do sistema, com:
- Navbar compartilhada com foto do usuário
- CSS compartilhado (assets/dashboard-style.css)
- Ícones Font Awesome (substituindo emojis)
- Layout responsivo mobile/desktop
- Preservação de TODAS as funcionalidades

---

## Páginas Completas (3/23)

### ✅ Sistema Base
1. **assets/dashboard-style.css** - CSS compartilhado com variáveis reutilizáveis
2. **assets/navbar.php** - Navbar reutilizável adaptada por role
3. **assets/default-avatar.png** - Avatar padrão SVG

### ✅ Páginas Admin (1/8)
1. **admin_usuarios.php** - Gerenciar usuários, roles e associações
   - Cards responsivos
   - Seção de eventos para produtores
   - Ícones Font Awesome
   - Todas funcionalidades preservadas

### ✅ Páginas Promoter (2/6)
1. **ranking.php** - Ranking de promoters
   - Pódio top 3 com destaque
   - Listagem completa com estatísticas
   - Responsivo

2. **minhas_listas.php** - Gerenciar convidados
   - Sistema de abas (todos/confirmados/pendentes)
   - Modal de edição
   - Filtros por evento

---

## Páginas Pendentes (20/23)

### Promoter (3 pendentes)
- [ ] eventos.php
- [ ] financeiro.php
- [ ] meus_saques.php

### Admin (7 pendentes)
- [ ] admin_eventos.php
- [ ] admin_convidados.php
- [ ] admin_checkin.php
- [ ] admin_checkin_manual.php
- [ ] admin_relatorios.php
- [ ] admin_saques.php
- [ ] admin_perfil_promoter.php

### Produtor (3 pendentes)
- [ ] produtor_eventos.php
- [ ] produtor_listas.php
- [ ] produtor_financeiro.php

### Outras (7 pendentes)
- [ ] dashboard.php (atualizar para navbar compartilhada)
- [ ] login.php
- [ ] loginx.php
- [ ] configuracoes.php
- [ ] convite.php
- [ ] convite_qrcode.php
- [ ] baixar_qrcode.php

---

## Padrão de Implementação

### Estrutura HTML Padrão
```html
<!DOCTYPE html>
<html lang="pt-BR" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Título - Sistema Promoters</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <!-- CSS específico da página se necessário -->
</head>
<body>
    <?php include 'assets/navbar.php'; ?>

    <div class="container">
        <!-- Conteúdo -->
    </div>
</body>
</html>
```

### PHP Padrão (antes do HTML)
```php
<?php
require_once 'config.php';
verificarRole(['role_necessario']);

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];

// Buscar dados do usuário para navbar
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

// Resto da lógica...
?>
```

### Componentes Padrão

#### Welcome Section
```html
<div class="welcome-section">
    <h1 class="welcome-title">
        <i class="fas fa-icon"></i>
        Título da Página
    </h1>
    <p class="welcome-subtitle">
        Descrição da página
    </p>
</div>
```

#### Section Title
```html
<h2 class="section-title">
    <i class="fas fa-icon"></i>
    Nome da Seção
</h2>
```

#### Cards
```html
<div class="card">
    <div class="card-header">
        <div class="card-title">Título</div>
    </div>
    <div class="card-body">
        <!-- Conteúdo -->
    </div>
</div>
```

#### Botões
```html
<button class="btn btn-primary">
    <i class="fas fa-icon"></i> Texto
</button>
<button class="btn btn-success">
    <i class="fas fa-check"></i> Aprovar
</button>
<button class="btn btn-danger">
    <i class="fas fa-trash"></i> Deletar
</button>
```

#### Alerts
```html
<div class="alert alert-success">
    <i class="fas fa-check-circle"></i> Mensagem de sucesso
</div>
<div class="alert alert-danger">
    <i class="fas fa-exclamation-circle"></i> Mensagem de erro
</div>
```

#### Badges
```html
<span class="badge badge-success">Aprovado</span>
<span class="badge badge-warning">Pendente</span>
<span class="badge badge-danger">Bloqueado</span>
```

---

## Mapeamento de Emojis → Ícones

| Emoji | Ícone Font Awesome | Uso |
|-------|-------------------|-----|
| 🏠 | fas fa-home | Dashboard |
| 📅 | fas fa-calendar-alt | Eventos |
| 👥 | fas fa-users | Usuários |
| 📋 | fas fa-list | Listas |
| 💰 | fas fa-wallet | Financeiro |
| 🏆 | fas fa-trophy | Ranking |
| ⚙️ | fas fa-cog | Configurações |
| 🚪 | fas fa-sign-out-alt | Sair |
| ✅ | fas fa-check | Aprovar |
| ❌ | fas fa-times | Rejeitar |
| 🗑️ | fas fa-trash | Deletar |
| ✏️ | fas fa-edit | Editar |
| 💾 | fas fa-save | Salvar |
| 📧 | fas fa-envelope | Email |
| 📱 | fas fa-phone | Telefone |
| 📍 | fas fa-map-marker-alt | Localização |
| 🎂 | fas fa-birthday-cake | Aniversário |
| ⭐ | fas fa-star | Pontuação |
| 🥇 | fas fa-crown | 1º Lugar |
| 🥈 | fas fa-medal (prata) | 2º Lugar |
| 🥉 | fas fa-medal (bronze) | 3º Lugar |
| 📊 | fas fa-chart-bar | Relatórios |
| 🔍 | fas fa-search | Buscar |
| ➕ | fas fa-plus | Adicionar |
| 🔒 | fas fa-lock | Bloquear |
| 🔓 | fas fa-unlock | Desbloquear |
| 💳 | fas fa-credit-card | Pagamento |
| 📄 | fas fa-file | Arquivo |
| 📷 | fab fa-instagram | Instagram |
| 💬 | fab fa-whatsapp | WhatsApp |
| 🕐 | fas fa-clock | Pendente |
| ✔️ | fas fa-check-circle | Confirmado |
| 📥 | fas fa-download | Download |
| 📤 | fas fa-upload | Upload |
| 🔔 | fas fa-bell | Notificação |
| ℹ️ | fas fa-info-circle | Informação |
| ⚠️ | fas fa-exclamation-triangle | Aviso |
| 🎭 | fas fa-masks | Eventos/Produtor |
| 💎 | fas fa-gem | Premium/Destaque |
| 🎯 | fas fa-bullseye | Meta/Objetivo |

---

## Variáveis CSS Disponíveis

```css
--color-gold: #FFD700
--color-gold-dark: #FFA500
--bg-primary: #000000
--bg-secondary: #0a0a0a
--bg-card: #1a1a1a
--bg-card-hover: #252525
--text-primary: #FFFFFF
--text-secondary: #999999
--border-color: #2a2a2a
--border-gold: #FFD700
--success-color: #00C851
--danger-color: #dc3545
--warning-color: #FFA500
--info-color: #17a2b8
```

---

## Checklist de Verificação (por página)

- [ ] Importa assets/dashboard-style.css
- [ ] Importa Font Awesome 6.4.0
- [ ] Inclui assets/navbar.php
- [ ] Busca dados do $usuario para navbar
- [ ] Todos emojis substituídos por ícones
- [ ] Usa classes CSS padrão
- [ ] Welcome section com título e subtítulo
- [ ] Alertas de sucesso/erro padronizados
- [ ] Botões com ícones
- [ ] Badges com ícones
- [ ] Tabelas estilizadas
- [ ] Responsivo em mobile
- [ ] TODAS funcionalidades preservadas
- [ ] Testado e funcionando

---

## Próximos Passos

1. Atualizar lote 1: eventos.php, financeiro.php, meus_saques.php
2. Atualizar lote 2: admin_eventos.php, admin_convidados.php, admin_checkin.php
3. Atualizar lote 3: produtor_eventos.php, produtor_listas.php, produtor_financeiro.php
4. Atualizar lote 4: demais páginas (dashboard, login, config, etc)
5. Teste final de todas as páginas
6. Documentação de conclusão

---

## Tempo Estimado Restante

- 20 páginas × 15 minutos = ~5 horas
- Já gasto: ~2-3 horas
- Total estimado: 7-8 horas (dentro do previsto de 8-10h)
