# 🎉 Sistema de Gestão de Promoters

Sistema completo para gerenciamento de promoters, eventos, check-ins e comissões.

## ⚡ Instalação Rápida

### 1. Fazer Upload
- Envie todos os arquivos para seu servidor (cPanel/FTP)

### 2. Criar Banco
- No cPanel → MySQL Databases
- Crie banco, usuário e vincule com todos privilégios

### 3. Acessar Instalador
```
http://seu-dominio.com/install.php
```

### 4. Seguir os 4 Passos
1. ✅ Verificar requisitos
2. 🗄️ Configurar banco de dados
3. 👤 Criar administrador
4. 🎉 Concluído!

### 5. Segurança
⚠️ **IMPORTANTE:** Apague o arquivo `install.php` após instalar!

## 📖 Documentação Completa

Leia o **GUIA_INSTALACAO.md** para instruções detalhadas.

## 🔒 Recursos de Segurança

✅ Proteção contra SQL Injection
✅ Proteção XSS
✅ Sessões seguras
✅ Senhas com hash bcrypt
✅ .htaccess com proteções avançadas
✅ CSRF protection
✅ URLs limpas (sem .php)

## 🚀 Funcionalidades

- ✅ Gestão de Promoters
- ✅ Gestão de Eventos
- ✅ Sistema de Convites
- ✅ Check-in de Convidados
- ✅ Cálculo de Comissões
- ✅ Sistema de Saques (PIX, Crédito, Cartão)
- ✅ Relatórios e Estatísticas
- ✅ Ranking de Promoters
- ✅ Perfis Personalizados
- ✅ Dashboard em Tempo Real

## 💻 Requisitos

- PHP 7.4+
- MySQL 5.7+ / MariaDB 10.2+
- Apache com mod_rewrite
- Extensões: PDO, PDO_MySQL, OpenSSL, cURL, GD

## 🆘 Suporte

Problemas na instalação? Consulte:
1. GUIA_INSTALACAO.md - Guia completo
2. INSTRUCOES_MIGRACOES_COMPLETAS.md - Migrações do banco
3. Logs de erro do servidor

## 📝 Primeiro Acesso

**URL:** `http://seu-dominio.com`
**Email:** o que você definiu na instalação
**Senha:** a que você definiu na instalação

---

**Desenvolvido com ❤️ para facilitar a gestão de eventos**
