# 🎭 Funcionalidade de Produtor - Sistema Promotaal

## 📋 Resumo da Implementação

Foi adicionado um novo tipo de usuário ao sistema: **Produtor**. Este usuário tem permissões especiais e acesso limitado, diferente de Promoters e Admins.

## 🎯 O que é um Produtor?

Um **Produtor** é um tipo de usuário que:
- É associado a eventos específicos pelo administrador
- Possui link exclusivo para cada evento associado
- Pode ver apenas os convidados que vieram pelo seu link
- Tem acesso ao sistema financeiro (comissões baseadas em check-ins)
- **NÃO** pode fazer check-in (nem QR code nem manual)
- **NÃO** tem acesso à lista completa de eventos
- **NÃO** participa do sistema de ranking de pontos

## 🚀 Instalação

### 1. Executar Script SQL

Execute o arquivo `setup_produtor.sql` no seu banco de dados:

```bash
mysql -u seu_usuario -p seu_banco_de_dados < setup_produtor.sql
```

Ou copie e cole o conteúdo do arquivo diretamente no phpMyAdmin.

Este script cria:
- Tabela `produtor_eventos` (associação entre produtores e eventos)
- Índices para otimização de consultas

### 2. Arquivos Modificados

Os seguintes arquivos foram **modificados**:

- `admin_usuarios.php` - Adicionada opção de criar/gerenciar produtores
- `dashboard.php` - Adicionadas estatísticas e menu para produtores
- `convite.php` - Agora suporta links de produtores

### 3. Novos Arquivos Criados

- `setup_produtor.sql` - Script de instalação do banco de dados
- `produtor_eventos.php` - Página de eventos do produtor
- `produtor_listas.php` - Página de listas do produtor
- `produtor_financeiro.php` - Página financeira do produtor
- `README_PRODUTOR.md` - Este arquivo

## 📖 Como Usar

### Para Administradores

#### 1. Criar um Usuário Produtor

1. Acesse **Admin → Usuários** (`admin_usuarios.php`)
2. Encontre o usuário que deseja tornar produtor
3. No dropdown de "Role", selecione **Produtor**
4. Clique em **Salvar**

#### 2. Associar Produtor a Eventos

1. Ainda em **Admin → Usuários**, localize o produtor
2. Na seção **"Eventos Associados"** (aparece automaticamente para produtores)
3. Selecione um evento no dropdown
4. Clique em **Associar**
5. Um link exclusivo será gerado automaticamente

#### 3. Remover Associação

1. Na lista de eventos associados do produtor
2. Clique no botão **❌** ao lado do evento
3. Confirme a remoção

### Para Produtores

#### 1. Fazer Login

- Acesse a página de login
- Entre com suas credenciais
- Você será redirecionado para o Dashboard de Produtor

#### 2. Dashboard

O dashboard mostra:
- **Eventos Associados**: Quantidade de eventos que você gerencia
- **Meus Convidados**: Total de pessoas que se cadastraram pelo seu link
- **Presentes**: Quantidade de check-ins realizados
- **Saldo Disponível**: Comissões disponíveis para saque

#### 3. Meus Eventos

**Página:** `produtor_eventos.php`

Mostra todos os eventos associados a você com:
- Nome e data do evento
- Quantidade de convidados e check-ins
- **Link exclusivo para compartilhar**
- Botão para copiar o link
- Arquivos disponíveis para download (materiais promocionais)

**Como compartilhar o link:**
1. Clique em "Copiar Link" no card do evento
2. Compartilhe com seus convidados via WhatsApp, Instagram, etc.
3. Quando alguém se cadastrar pelo seu link, aparecerá na sua lista

#### 4. Minhas Listas

**Página:** `produtor_listas.php`

Visualize todos os convidados que se cadastraram pelo seu link:

1. Selecione um evento
2. Veja duas listas:
   - **Confirmados**: Pessoas que já fizeram check-in
   - **Pendentes**: Pessoas cadastradas aguardando check-in

**Funcionalidades:**
- Visualizar dados dos convidados (nome, WhatsApp, email)
- Remover convidados da lista
- Ver data de cadastro

**⚠️ IMPORTANTE:** Você só vê os convidados que vieram pelo **SEU** link. Outros produtores e promoters do mesmo evento não aparecem na sua lista.

#### 5. Financeiro

**Página:** `produtor_financeiro.php`

Gerencie suas comissões:

**Saldos:**
- **Disponível**: Valor que você pode sacar agora
- **Solicitado**: Saques aguardando aprovação
- **Total Recebido**: Histórico de pagamentos

**Solicitar Saque PIX:**
1. Informe o valor (até o saldo disponível)
2. Digite sua chave PIX
3. Informe seu CPF
4. Clique em "Solicitar Saque"
5. Aguarde aprovação do administrador

**Comissões por Evento:**
- Veja quanto ganhou em cada evento
- Status: Disponível, Solicitado ou Pago
- Quantidade de convidados e check-ins

**Histórico de Saques:**
- Todas as suas solicitações de saque
- Status atual de cada saque

## 🔒 Restrições de Acesso

### O que o Produtor PODE fazer:

✅ Ver eventos associados a ele
✅ Compartilhar link exclusivo
✅ Ver lista de convidados do seu link
✅ Baixar materiais promocionais
✅ Ver comissões e saldo
✅ Solicitar saques
✅ Remover convidados da lista

### O que o Produtor NÃO PODE fazer:

❌ Fazer check-in (QR code ou manual)
❌ Ver eventos não associados a ele
❌ Ver lista completa do evento
❌ Ver convidados de outros produtores/promoters
❌ Participar do ranking de pontos
❌ Acessar painel administrativo
❌ Criar ou editar eventos

## 🔧 Detalhes Técnicos

### Estrutura do Banco de Dados

**Tabela: `produtor_eventos`**
```sql
- id (INT, AUTO_INCREMENT)
- user_id (INT) - ID do produtor
- evento_id (INT) - ID do evento
- link_exclusivo (VARCHAR) - Link único do produtor
- created_at (TIMESTAMP)
```

### Fluxo de Funcionamento

1. **Admin cria usuário** → Define role como 'produtor'
2. **Admin associa produtor a evento** → Sistema gera link exclusivo
3. **Produtor compartilha link** → Convidados se cadastram
4. **Convidados recebem QR code** → Email automático
5. **Check-in é feito** → Comissão é calculada
6. **Produtor solicita saque** → Admin aprova pagamento

### Sistema de Comissões

- Funciona exatamente como para promoters
- Baseado em check-ins realizados
- Requer mínimo de convidados (configurado no evento)
- Cálculo: `check-ins × valor_comissao`

## 🎨 Diferenças Visuais

- Badge **🎭 PRODUTOR** no dashboard (roxo)
- Menu específico (Eventos, Listas, Financeiro)
- Sem opção de Ranking
- Cards de eventos com destaque roxo

## 📞 Suporte

Para dúvidas ou problemas:
1. Verifique se executou o `setup_produtor.sql`
2. Confirme que o usuário tem role = 'produtor'
3. Verifique se o produtor foi associado a pelo menos um evento

## 🔄 Atualizações Futuras

Possíveis melhorias:
- Dashboard com gráficos de performance
- Notificações quando alguém se cadastra pelo link
- Exportação de listas em Excel
- Relatórios mensais automáticos
- Integração com WhatsApp Business

---

**Desenvolvido para o sistema Promotaal**
Versão: 1.0.0
Data: Novembro 2025
