# 🎨 WHITE LABEL v2.0 - Sistema de Personalização Completa

## 📋 Visão Geral

O **White Label v2.0** transforma este sistema em uma solução completamente personalizável, permitindo que você adapte toda a aparência e identidade visual para sua marca.

---

## ✨ Recursos Implementados

### 1. **Sistema de Cores Dinâmicas** 🎨
- ✅ **7 Paletas Pré-definidas**:
  - **Escuras (4)**: Atual, Nubank, Banco Next, Neon, Banco Rico
  - **Claras (3)**: Aurora, Oceano, Menta
- ✅ **Personalização Individual** de 12 cores:
  - Cor Primária, Secundária, Fundo, Cards, Textos, Bordas
  - Cores de Sucesso, Erro, Aviso, Info, Hover
- ✅ **Explicações Didáticas** de onde cada cor é aplicada
- ✅ **Aplicação Automática** em TODO o sistema via CSS Variables

### 2. **Identidade Visual** 🖼️
- ✅ Upload de **Logo Personalizado** (JPG, PNG, GIF, SVG - máx 5MB)
- ✅ Alteração do **Nome do Sistema**
- ✅ **Preview em Tempo Real** das alterações

### 3. **Sistema de Ajuda Completo** 📚
- ✅ **Admin pode criar artigos** de ajuda/tutoriais
- ✅ **5 Artigos Pré-criados**:
  - Como Solicitar Saque em PIX
  - Como Solicitar Bônus de Consumação
  - Como Solicitar Cartão de Consumo
  - Como Baixar Arquivos dos Eventos
  - Como Alterar Dados Pessoais
- ✅ **Busca em Tempo Real** nos artigos
- ✅ **Controle de Visibilidade** (todos, promoter, produtor)
- ✅ **Publicação Controlada** (publicado/rascunho)

### 4. **Rodapé Personalizável** 🔧
- ✅ **Página Secreta** (dev_footer.php) para editar rodapé
- ✅ Alterar "Desenvolvido por"
- ✅ Alterar link do desenvolvedor
- ✅ Alterar texto de licenciamento
- ✅ Versão do sistema configurável
- ✅ **Não aparece em menus** (acesso direto via URL)

### 5. **Navegação Aprimorada** 🧭
- ✅ Link **"Ajuda"** visível para todos os usuários
- ✅ Link **"Configurações"** no menu Admin
- ✅ Link **"Artigos de Ajuda"** no menu Admin

---

## 🚀 Como Usar

### **Passo 1: Executar a Migration**

Antes de usar, execute a migration para criar as novas tabelas:

```bash
# No phpMyAdmin ou MySQL CLI:
mysql -u usuario -p nome_banco < migration_whitelabel_v2.sql
```

ou importe diretamente pelo phpMyAdmin: `migration_whitelabel_v2.sql`

### **Passo 2: Acessar Configurações**

1. Faça login como **Admin**
2. Clique em **"Configurações"** no menu
3. Você verá 4 seções principais:
   - **Informações Básicas**
   - **Paletas de Cores**
   - **Cores Personalizadas**
   - **Tipo de Menu** (em desenvolvimento)

### **Passo 3: Escolher uma Paleta**

#### **Opção A: Usar Paleta Pré-definida**
1. Na seção **"Paletas de Cores"**, clique em uma das 7 opções
2. Veja a pré-visualização das cores
3. Clique em **"Salvar Todas as Configurações"**
4. ✅ **Pronto!** Todo o sistema mudará instantaneamente

#### **Opção B: Personalizar Manualmente**
1. Selecione **"Personalizada"**
2. Na seção **"Cores Personalizadas"**, clique em cada quadrado colorido
3. Escolha a cor desejada
4. Veja a explicação de onde cada cor é usada
5. Clique em **"Salvar"**

### **Passo 4: Upload do Logo**
1. Na seção **"Informações Básicas"**
2. Clique em **"Clique para fazer upload do logo"**
3. Selecione sua imagem (máx 5MB)
4. Veja a pré-visualização
5. Salve

### **Passo 5: Criar Artigos de Ajuda**
1. No menu Admin, clique em **"Artigos de Ajuda"**
2. Clique em **"Novo Artigo"**
3. Preencha:
   - **Título**: Nome do tutorial
   - **Conteúdo**: Use HTML para formatação
   - **Ordem**: Número de exibição
   - **Visível Para**: Todos, Promoters ou Produtores
   - **Publicado**: Marque para tornar visível
4. Clique em **"Salvar Artigo"**

### **Passo 6: Editar Rodapé** (Desenvolvedor)
1. Acesse diretamente: `https://seudominio.com/dev_footer.php`
2. Altere as informações:
   - Texto "Desenvolvido por"
   - Link do desenvolvedor
   - Texto de licenciamento
   - Ano e versão
3. Salve
4. **IMPORTANTE**: Apague o arquivo `dev_footer.php` por segurança
5. Quando precisar alterar novamente, faça upload do arquivo

---

## 📁 Arquivos Criados

### **Arquivos Principais**
- `configuracoes.php` - Painel de configurações White Label
- `sistema_theme.php` - CSS dinâmico com variáveis
- `migration_whitelabel_v2.sql` - Migration das novas tabelas
- `admin_artigos.php` - Gerenciamento de artigos de ajuda
- `ajuda.php` - Página de ajuda para usuários
- `dev_footer.php` - Página secreta para editar rodapé
- `assets/footer.php` - Componente de rodapé dinâmico

### **Tabelas Criadas**
- `configuracoes_visual` - Configurações de cores e visual
- `paletas_cores` - Paletas pré-definidas
- `artigos_ajuda` - Artigos de ajuda/tutoriais
- `menu_personalizado` - Atalhos por usuário (futuro)
- `rodape_sistema` - Informações de desenvolvedor/licença

---

## 🎨 Paletas Disponíveis

### **ESCURAS**

#### 1️⃣ **Atual** (Padrão)
- Amarelo vibrante (#FFC107) + Preto
- Perfeita para destaque e contraste

#### 2️⃣ **Nubank**
- Roxo vibrante (#8A05BE) + Preto profundo
- Moderna e elegante

#### 3️⃣ **Banco Next**
- Verde neon (#00d86a) + Preto
- Enérgica e jovem

#### 4️⃣ **Neon**
- Azul elétrico (#00cfff) + Preto
- Futurista e tecnológica

#### 5️⃣ **Banco Rico**
- Laranja premium (#ff6b00) + Preto
- Sofisticada e impactante

### **CLARAS**

#### 6️⃣ **Aurora**
- Rosa e dourado (#ff6b9d) + Branco
- Suave e feminina

#### 7️⃣ **Oceano**
- Azul celeste (#0099ff) + Branco
- Calma e profissional

#### 8️⃣ **Menta**
- Verde água (#00bfa5) + Branco
- Refrescante e clean

---

## 🔧 Personalização Avançada

### **Cores Personalizadas - O que cada uma controla:**

| Cor | Onde é Usada |
|-----|--------------|
| **Primária** | Botões principais, links, badges, destaques |
| **Secundária** | Fundos secundários, headers, menus, rodapés |
| **Fundo** | Fundo principal de todas as páginas (body) |
| **Card** | Cards, modais, containers, formulários, tabelas |
| **Texto Principal** | Títulos, textos importantes, labels principais |
| **Texto Secundário** | Textos de apoio, descrições, placeholders |
| **Borda** | Bordas de inputs, cards, tabelas, separadores |
| **Sucesso** | Mensagens de sucesso, status "concluído/aprovado" |
| **Erro** | Mensagens de erro, status "cancelado/rejeitado" |
| **Aviso** | Avisos, status "pendente", notificações |
| **Info** | Mensagens informativas, status "processando" |
| **Hover** | Efeito ao passar mouse sobre elementos interativos |

### **CSS Variables Geradas**

O sistema cria automaticamente estas variáveis CSS:

```css
:root {
    --cor-primaria: #FFC107;
    --cor-secundaria: #1a1a1a;
    --cor-fundo: #000000;
    --cor-card: #1a1a1a;
    --cor-texto: #ffffff;
    --cor-texto-secundario: #b0b0b0;
    --cor-borda: #333333;
    --cor-sucesso: #28a745;
    --cor-erro: #dc3545;
    --cor-aviso: #ffc107;
    --cor-info: #17a2b8;
    --cor-hover: #FFD54F;
}
```

Todas as páginas do sistema usam automaticamente essas variáveis!

---

## 📝 Dicas de Uso

### **Para Contraste Perfeito:**
- **Tema Escuro**: Use cores de texto claras (#ffffff, #f0f0f0)
- **Tema Claro**: Use cores de texto escuras (#1a1a1a, #333333)

### **Para Acessibilidade:**
- Mantenha bom contraste entre fundo e texto
- Use a cor primária apenas para destaques
- Evite cores muito similares para texto e fundo

### **Para Profissionalismo:**
- Use no máximo 3 cores principais
- Mantenha consistência nas cores de status (sucesso=verde, erro=vermelho)
- Paletas claras são mais formais, escuras são mais modernas

---

## 🔐 Segurança

### **Página dev_footer.php**
- ⚠️ **NÃO** deixe este arquivo no servidor em produção
- Use apenas quando precisar editar o rodapé
- Após salvar, **DELETE O ARQUIVO**
- Faça upload novamente quando precisar de mudanças

### **Permissões**
- Apenas **Admin** pode:
  - Acessar Configurações
  - Criar/editar artigos de ajuda
  - Acessar dev_footer.php

---

## 🆕 Próximas Versões

### **Em Desenvolvimento:**
- [ ] Menu Tipo 2: Rodapé fixo com atalhos personalizáveis
- [ ] Menu Tipo 3: Grid estilo banco mobile-first
- [ ] Personalização de atalhos por usuário
- [ ] Upload de favicon personalizado
- [ ] Modo claro/escuro automático
- [ ] Temas sazonais (Natal, Halloween, etc.)

---

## 🐛 Troubleshooting

### **As cores não mudaram após salvar**
1. Limpe o cache do navegador (Ctrl+Shift+Delete)
2. Verifique se a migration foi executada
3. Confirme que salvou as configurações

### **Logo não aparece**
1. Verifique se a pasta `/uploads/sistema/` existe
2. Confirme permissões de escrita (chmod 777)
3. Verifique o tamanho do arquivo (máx 5MB)

### **Artigos não aparecem na página Ajuda**
1. Confirme que o artigo está **Publicado**
2. Verifique a **Visibilidade** (todos/promoter/produtor)
3. Verifique se a migration foi executada

### **Erro: "Execute a migration..."**
Execute o arquivo `migration_whitelabel_v2.sql` no banco de dados

---

## 📞 Suporte

Para dúvidas ou sugestões sobre o White Label v2.0, entre em contato com o desenvolvedor.

---

## 🎉 Conclusão

Com o **White Label v2.0**, você tem controle total sobre a aparência do sistema. Personalize cores, logo, nome e crie sua própria identidade visual única!

**Divirta-se personalizando!** 🚀

---

**Desenvolvido com 💛 para a comunidade**
**Versão: 2.0** | **Data: 2025**
