<?php
// SUBSTITUIR_CONFIG_AGORA.php - FORÇA a substituição do config.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html>
<html lang='pt-BR'>
<head>
    <meta charset='UTF-8'>
    <title>Substituir config.php - URGENTE</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; }
        .success { background: #d4edda; border-left: 4px solid #28a745; padding: 15px; margin: 20px 0; color: #155724; }
        .error { background: #f8d7da; border-left: 4px solid #dc3545; padding: 15px; margin: 20px 0; color: #721c24; }
        .warning { background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0; color: #856404; }
        .btn {
            background: #667eea;
            color: white;
            padding: 15px 30px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin: 10px 5px;
        }
        .btn:hover { background: #5568d3; }
        .btn-danger {
            background: #dc3545;
        }
        .btn-danger:hover {
            background: #c82333;
        }
        code {
            background: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: monospace;
        }
        pre {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            font-size: 12px;
        }
    </style>
</head>
<body>
<div class='container'>";

$config_path = __DIR__ . '/config.php';

// Conteúdo CORRETO do config.php
$config_correto = <<<'PHP'
<?php
// config.php - Configuração do Sistema
// IMPORTANTE: Salve como UTF-8 sem BOM

// Iniciar output buffering
if (ob_get_level() == 0) {
    ob_start();
}

// Iniciar sessão (CORRETO: PHP_SESSION_NONE)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Configurações do Banco de Dados
define('DB_HOST', 'localhost');
define('DB_PORT', '3306');
define('DB_NAME', 'invitmecom_promosis');
define('DB_USER', 'invitmecom_promosis');
define('DB_PASS', 'rH]&iG%{ysipNDnB');

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Conexão com Banco de Dados
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch(PDOException $e) {
    error_log("Erro na conexão: " . $e->getMessage());
    die("Erro ao conectar no banco de dados: " . $e->getMessage());
}

// ====================================
// FUNÇÕES AUXILIARES
// ====================================

function verificarLogin() {
    if (!isset($_SESSION['user_id'])) {
        header('Location: login.php');
        exit;
    }
}

function verificarRole($roles_permitidas) {
    verificarLogin();
    if (!in_array($_SESSION['role'], $roles_permitidas)) {
        header('Location: dashboard.php');
        exit;
    }
}

function gerarToken($tamanho = 32) {
    return bin2hex(random_bytes($tamanho));
}

function formatarMoeda($valor) {
    if ($valor === null || $valor === '') {
        return 'R$ 0,00';
    }
    return 'R$ ' . number_format(floatval($valor), 2, ',', '.');
}

function formatarData($data) {
    if (empty($data)) {
        return '-';
    }
    try {
        $timestamp = strtotime($data);
        if ($timestamp === false) {
            return '-';
        }
        return date('d/m/Y', $timestamp);
    } catch (Exception $e) {
        return '-';
    }
}

function formatarDataHora($data) {
    if (empty($data)) {
        return '-';
    }
    try {
        $timestamp = strtotime($data);
        if ($timestamp === false) {
            return '-';
        }
        return date('d/m/Y H:i', $timestamp);
    } catch (Exception $e) {
        return '-';
    }
}

function sanitizar($string) {
    if (is_array($string)) {
        return array_map('sanitizar', $string);
    }
    return htmlspecialchars(trim($string), ENT_QUOTES, 'UTF-8');
}

function validarEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

function validarTelefone($telefone) {
    $telefone = preg_replace('/[^0-9]/', '', $telefone);
    return strlen($telefone) >= 10 && strlen($telefone) <= 11;
}

function gerarQRCode() {
    return strtoupper(bin2hex(random_bytes(8)));
}

function logErro($mensagem, $arquivo = '', $linha = '') {
    $log = date('[Y-m-d H:i:s] ');
    if ($arquivo) {
        $log .= "[$arquivo";
        if ($linha) {
            $log .= ":$linha";
        }
        $log .= "] ";
    }
    $log .= $mensagem . "\n";

    $log_dir = __DIR__ . '/logs';
    if (!is_dir($log_dir)) {
        @mkdir($log_dir, 0755, true);
    }

    @error_log($log, 3, $log_dir . '/erros.log');
}
?>
PHP;

// Verificar se foi solicitada a substituição
if (isset($_POST['substituir'])) {
    echo "<h1>🔄 Substituindo config.php...</h1>";

    // Fazer backup do arquivo antigo
    if (file_exists($config_path)) {
        $backup_path = $config_path . '.backup_' . date('YmdHis');
        if (copy($config_path, $backup_path)) {
            echo "<div class='success'>✅ Backup criado: " . basename($backup_path) . "</div>";
        }

        // DELETAR o arquivo antigo
        if (unlink($config_path)) {
            echo "<div class='success'>✅ Arquivo antigo DELETADO com sucesso!</div>";
        } else {
            echo "<div class='error'>❌ Erro ao deletar arquivo antigo. Permissões insuficientes.</div>";
        }
    }

    // Escrever o novo arquivo
    $resultado = file_put_contents($config_path, $config_correto);

    if ($resultado !== false) {
        chmod($config_path, 0644);

        echo "<div class='success'>";
        echo "<h3>✅ config.php SUBSTITUÍDO COM SUCESSO!</h3>";
        echo "<p>Tamanho: $resultado bytes</p>";
        echo "<p>Última modificação: " . date('d/m/Y H:i:s', filemtime($config_path)) . "</p>";
        echo "</div>";

        // Limpar caches
        if (function_exists('opcache_reset')) {
            opcache_reset();
            echo "<div class='success'>✅ OPcache limpo</div>";
        }

        if (function_exists('opcache_invalidate')) {
            opcache_invalidate($config_path, true);
            echo "<div class='success'>✅ Cache do config.php invalidado</div>";
        }

        clearstatcache(true);

        // Verificar se está correto
        $conteudo_novo = file_get_contents($config_path);
        $tem_erro = (strpos($conteudo_novo, 'PHP_STATUS_NONE') !== false);
        $tem_correto = (strpos($conteudo_novo, 'PHP_SESSION_NONE') !== false);

        echo "<div class='warning'>";
        echo "<h3>🔍 Verificação:</h3>";
        echo "<p><strong>Contém PHP_STATUS_NONE (ERRADO)?</strong> " . ($tem_erro ? '❌ SIM - PROBLEMA!' : '✅ NÃO') . "</p>";
        echo "<p><strong>Contém PHP_SESSION_NONE (CORRETO)?</strong> " . ($tem_correto ? '✅ SIM' : '❌ NÃO - PROBLEMA!') . "</p>";
        echo "</div>";

        if (!$tem_erro && $tem_correto) {
            echo "<div class='success'>";
            echo "<h2>🎉 TUDO CERTO! Agora teste:</h2>";
            echo "<p><a href='install_direto.php' class='btn'>➡️ Acessar Instalador Direto</a></p>";
            echo "<p><a href='login.php' class='btn'>➡️ Acessar Login</a></p>";
            echo "</div>";
        } else {
            echo "<div class='error'>";
            echo "<h3>⚠️ Arquivo criado mas parece incorreto!</h3>";
            echo "<p>Pode ser cache do servidor. Aguarde 1 minuto e teste novamente.</p>";
            echo "</div>";
        }

    } else {
        echo "<div class='error'>";
        echo "<h3>❌ ERRO ao criar config.php</h3>";
        echo "<p>Permissões insuficientes. Você precisa alterar as permissões da pasta via cPanel.</p>";
        echo "</div>";
    }

} else {
    // Mostrar diagnóstico atual
    echo "<h1>🔍 Diagnóstico do config.php</h1>";

    if (file_exists($config_path)) {
        echo "<div class='warning'>";
        echo "<h3>📄 Arquivo config.php encontrado:</h3>";
        echo "<p><strong>Caminho:</strong> <code>$config_path</code></p>";
        echo "<p><strong>Tamanho:</strong> " . filesize($config_path) . " bytes</p>";
        echo "<p><strong>Última modificação:</strong> " . date('d/m/Y H:i:s', filemtime($config_path)) . "</p>";
        echo "<p><strong>Permissões:</strong> " . substr(sprintf('%o', fileperms($config_path)), -4) . "</p>";
        echo "</div>";

        // Ler e verificar conteúdo
        $conteudo_atual = file_get_contents($config_path);
        $linhas = file($config_path);

        echo "<div class='error'>";
        echo "<h3>❌ PROBLEMA ENCONTRADO:</h3>";

        if (strpos($conteudo_atual, 'PHP_STATUS_NONE') !== false) {
            echo "<p><strong>O arquivo contém PHP_STATUS_NONE (ERRADO)!</strong></p>";

            // Mostrar as linhas problemáticas
            echo "<p>Linhas com erro:</p>";
            echo "<pre>";
            foreach ($linhas as $num => $linha) {
                if (strpos($linha, 'PHP_STATUS_NONE') !== false) {
                    $num_linha = $num + 1;
                    echo "Linha $num_linha: " . htmlspecialchars($linha);
                }
            }
            echo "</pre>";
        }

        echo "</div>";

        echo "<div class='warning'>";
        echo "<h3>📋 Prévia do arquivo atual (linhas 1-25):</h3>";
        echo "<pre>";
        for ($i = 0; $i < min(25, count($linhas)); $i++) {
            $num = $i + 1;
            echo sprintf("%3d: ", $num) . htmlspecialchars($linhas[$i]);
        }
        echo "</pre>";
        echo "</div>";

    } else {
        echo "<div class='error'>";
        echo "<h3>❌ config.php NÃO ENCONTRADO!</h3>";
        echo "<p>O arquivo será criado quando você clicar no botão abaixo.</p>";
        echo "</div>";
    }

    // Botão para substituir
    echo "<div class='warning'>";
    echo "<h3>⚠️ ATENÇÃO</h3>";
    echo "<p>Ao clicar no botão abaixo, o script vai:</p>";
    echo "<ol>";
    echo "<li>Fazer backup do config.php atual (se existir)</li>";
    echo "<li>DELETAR o config.php antigo</li>";
    echo "<li>Criar um NOVO config.php CORRETO</li>";
    echo "<li>Limpar todos os caches do PHP</li>";
    echo "</ol>";
    echo "<form method='POST'>";
    echo "<button type='submit' name='substituir' value='1' class='btn btn-danger'>🔥 SUBSTITUIR config.php AGORA</button>";
    echo "</form>";
    echo "</div>";
}

echo "</div></body></html>";
?>
