# 🚨 URGENTE: SUBSTITUIR config.php NO SERVIDOR

## ❌ PROBLEMA ATUAL

O arquivo `config.php` **no seu servidor** ainda tem o erro antigo:
```
Fatal error: Undefined constant "PHP_STATUS_NONE" in config.php:21
```

O repositório está CORRETO, mas o servidor tem a versão ERRADA!

---

## ✅ SOLUÇÃO: SUBSTITUIR O ARQUIVO

### **OPÇÃO 1: Via cPanel File Manager (MAIS FÁCIL)**

#### **PASSO 1: Fazer Backup do Arquivo Antigo**
1. Acesse **cPanel** → **Gerenciador de Arquivos** (File Manager)
2. Navegue até: `/public_html/sis/`
3. Encontre o arquivo: `config.php`
4. **Clique direito** no arquivo → **Rename**
5. Renomeie para: `config_OLD_ERRO.php`

#### **PASSO 2: Fazer Upload do Arquivo Correto**
1. No mesmo diretório (`/public_html/sis/`)
2. Clique em **Upload** (botão no topo)
3. Selecione o arquivo: `config_SUBSTITUA_NO_SERVIDOR.php` (do repositório)
4. Aguarde o upload terminar
5. **Clique direito** no arquivo → **Rename**
6. Renomeie para: `config.php`

#### **PASSO 3: Verificar Permissões**
1. **Clique direito** em `config.php` → **Permissions**
2. Configure para: **644** (ou selecione: Owner: Read/Write, Group: Read, Public: Read)
3. Clique em **Change Permissions**

#### **PASSO 4: Testar**
Acesse: `https://promo.taal.luminaink.com.br/sis/install.php`

---

### **OPÇÃO 2: Via FTP (FileZilla, WinSCP, etc)**

1. Conecte no servidor FTP
2. Navegue até: `/public_html/sis/`
3. **Baixe** o `config.php` atual (backup)
4. **Delete** o `config.php` do servidor
5. **Envie** o arquivo `config_SUBSTITUA_NO_SERVIDOR.php`
6. **Renomeie** para `config.php`

---

### **OPÇÃO 3: Editar Diretamente no cPanel**

Se não conseguir fazer upload, edite manualmente:

1. Acesse **cPanel** → **Gerenciador de Arquivos**
2. Vá em: `/public_html/sis/`
3. **Clique direito** em `config.php` → **Edit**
4. **APAGUE TODO O CONTEÚDO** do arquivo
5. **COLE O CÓDIGO ABAIXO:**

```php
<?php
// config.php - Configuração do Sistema
// IMPORTANTE: Salve como UTF-8 sem BOM

// Iniciar output buffering
if (ob_get_level() == 0) {
    ob_start();
}

// Iniciar sessão (CORRETO: PHP_SESSION_NONE)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Configurações do Banco de Dados
define('DB_HOST', 'localhost');
define('DB_PORT', '3306');
define('DB_NAME', 'invitmecom_promosis');
define('DB_USER', 'invitmecom_promosis');
define('DB_PASS', 'rH]&iG%{ysipNDnB');

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Conexão com Banco de Dados
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch(PDOException $e) {
    error_log("Erro na conexão: " . $e->getMessage());
    die("Erro ao conectar no banco de dados: " . $e->getMessage());
}

// ====================================
// FUNÇÕES AUXILIARES
// ====================================

function verificarLogin() {
    if (!isset($_SESSION['user_id'])) {
        header('Location: login.php');
        exit;
    }
}

function verificarRole($roles_permitidas) {
    verificarLogin();
    if (!in_array($_SESSION['role'], $roles_permitidas)) {
        header('Location: dashboard.php');
        exit;
    }
}

function gerarToken($tamanho = 32) {
    return bin2hex(random_bytes($tamanho));
}

function formatarMoeda($valor) {
    if ($valor === null || $valor === '') {
        return 'R$ 0,00';
    }
    return 'R$ ' . number_format(floatval($valor), 2, ',', '.');
}

function formatarData($data) {
    if (empty($data)) {
        return '-';
    }
    try {
        $timestamp = strtotime($data);
        if ($timestamp === false) {
            return '-';
        }
        return date('d/m/Y', $timestamp);
    } catch (Exception $e) {
        return '-';
    }
}

function formatarDataHora($data) {
    if (empty($data)) {
        return '-';
    }
    try {
        $timestamp = strtotime($data);
        if ($timestamp === false) {
            return '-';
        }
        return date('d/m/Y H:i', $timestamp);
    } catch (Exception $e) {
        return '-';
    }
}

function sanitizar($string) {
    if (is_array($string)) {
        return array_map('sanitizar', $string);
    }
    return htmlspecialchars(trim($string), ENT_QUOTES, 'UTF-8');
}

function validarEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

function validarTelefone($telefone) {
    $telefone = preg_replace('/[^0-9]/', '', $telefone);
    return strlen($telefone) >= 10 && strlen($telefone) <= 11;
}

function gerarQRCode() {
    return strtoupper(bin2hex(random_bytes(8)));
}

function logErro($mensagem, $arquivo = '', $linha = '') {
    $log = date('[Y-m-d H:i:s] ');
    if ($arquivo) {
        $log .= "[$arquivo";
        if ($linha) {
            $log .= ":$linha";
        }
        $log .= "] ";
    }
    $log .= $mensagem . "\n";

    $log_dir = __DIR__ . '/logs';
    if (!is_dir($log_dir)) {
        @mkdir($log_dir, 0755, true);
    }

    @error_log($log, 3, $log_dir . '/erros.log');
}
?>
```

6. Clique em **Save Changes** (Salvar Alterações)
7. **FECHE o editor**

---

## 🔍 VERIFICAR SE DEU CERTO

Depois de substituir, acesse:
```
https://promo.taal.luminaink.com.br/sis/install.php
```

### **✅ Se funcionou:**
Você verá a tela de instalação sem erros

### **❌ Se ainda der erro:**
Envie uma captura de tela do erro COMPLETO

---

## ⚠️ PONTOS IMPORTANTES

1. O arquivo no repositório está **CORRETO**
2. O problema é que o servidor tem a versão **ANTIGA/ERRADA**
3. Você PRECISA **SUBSTITUIR FISICAMENTE** o arquivo no servidor
4. **NÃO É PROBLEMA DE CACHE** - é o arquivo errado mesmo

---

## 📝 CHECKLIST

- [ ] Acessei o cPanel
- [ ] Fui em Gerenciador de Arquivos
- [ ] Naveguei até `/public_html/sis/`
- [ ] Renomeei o `config.php` antigo para `config_OLD_ERRO.php`
- [ ] Fiz upload do `config_SUBSTITUA_NO_SERVIDOR.php`
- [ ] Renomeei para `config.php`
- [ ] Configurei permissões 644
- [ ] Testei acessando install.php
- [ ] Funcionou! ✅

---

## 🆘 SE AINDA NÃO FUNCIONAR

Me envie:
1. Captura de tela do erro
2. Confirmação de que substituiu o arquivo
3. Conteúdo da linha 11 do config.php no servidor (via editor do cPanel)

Deve estar assim:
```php
if (session_status() === PHP_SESSION_NONE) {
```

**NÃO** deve estar assim:
```php
if (session_status() === PHP_STATUS_NONE) {  ❌ ERRADO
```
