<?php
// adicionar_colunas_cadastro.php - Adiciona colunas necessárias para o cadastro
error_reporting(E_ALL);
ini_set('display_errors', 1);

$DB_HOST = 'localhost';
$DB_PORT = '3306';
$DB_NAME = 'invitmecom_promosis';
$DB_USER = 'invitmecom_promosis';
$DB_PASS = 'rH]&iG%{ysipNDnB';

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Adicionar Colunas para Cadastro</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; margin-bottom: 20px; }
        h2 { color: #764ba2; margin: 25px 0 15px 0; border-bottom: 2px solid #667eea; padding-bottom: 10px; }
        .success { background: #d4edda; color: #155724; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #28a745; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #dc3545; }
        .warning { background: #fff3cd; color: #856404; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #ffc107; }
        .info { background: #d1ecf1; color: #0c5460; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #17a2b8; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto; font-size: 12px; border: 1px solid #dee2e6; }
        table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        table th { background: #667eea; color: white; padding: 10px; text-align: left; font-size: 12px; }
        table td { padding: 8px 10px; border-bottom: 1px solid #ddd; font-size: 12px; }
        .btn { background: #28a745; color: white; padding: 15px 30px; border: none; border-radius: 8px; font-size: 16px; cursor: pointer; }
        .btn:hover { background: #218838; }
    </style>
</head>
<body>
<div class="container">
    <h1>🔧 Adicionar Colunas para Cadastro</h1>

<?php
try {
    $pdo = new PDO(
        "mysql:host=$DB_HOST;port=$DB_PORT;dbname=$DB_NAME;charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );

    echo "<div class='success'>";
    echo "<p>✅ Conectado ao banco: <strong>$DB_NAME</strong></p>";
    echo "</div>";

    // 1. Verificar estrutura atual
    echo "<h2>📊 Estrutura Atual da Tabela 'usuarios'</h2>";

    $stmt = $pdo->query("DESCRIBE usuarios");
    $columns = $stmt->fetchAll();

    $colunas_existentes = [];
    foreach ($columns as $col) {
        $colunas_existentes[] = $col['Field'];
    }

    echo "<div class='info'>";
    echo "<p><strong>Colunas existentes:</strong></p>";
    echo "<pre>" . implode(", ", $colunas_existentes) . "</pre>";
    echo "</div>";

    // 2. Definir colunas necessárias para o cadastro
    $colunas_necessarias = [
        'telefone' => "VARCHAR(20) DEFAULT NULL COMMENT 'Telefone do usuário'",
        'instagram' => "VARCHAR(100) DEFAULT NULL COMMENT 'Instagram do usuário (@usuario)'",
        'cidade' => "VARCHAR(100) DEFAULT NULL COMMENT 'Cidade do usuário'",
        'bairro' => "VARCHAR(100) DEFAULT NULL COMMENT 'Bairro do usuário'",
        'idade' => "INT DEFAULT NULL COMMENT 'Idade do usuário'",
        'foto_perfil' => "VARCHAR(255) DEFAULT NULL COMMENT 'Caminho da foto de perfil'",
    ];

    // 3. Verificar quais colunas faltam
    $colunas_faltantes = [];
    foreach ($colunas_necessarias as $coluna => $definicao) {
        if (!in_array($coluna, $colunas_existentes)) {
            $colunas_faltantes[$coluna] = $definicao;
        }
    }

    if (empty($colunas_faltantes)) {
        echo "<div class='success'>";
        echo "<h3>✅ Todas as colunas já existem!</h3>";
        echo "<p>A tabela 'usuarios' já tem todas as colunas necessárias para o cadastro.</p>";
        echo "<p><a href='login.php' class='btn' style='display: inline-block; text-decoration: none;'>➡️ IR PARA LOGIN</a></p>";
        echo "</div>";
    } else {
        echo "<div class='warning'>";
        echo "<h3>⚠️ Faltam " . count($colunas_faltantes) . " colunas!</h3>";
        echo "<p><strong>Colunas que precisam ser adicionadas:</strong></p>";
        echo "<table>";
        echo "<tr><th>Coluna</th><th>Definição</th></tr>";
        foreach ($colunas_faltantes as $coluna => $definicao) {
            echo "<tr>";
            echo "<td><strong>$coluna</strong></td>";
            echo "<td><code>$definicao</code></td>";
            echo "</tr>";
        }
        echo "</table>";
        echo "</div>";

        // Processar adição de colunas
        if (isset($_POST['adicionar'])) {
            echo "<h2>🔨 Adicionando Colunas...</h2>";

            $sucesso = 0;
            $erros = 0;

            echo "<pre>";
            foreach ($colunas_faltantes as $coluna => $definicao) {
                $sql = "ALTER TABLE usuarios ADD COLUMN $coluna $definicao";

                try {
                    $pdo->exec($sql);
                    echo "✅ Coluna '$coluna' adicionada com sucesso\n";
                    $sucesso++;
                } catch (PDOException $e) {
                    echo "❌ Erro ao adicionar '$coluna': " . $e->getMessage() . "\n";
                    $erros++;
                }
            }
            echo "</pre>";

            if ($erros === 0) {
                echo "<div class='success'>";
                echo "<h3>🎉 Sucesso!</h3>";
                echo "<p><strong>$sucesso</strong> colunas adicionadas com sucesso!</p>";
                echo "<hr style='margin: 20px 0;'>";
                echo "<h4>✅ Agora você pode:</h4>";
                echo "<p><a href='login.php' class='btn' style='display: inline-block; text-decoration: none; margin: 10px 5px 5px 0;'>🚀 IR PARA LOGIN</a></p>";
                echo "<p><a href='testar_login_direto.php' class='btn' style='display: inline-block; text-decoration: none; background: #667eea;'>🧪 TESTAR LOGIN</a></p>";
                echo "</div>";
            } else {
                echo "<div class='error'>";
                echo "<h3>⚠️ Correção Parcial</h3>";
                echo "<p>Sucessos: <strong>$sucesso</strong></p>";
                echo "<p>Erros: <strong>$erros</strong></p>";
                echo "</div>";
            }

        } else {
            echo "<form method='POST'>";
            echo "<button type='submit' name='adicionar' class='btn'>🔨 ADICIONAR COLUNAS AGORA</button>";
            echo "</form>";
        }
    }

} catch (PDOException $e) {
    echo "<div class='error'>";
    echo "<h3>❌ Erro de Conexão</h3>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}
?>

</div>
</body>
</html>
