<?php
// admin_eventos.php - VERSAO COM CATEGORIA DE EVENTOS
require_once 'config.php';
verificarRole(['admin']);

$sucesso = '';
$erro = '';

// Criar evento
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['criar_evento'])) {
    $nome = htmlspecialchars(trim($_POST['nome'] ?? ''), ENT_QUOTES, 'UTF-8');
    $data = $_POST['data'];
    $hora = $_POST['hora'];
    $valor_comissao = floatval($_POST['valor_comissao']);
    $minimo_lista = intval($_POST['minimo_lista']);
    $informacoes_importantes = htmlspecialchars(trim($_POST['informacoes_importantes'] ?? ''), ENT_QUOTES, 'UTF-8');

    // NOVO: Capturar tipo de evento
    $event_type = htmlspecialchars(trim($_POST['event_type'] ?? ''), ENT_QUOTES, 'UTF-8');
    $event_type_other = '';
    if ($event_type === 'Outros') {
        $event_type_other = htmlspecialchars(trim($_POST['event_type_other'] ?? ''), ENT_QUOTES, 'UTF-8');
    }
    
    // Upload da imagem principal
    $imagem = '';
    if (isset($_FILES['imagem']) && $_FILES['imagem']['error'] === 0) {
        $extensao = pathinfo($_FILES['imagem']['name'], PATHINFO_EXTENSION);
        $nome_arquivo = uniqid() . '.' . $extensao;
        $caminho = 'uploads/eventos/' . $nome_arquivo;
        
        if (!is_dir('uploads/eventos')) {
            mkdir('uploads/eventos', 0777, true);
        }
        
        if (move_uploaded_file($_FILES['imagem']['tmp_name'], $caminho)) {
            $imagem = $caminho;
        }
    }
    
    // ATUALIZADO: Incluir event_type e event_type_other na inserção
    $stmt = $pdo->prepare("INSERT INTO eventos (nome, imagem, data, hora, valor_comissao, minimo_lista, informacoes_importantes, event_type, event_type_other) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    if ($stmt->execute([$nome, $imagem, $data, $hora, $valor_comissao, $minimo_lista, $informacoes_importantes, $event_type, $event_type_other])) {
        $evento_id = $pdo->lastInsertId();
        
        // Upload de arquivos promocionais
        if (isset($_FILES['arquivos']) && !empty($_FILES['arquivos']['name'][0])) {
            if (!is_dir('uploads/materiais')) {
                mkdir('uploads/materiais', 0777, true);
            }
            
            $total_arquivos = count($_FILES['arquivos']['name']);
            for ($i = 0; $i < $total_arquivos; $i++) {
                if ($_FILES['arquivos']['error'][$i] === 0) {
                    $nome_original = $_FILES['arquivos']['name'][$i];
                    $extensao = pathinfo($nome_original, PATHINFO_EXTENSION);
                    $nome_unico = uniqid() . '_' . $nome_original;
                    $caminho = 'uploads/materiais/' . $nome_unico;
                    $tamanho = $_FILES['arquivos']['size'][$i];
                    $tipo = $_FILES['arquivos']['type'][$i];
                    
                    if (move_uploaded_file($_FILES['arquivos']['tmp_name'][$i], $caminho)) {
                        $stmt = $pdo->prepare("INSERT INTO evento_arquivos (evento_id, nome_arquivo, caminho_arquivo, tipo_arquivo, tamanho_bytes) VALUES (?, ?, ?, ?, ?)");
                        $stmt->execute([$evento_id, $nome_original, $caminho, $tipo, $tamanho]);
                    }
                }
            }
        }
        
        $sucesso = 'Evento criado com sucesso!';
    } else {
        $erro = 'Erro ao criar evento.';
    }
}

// Editar evento
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['editar_evento'])) {
    $id = intval($_POST['evento_id']);
    $nome = htmlspecialchars(trim($_POST['nome'] ?? ''), ENT_QUOTES, 'UTF-8');
    $data = $_POST['data'];
    $hora = $_POST['hora'];
    $valor_comissao = floatval($_POST['valor_comissao']);
    $minimo_lista = intval($_POST['minimo_lista']);
    $status = $_POST['status'];
    $informacoes_importantes = htmlspecialchars(trim($_POST['informacoes_importantes'] ?? ''), ENT_QUOTES, 'UTF-8');

    // NOVO: Capturar tipo de evento na edição
    $event_type = htmlspecialchars(trim($_POST['event_type'] ?? ''), ENT_QUOTES, 'UTF-8');
    $event_type_other = '';
    if ($event_type === 'Outros') {
        $event_type_other = htmlspecialchars(trim($_POST['event_type_other'] ?? ''), ENT_QUOTES, 'UTF-8');
    }
    
    // ATUALIZADO: Incluir event_type e event_type_other no update
    $stmt = $pdo->prepare("UPDATE eventos SET nome = ?, data = ?, hora = ?, valor_comissao = ?, minimo_lista = ?, status = ?, informacoes_importantes = ?, event_type = ?, event_type_other = ? WHERE id = ?");
    if ($stmt->execute([$nome, $data, $hora, $valor_comissao, $minimo_lista, $status, $informacoes_importantes, $event_type, $event_type_other, $id])) {
        
        // Upload de novos arquivos promocionais
        if (isset($_FILES['arquivos']) && !empty($_FILES['arquivos']['name'][0])) {
            if (!is_dir('uploads/materiais')) {
                mkdir('uploads/materiais', 0777, true);
            }
            
            $total_arquivos = count($_FILES['arquivos']['name']);
            for ($i = 0; $i < $total_arquivos; $i++) {
                if ($_FILES['arquivos']['error'][$i] === 0) {
                    $nome_original = $_FILES['arquivos']['name'][$i];
                    $extensao = pathinfo($nome_original, PATHINFO_EXTENSION);
                    $nome_unico = uniqid() . '_' . $nome_original;
                    $caminho = 'uploads/materiais/' . $nome_unico;
                    $tamanho = $_FILES['arquivos']['size'][$i];
                    $tipo = $_FILES['arquivos']['type'][$i];
                    
                    if (move_uploaded_file($_FILES['arquivos']['tmp_name'][$i], $caminho)) {
                        $stmt = $pdo->prepare("INSERT INTO evento_arquivos (evento_id, nome_arquivo, caminho_arquivo, tipo_arquivo, tamanho_bytes) VALUES (?, ?, ?, ?, ?)");
                        $stmt->execute([$id, $nome_original, $caminho, $tipo, $tamanho]);
                    }
                }
            }
        }
        
        $sucesso = 'Evento atualizado com sucesso!';
    }
}

// Deletar arquivo
if (isset($_GET['deletar_arquivo'])) {
    $arquivo_id = intval($_GET['deletar_arquivo']);
    
    $stmt = $pdo->prepare("SELECT caminho_arquivo FROM evento_arquivos WHERE id = ?");
    $stmt->execute([$arquivo_id]);
    $arquivo = $stmt->fetch();
    
    if ($arquivo && file_exists($arquivo['caminho_arquivo'])) {
        unlink($arquivo['caminho_arquivo']);
    }
    
    $stmt = $pdo->prepare("DELETE FROM evento_arquivos WHERE id = ?");
    $stmt->execute([$arquivo_id]);
    
    $sucesso = 'Arquivo deletado!';
}

// Deletar evento
if (isset($_GET['deletar'])) {
    $id = intval($_GET['deletar']);
    
    // Deletar arquivos relacionados
    $stmt = $pdo->prepare("SELECT caminho_arquivo FROM evento_arquivos WHERE evento_id = ?");
    $stmt->execute([$id]);
    $arquivos = $stmt->fetchAll();
    
    foreach ($arquivos as $arquivo) {
        if (file_exists($arquivo['caminho_arquivo'])) {
            unlink($arquivo['caminho_arquivo']);
        }
    }
    
    $stmt = $pdo->prepare("DELETE FROM eventos WHERE id = ?");
    if ($stmt->execute([$id])) {
        $sucesso = 'Evento deletado com sucesso!';
    }
}

// Buscar todos os eventos
$stmt = $pdo->query("SELECT e.*, 
    (SELECT COUNT(*) FROM produtor_eventos pe WHERE pe.evento_id = e.id) as total_promoters,
    (SELECT COUNT(*) FROM convidados c WHERE c.evento_id = e.id) as total_convidados,
    (SELECT COUNT(*) FROM convidados c WHERE c.evento_id = e.id AND c.checkin = 1) as total_checkins,
    (SELECT COUNT(*) FROM evento_arquivos ea WHERE ea.evento_id = e.id) as total_arquivos
    FROM eventos e ORDER BY e.data DESC");
$eventos = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Eventos - Admin</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        :root[data-theme="dark"] {
            --bg-primary: #000000;
            --bg-secondary: #1a1a1a;
            --bg-card: #2a2a2a;
            --color-primary: #FFD700;
            --color-secondary: #FFA500;
            --color-text: #ffffff;
            --color-text-secondary: #999999;
            --border-color: #333333;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-secondary);
            color: var(--color-text);
        }
        
        .navbar {
            background: var(--bg-primary);
            border-bottom: 2px solid var(--border-color);
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: var(--color-primary);
        }
        
        .nav-link {
            color: var(--color-text);
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 8px;
            margin: 0 5px;
        }
        
        .nav-link:hover {
            background: var(--bg-card);
        }
        
        .container {
            max-width: 1400px;
            margin: 30px auto;
            padding: 0 20px;
        }
        
        .header-section {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            flex-wrap: wrap;
            gap: 20px;
        }
        
        .page-title {
            font-size: 32px;
            color: var(--color-primary);
        }
        
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            font-size: 14px;
            transition: all 0.3s;
            display: inline-block;
        }
        
        .btn-primary {
            background: var(--color-primary);
            color: #000;
        }
        
        .btn-secondary {
            background: var(--bg-card);
            color: var(--color-text);
            border: 1px solid var(--border-color);
        }
        
        .btn-danger {
            background: #ff4444;
            color: white;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(255, 215, 0, 0.2);
        }
        
        .eventos-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 25px;
        }
        
        .evento-card {
            background: var(--bg-card);
            border-radius: 12px;
            overflow: hidden;
            transition: all 0.3s;
            border: 1px solid var(--border-color);
        }
        
        .evento-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5);
        }
        
        .evento-imagem {
            width: 100%;
            height: 200px;
            object-fit: cover;
            background: linear-gradient(45deg, var(--bg-primary), var(--bg-card));
        }
        
        .evento-body {
            padding: 20px;
        }
        
        .evento-titulo {
            font-size: 20px;
            margin-bottom: 15px;
            color: var(--color-primary);
        }
        
        .evento-info {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin-bottom: 20px;
        }
        
        .info-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid var(--border-color);
        }
        
        .info-label {
            color: var(--color-text-secondary);
            font-size: 14px;
        }
        
        .info-value {
            font-weight: bold;
            color: var(--color-text);
        }
        
        .evento-status {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
        }
        
        .status-ativo {
            background: rgba(76, 175, 80, 0.2);
            color: #4CAF50;
        }
        
        .status-inativo {
            background: rgba(255, 152, 0, 0.2);
            color: #FF9800;
        }
        
        .status-finalizado {
            background: rgba(244, 67, 54, 0.2);
            color: #F44336;
        }
        
        .evento-acoes {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
            animation: fadeIn 0.3s;
        }
        
        .modal.active {
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .modal-content {
            background: var(--bg-card);
            border-radius: 12px;
            max-width: 600px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
            animation: slideIn 0.3s;
        }
        
        .modal-header {
            padding: 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .modal-title {
            font-size: 24px;
            color: var(--color-primary);
        }
        
        .close-modal {
            background: none;
            border: none;
            color: var(--color-text);
            font-size: 28px;
            cursor: pointer;
        }
        
        form {
            padding: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: var(--color-text);
            font-weight: 500;
        }
        
        input, select, textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid var(--border-color);
            border-radius: 8px;
            background: var(--bg-secondary);
            color: var(--color-text);
            font-size: 14px;
        }
        
        textarea {
            min-height: 100px;
            resize: vertical;
        }
        
        .grid-2 {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
        }
        
        .grid-3 {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 15px;
        }
        
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            animation: slideIn 0.3s;
        }
        
        .alert-success {
            background: rgba(76, 175, 80, 0.2);
            color: #4CAF50;
            border: 1px solid #4CAF50;
        }
        
        .alert-error {
            background: rgba(244, 67, 54, 0.2);
            color: #F44336;
            border: 1px solid #F44336;
        }
        
        .arquivos-list {
            display: flex;
            flex-direction: column;
            gap: 15px;
            padding: 20px;
        }
        
        .arquivo-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px;
            background: var(--bg-secondary);
            border-radius: 8px;
            border: 1px solid var(--border-color);
        }
        
        .btn-small {
            padding: 6px 12px;
            font-size: 12px;
        }
        
        /* NOVO: Estilos para tipo de evento */
        .event-type-selector {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 10px;
            margin-top: 10px;
        }
        
        .event-type-option {
            display: flex;
            align-items: center;
            padding: 10px;
            border: 2px solid var(--border-color);
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s;
            background: var(--bg-secondary);
        }
        
        .event-type-option:hover {
            border-color: var(--color-primary);
            background: var(--bg-card);
        }
        
        .event-type-option input[type="radio"] {
            width: auto;
            margin-right: 8px;
        }
        
        .event-type-option.selected {
            border-color: var(--color-primary);
            background: rgba(255, 215, 0, 0.1);
        }
        
        .event-type-icon {
            margin-right: 6px;
            font-size: 18px;
        }
        
        .event-type-other-input {
            margin-top: 10px;
            display: none;
        }
        
        .event-type-other-input.show {
            display: block;
        }
        
        .event-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 10px;
            background: rgba(255, 215, 0, 0.2);
            color: var(--color-primary);
            border-radius: 15px;
            font-size: 12px;
            margin-top: 10px;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        @keyframes slideIn {
            from { transform: translateY(-50px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        
        @media (max-width: 768px) {
            .eventos-grid {
                grid-template-columns: 1fr;
            }
            
            .grid-2, .grid-3 {
                grid-template-columns: 1fr;
            }
            
            .event-type-selector {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <?php include 'assets/sidebar-navbar.php'; ?>

    <div class="main-content">
        <div class="content-wrapper">
            <div class="container">
        <?php if ($sucesso): ?>
            <div class="alert alert-success"><?php echo $sucesso; ?></div>
        <?php endif; ?>
        
        <?php if ($erro): ?>
            <div class="alert alert-error"><?php echo $erro; ?></div>
        <?php endif; ?>
        
        <div class="header-section">
            <h1 class="page-title"><i class="fas fa-calendar-alt"></i> Gerenciar Eventos</h1>
            <button class="btn btn-primary" onclick="openModal('modalCriarEvento')">
                ➕ Criar Novo Evento
            </button>
        </div>
        
        <div class="eventos-grid">
            <?php foreach ($eventos as $evento): ?>
            <div class="evento-card">
                <?php if ($evento['imagem']): ?>
                    <img src="<?php echo $evento['imagem']; ?>" alt="<?php echo htmlspecialchars($evento['nome']); ?>" class="evento-imagem">
                <?php else: ?>
                    <div class="evento-imagem" style="display: flex; align-items: center; justify-content: center; font-size: 48px;">
                        <i class="fas fa-glass-cheers"></i>
                    </div>
                <?php endif; ?>
                
                <div class="evento-body">
                    <h3 class="evento-titulo"><?php echo htmlspecialchars($evento['nome']); ?></h3>
                    
                    <?php if ($evento['event_type']): ?>
                        <div class="event-badge">
                            <span class="event-type-icon">♪</span>
                            <?php 
                                if ($evento['event_type'] === 'Outros' && $evento['event_type_other']) {
                                    echo htmlspecialchars($evento['event_type_other']);
                                } else {
                                    echo htmlspecialchars($evento['event_type']);
                                }
                            ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="evento-info">
                        <div class="info-item">
                            <span class="info-label"><i class="fas fa-calendar-alt"></i> Data</span>
                            <span class="info-value"><?php echo date('d/m/Y', strtotime($evento['data'])); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">⏰ Hora</span>
                            <span class="info-value"><?php echo substr($evento['hora'], 0, 5); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label"><i class="fas fa-money-bill-wave"></i> Comissão</span>
                            <span class="info-value">R$ <?php echo number_format($evento['valor_comissao'], 2, ',', '.'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label"><i class="fas fa-chart-bar"></i> Mínimo Lista</span>
                            <span class="info-value"><?php echo $evento['minimo_lista']; ?> pessoas</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label"><i class="fas fa-users"></i> Promoters</span>
                            <span class="info-value"><?php echo $evento['total_promoters']; ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">📝 Convidados</span>
                            <span class="info-value"><?php echo $evento['total_convidados']; ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label"><i class="fas fa-check-circle"></i> Check-ins</span>
                            <span class="info-value"><?php echo $evento['total_checkins']; ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Status</span>
                            <span class="evento-status status-<?php echo $evento['status']; ?>">
                                <?php echo ucfirst($evento['status']); ?>
                            </span>
                        </div>
                    </div>
                    
                    <div class="evento-acoes">
                        <button class="btn btn-secondary" onclick="editarEvento(<?php echo htmlspecialchars(json_encode($evento)); ?>)">
                            ✏️ Editar
                        </button>
                        <button class="btn btn-secondary" onclick="gerenciarArquivos(<?php echo $evento['id']; ?>, '<?php echo addslashes($evento['nome']); ?>')">
                            📁 Materiais (<?php echo $evento['total_arquivos']; ?>)
                        </button>
                        <a href="?deletar=<?php echo $evento['id']; ?>" class="btn btn-danger" onclick="return confirm('Tem certeza? Isto deletará todos os convidados e arquivos relacionados!')">
                            🗑️ Deletar
                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

            </div><!-- .container -->
        </div><!-- .content-wrapper -->
    </div><!-- .main-content -->

    <!-- Modal Criar Evento -->
    <div id="modalCriarEvento" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title">➕ Criar Novo Evento</div>
                <button class="close-modal" onclick="closeModal('modalCriarEvento')">&times;</button>
            </div>
            
            <form method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label>Nome do Evento</label>
                    <input type="text" name="nome" required placeholder="Ex: Baile do Taal">
                </div>
                
                <!-- NOVO: Campo de tipo de evento -->
                <div class="form-group">
                    <label>Tipo de Evento</label>
                    <div class="event-type-selector">
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Pagode" required>
                            <span><span class="event-type-icon">♪</span> Pagode</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Sertanejo" required>
                            <span><span class="event-type-icon">♪</span> Sertanejo</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Eletronico" required>
                            <span><span class="event-type-icon">♪</span> Eletrônico</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Rock" required>
                            <span><span class="event-type-icon">♪</span> Rock</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Funk" required>
                            <span><span class="event-type-icon">♪</span> Funk</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Matine" required>
                            <span><span class="event-type-icon">♪</span> Matinê</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Gospel" required>
                            <span><span class="event-type-icon">♪</span> Gospel</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Trap" required>
                            <span><span class="event-type-icon">♪</span> Trap</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Rap" required>
                            <span><span class="event-type-icon">♪</span> Rap</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Outros" required>
                            <span><span class="event-type-icon">♪</span> Outros</span>
                        </label>
                    </div>
                    <div class="event-type-other-input" id="event-type-other-container">
                        <input type="text" name="event_type_other" id="event_type_other" placeholder="Especifique o tipo de evento">
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Imagem do Evento (Flyer Principal)</label>
                    <input type="file" name="imagem" accept="image/*">
                </div>
                
                <div class="grid-2">
                    <div class="form-group">
                        <label>Data</label>
                        <input type="date" name="data" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Hora</label>
                        <input type="time" name="hora" required>
                    </div>
                </div>
                
                <div class="grid-2">
                    <div class="form-group">
                        <label>Valor da Comissão (R$)</label>
                        <input type="number" name="valor_comissao" step="0.01" required placeholder="10.00">
                    </div>
                    
                    <div class="form-group">
                        <label>Mínimo de Pessoas na Lista</label>
                        <input type="number" name="minimo_lista" required placeholder="10">
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Informações Importantes</label>
                    <textarea name="informacoes_importantes" placeholder="Ex: Dress code, horário de abertura, local, etc..."></textarea>
                    <small style="color: var(--color-text-secondary);">Aparecerá no ingresso do convidado</small>
                </div>
                
                <div class="form-group">
                    <label>Materiais Promocionais (Flyers, Artes)</label>
                    <input type="file" name="arquivos[]" multiple accept="image/*,.pdf">
                    <small style="color: var(--color-text-secondary);">Promoters poderão baixar estes arquivos</small>
                </div>
                
                <button type="submit" name="criar_evento" class="btn btn-primary" style="width: 100%;">
                    Criar Evento
                </button>
            </form>
        </div>
    </div>
    
    <!-- Modal Editar Evento -->
    <div id="modalEditarEvento" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title">✏️ Editar Evento</div>
                <button class="close-modal" onclick="closeModal('modalEditarEvento')">&times;</button>
            </div>
            
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="evento_id" id="edit_evento_id">
                
                <div class="form-group">
                    <label>Nome do Evento</label>
                    <input type="text" name="nome" id="edit_nome" required>
                </div>
                
                <!-- NOVO: Campo de tipo de evento na edição -->
                <div class="form-group">
                    <label>Tipo de Evento</label>
                    <div class="event-type-selector">
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Pagode" required>
                            <span><span class="event-type-icon">♪</span> Pagode</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Sertanejo" required>
                            <span><span class="event-type-icon">♪</span> Sertanejo</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Eletronico" required>
                            <span><span class="event-type-icon">♪</span> Eletrônico</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Rock" required>
                            <span><span class="event-type-icon">♪</span> Rock</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Funk" required>
                            <span><span class="event-type-icon">♪</span> Funk</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Matine" required>
                            <span><span class="event-type-icon">♪</span> Matinê</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Gospel" required>
                            <span><span class="event-type-icon">♪</span> Gospel</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Trap" required>
                            <span><span class="event-type-icon">♪</span> Trap</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Rap" required>
                            <span><span class="event-type-icon">♪</span> Rap</span>
                        </label>
                        <label class="event-type-option">
                            <input type="radio" name="event_type" value="Outros" required>
                            <span><span class="event-type-icon">♪</span> Outros</span>
                        </label>
                    </div>
                    <div class="event-type-other-input" id="edit-event-type-other-container">
                        <input type="text" name="event_type_other" id="edit_event_type_other" placeholder="Especifique o tipo de evento">
                    </div>
                </div>
                
                <div class="grid-2">
                    <div class="form-group">
                        <label>Data</label>
                        <input type="date" name="data" id="edit_data" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Hora</label>
                        <input type="time" name="hora" id="edit_hora" required>
                    </div>
                </div>
                
                <div class="grid-3">
                    <div class="form-group">
                        <label>Comissão (R$)</label>
                        <input type="number" name="valor_comissao" id="edit_valor_comissao" step="0.01" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Mínimo Lista</label>
                        <input type="number" name="minimo_lista" id="edit_minimo_lista" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" id="edit_status" required>
                            <option value="ativo">Ativo</option>
                            <option value="inativo">Inativo</option>
                            <option value="finalizado">Finalizado</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Informações Importantes</label>
                    <textarea name="informacoes_importantes" id="edit_informacoes_importantes"></textarea>
                </div>
                
                <div class="form-group">
                    <label>Adicionar Mais Materiais</label>
                    <input type="file" name="arquivos[]" multiple accept="image/*,.pdf">
                </div>
                
                <button type="submit" name="editar_evento" class="btn btn-primary" style="width: 100%;">
                    Salvar Alterações
                </button>
            </form>
        </div>
    </div>
    
    <!-- Modal Gerenciar Arquivos -->
    <div id="modalArquivos" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title" id="arquivos_titulo">📁 Materiais do Evento</div>
                <button class="close-modal" onclick="closeModal('modalArquivos')">&times;</button>
            </div>
            
            <div id="arquivos_content"></div>
        </div>
    </div>
    
    <script>
        const savedTheme = localStorage.getItem('theme') || 'dark';
        document.documentElement.setAttribute('data-theme', savedTheme);
        
        function openModal(modalId) {
            document.getElementById(modalId).classList.add('active');
        }
        
        function closeModal(modalId) {
            document.getElementById(modalId).classList.remove('active');
        }
        
        function editarEvento(evento) {
            document.getElementById('edit_evento_id').value = evento.id;
            document.getElementById('edit_nome').value = evento.nome;
            document.getElementById('edit_data').value = evento.data;
            document.getElementById('edit_hora').value = evento.hora;
            document.getElementById('edit_valor_comissao').value = evento.valor_comissao;
            document.getElementById('edit_minimo_lista').value = evento.minimo_lista;
            document.getElementById('edit_status').value = evento.status;
            document.getElementById('edit_informacoes_importantes').value = evento.informacoes_importantes || '';
            
            // Definir tipo de evento
            if (evento.event_type) {
                const radioButton = document.querySelector(`#modalEditarEvento input[name="event_type"][value="${evento.event_type}"]`);
                if (radioButton) {
                    radioButton.checked = true;
                    radioButton.closest('.event-type-option').classList.add('selected');
                }
                
                if (evento.event_type === 'Outros') {
                    document.getElementById('edit-event-type-other-container').classList.add('show');
                    document.getElementById('edit_event_type_other').value = evento.event_type_other || '';
                } else {
                    document.getElementById('edit-event-type-other-container').classList.remove('show');
                }
            }
            
            openModal('modalEditarEvento');
        }
        
        function gerenciarArquivos(eventoId, eventoNome) {
            document.getElementById('arquivos_titulo').textContent = '📁 Materiais: ' + eventoNome;
            
            // Buscar arquivos via AJAX
            fetch('get_arquivos_evento.php?evento_id=' + eventoId)
                .then(response => response.json())
                .then(data => {
                    let html = '';
                    if (data.length > 0) {
                        html = '<div class="arquivos-list">';
                        data.forEach(arquivo => {
                            const tamanhoMB = (arquivo.tamanho_bytes / 1024 / 1024).toFixed(2);
                            html += `
                                <div class="arquivo-item">
                                    <div>
                                        <strong>${arquivo.nome_arquivo}</strong><br>
                                        <small style="color: var(--color-text-secondary);">${tamanhoMB} MB</small>
                                    </div>
                                    <div style="display: flex; gap: 10px;">
                                        <a href="${arquivo.caminho_arquivo}" download class="btn btn-secondary btn-small">
                                            ⬇️ Baixar
                                        </a>
                                        <a href="?deletar_arquivo=${arquivo.id}" class="btn btn-danger btn-small" onclick="return confirm('Deletar arquivo?')">
                                            🗑️
                                        </a>
                                    </div>
                                </div>
                            `;
                        });
                        html += '</div>';
                    } else {
                        html = '<p style="text-align: center; padding: 40px; color: var(--color-text-secondary);">Nenhum arquivo ainda</p>';
                    }
                    
                    document.getElementById('arquivos_content').innerHTML = html;
                    openModal('modalArquivos');
                })
                .catch(error => {
                    console.error('Erro:', error);
                    document.getElementById('arquivos_content').innerHTML = '<p style="color: #ff4444;">Erro ao carregar arquivos</p>';
                    openModal('modalArquivos');
                });
        }
        
        // Gerenciar seleção de tipo de evento
        document.querySelectorAll('input[name="event_type"]').forEach(radio => {
            radio.addEventListener('change', function() {
                // Remover classe selected de todos
                document.querySelectorAll('.event-type-option').forEach(option => {
                    option.classList.remove('selected');
                });
                
                // Adicionar classe selected ao selecionado
                this.closest('.event-type-option').classList.add('selected');
                
                // Mostrar/esconder campo "Outros" para criar evento
                if (this.value === 'Outros') {
                    const container = this.closest('.modal').querySelector('.event-type-other-input');
                    if (container) {
                        container.classList.add('show');
                        container.querySelector('input').required = true;
                    }
                } else {
                    const container = this.closest('.modal').querySelector('.event-type-other-input');
                    if (container) {
                        container.classList.remove('show');
                        container.querySelector('input').required = false;
                        container.querySelector('input').value = '';
                    }
                }
            });
        });
        
        // Fechar modal ao clicar fora
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.classList.remove('active');
            }
        }
    </script>
</body>
</html>