<?php
/**
 * PÁGINA DE AJUDA - WHITE LABEL v2.0
 * Tutoriais e artigos de ajuda para usuários
 */
require_once 'config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];
$user_role = $_SESSION['role'];

// Buscar dados do usuário
$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

// Buscar artigos publicados visíveis para o usuário
try {
    $visibilidade = ($user_role === 'user') ? 'promoter' : $user_role;
    $stmt = $pdo->prepare("
        SELECT * FROM artigos_ajuda
        WHERE publicado = 1
        AND (visivel_para = 'todos' OR visivel_para = ?)
        ORDER BY ordem, id
    ");
    $stmt->execute([$visibilidade]);
    $artigos = $stmt->fetchAll();
} catch (PDOException $e) {
    $artigos = [];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ajuda - <?= defined('SISTEMA_NOME') ? SISTEMA_NOME : 'PromoTaal' ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <style><?php include 'sistema_theme.php'; ?></style>
    <style>
        body {
            background: var(--cor-fundo);
            min-height: 100vh;
            padding: 20px;
        }

        .ajuda-container {
            max-width: 1000px;
            margin: 0 auto;
        }

        .header {
            text-align: center;
            padding: 40px 20px;
            background: linear-gradient(135deg, var(--cor-card), var(--cor-secundaria));
            border-radius: 20px;
            margin-bottom: 40px;
            border: 1px solid var(--cor-borda);
        }

        .header-icon {
            font-size: 64px;
            color: var(--cor-primaria);
            margin-bottom: 20px;
        }

        .header-title {
            font-size: 42px;
            font-weight: 700;
            color: var(--cor-primaria);
            margin-bottom: 10px;
        }

        .header-subtitle {
            font-size: 18px;
            color: var(--cor-texto-secundario);
        }

        .search-box {
            position: relative;
            margin-bottom: 30px;
        }

        .search-input {
            width: 100%;
            padding: 15px 20px 15px 50px;
            background: var(--cor-card);
            border: 2px solid var(--cor-borda);
            border-radius: 12px;
            color: var(--cor-texto);
            font-size: 16px;
        }

        .search-input:focus {
            border-color: var(--cor-primaria);
            outline: none;
        }

        .search-icon {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--cor-texto-secundario);
            font-size: 18px;
        }

        .artigos-lista {
            display: grid;
            gap: 20px;
        }

        .artigo {
            background: var(--cor-card);
            border-radius: 15px;
            border: 1px solid var(--cor-borda);
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .artigo:hover {
            border-color: var(--cor-primaria);
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }

        .artigo-header {
            padding: 25px;
            background: var(--cor-secundaria);
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .artigo-titulo {
            font-size: 22px;
            font-weight: 700;
            color: var(--cor-texto);
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .artigo-icon {
            width: 45px;
            height: 45px;
            background: var(--cor-primaria);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #000;
            font-size: 20px;
        }

        .artigo-toggle {
            font-size: 24px;
            color: var(--cor-primaria);
            transition: transform 0.3s ease;
        }

        .artigo.active .artigo-toggle {
            transform: rotate(180deg);
        }

        .artigo-conteudo {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .artigo.active .artigo-conteudo {
            max-height: 2000px;
        }

        .artigo-body {
            padding: 30px;
            color: var(--cor-texto);
            line-height: 1.8;
        }

        .artigo-body h3 {
            color: var(--cor-primaria);
            margin-top: 0;
            margin-bottom: 15px;
        }

        .artigo-body p {
            margin-bottom: 15px;
            color: var(--cor-texto);
        }

        .artigo-body strong {
            color: var(--cor-primaria);
        }

        .artigo-body ul, .artigo-body ol {
            margin-left: 20px;
            margin-bottom: 15px;
        }

        .artigo-body li {
            margin-bottom: 8px;
            color: var(--cor-texto);
        }

        .empty-state {
            text-align: center;
            padding: 80px 20px;
            color: var(--cor-texto-secundario);
        }

        .empty-state i {
            font-size: 80px;
            margin-bottom: 20px;
            opacity: 0.3;
        }

        .quick-links {
            background: var(--cor-card);
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 30px;
            border: 1px solid var(--cor-borda);
        }

        .quick-links h3 {
            color: var(--cor-primaria);
            margin-bottom: 20px;
            font-size: 20px;
        }

        .quick-links-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }

        .quick-link {
            padding: 15px;
            background: var(--cor-secundaria);
            border-radius: 10px;
            text-decoration: none;
            color: var(--cor-texto);
            display: flex;
            align-items: center;
            gap: 12px;
            transition: all 0.3s ease;
        }

        .quick-link:hover {
            background: var(--cor-primaria);
            color: #000;
            transform: translateX(5px);
        }

        .quick-link i {
            font-size: 20px;
        }

        @media (max-width: 768px) {
            .header-title {
                font-size: 28px;
            }

            .artigo-titulo {
                font-size: 18px;
            }

            .quick-links-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <?php include 'assets/navbar.php'; ?>

    <div class="ajuda-container">
        <div class="header">
            <div class="header-icon"><i class="fas fa-question-circle"></i></div>
            <h1 class="header-title">Central de Ajuda</h1>
            <p class="header-subtitle">Encontre respostas para suas dúvidas e aprenda a usar o sistema</p>
        </div>

        <div class="quick-links">
            <h3><i class="fas fa-bolt"></i> Acesso Rápido</h3>
            <div class="quick-links-grid">
                <a href="dashboard.php" class="quick-link">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
                <a href="financeiro.php" class="quick-link">
                    <i class="fas fa-dollar-sign"></i>
                    <span>Financeiro</span>
                </a>
                <a href="minhas_listas.php" class="quick-link">
                    <i class="fas fa-list"></i>
                    <span>Minhas Listas</span>
                </a>
                <a href="meu_perfil.php" class="quick-link">
                    <i class="fas fa-user"></i>
                    <span>Meu Perfil</span>
                </a>
            </div>
        </div>

        <div class="search-box">
            <i class="fas fa-search search-icon"></i>
            <input type="text" id="searchInput" class="search-input" placeholder="Pesquisar artigos de ajuda...">
        </div>

        <div class="artigos-lista" id="artigosLista">
            <?php foreach ($artigos as $index => $artigo): ?>
                <div class="artigo" data-search="<?= strtolower(htmlspecialchars($artigo['titulo'] . ' ' . strip_tags($artigo['conteudo']))) ?>">
                    <div class="artigo-header" onclick="toggleArtigo(this)">
                        <div class="artigo-titulo">
                            <div class="artigo-icon"><i class="fas fa-book-reader"></i></div>
                            <span><?= htmlspecialchars($artigo['titulo']) ?></span>
                        </div>
                        <i class="fas fa-chevron-down artigo-toggle"></i>
                    </div>
                    <div class="artigo-conteudo">
                        <div class="artigo-body">
                            <?= $artigo['conteudo'] ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>

            <?php if (empty($artigos)): ?>
                <div class="empty-state">
                    <i class="fas fa-book-open"></i>
                    <h3 style="color: var(--cor-texto); margin-bottom: 10px;">Nenhum artigo disponível</h3>
                    <p>Os artigos de ajuda ainda não foram adicionados ao sistema.</p>
                </div>
            <?php endif; ?>
        </div>

        <div id="noResults" class="empty-state" style="display: none;">
            <i class="fas fa-search"></i>
            <h3 style="color: var(--cor-texto); margin-bottom: 10px;">Nenhum resultado encontrado</h3>
            <p>Tente pesquisar com outras palavras-chave.</p>
        </div>
    </div>

    <script>
        function toggleArtigo(header) {
            const artigo = header.closest('.artigo');
            const todosArtigos = document.querySelectorAll('.artigo');

            // Fechar todos os outros
            todosArtigos.forEach(a => {
                if (a !== artigo) a.classList.remove('active');
            });

            // Toggle do clicado
            artigo.classList.toggle('active');
        }

        // Busca em tempo real
        const searchInput = document.getElementById('searchInput');
        const artigosLista = document.getElementById('artigosLista');
        const noResults = document.getElementById('noResults');

        searchInput.addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            const artigos = document.querySelectorAll('.artigo');
            let hasResults = false;

            artigos.forEach(artigo => {
                const searchContent = artigo.getAttribute('data-search');
                if (searchContent.includes(searchTerm)) {
                    artigo.style.display = 'block';
                    hasResults = true;
                } else {
                    artigo.style.display = 'none';
                }
            });

            if (searchTerm && !hasResults) {
                artigosLista.style.display = 'none';
                noResults.style.display = 'block';
            } else {
                artigosLista.style.display = 'grid';
                noResults.style.display = 'none';
            }
        });
    </script>
</body>
</html>
