<?php
/**
 * COMPONENTE DE RODAPÉ DINÂMICO - WHITE LABEL v2.0
 * Exibe informações de desenvolvedor e licença do banco de dados
 * Incluir no final das páginas: <?php include 'assets/footer.php'; ?>
 */

// Configuração padrão
$rodape_config = [
    'texto_desenvolvido' => 'Desenvolvido por Luminaink',
    'link_desenvolvedor' => 'https://luminaink.com.br',
    'texto_licenciado' => 'Todos os direitos reservados',
    'ano' => date('Y'),
    'mostrar_versao' => 1,
    'versao_sistema' => 'v2.0'
];

// Tentar buscar configurações do banco (se existir)
if (isset($pdo)) {
    try {
        $stmt_footer = $pdo->query("SELECT * FROM rodape_sistema WHERE id = 1");
        $db_rodape = $stmt_footer->fetch();

        if ($db_rodape) {
            $rodape_config = $db_rodape;
        }
    } catch (PDOException $e) {
        // Tabela não existe ainda, usar valores padrão
    }
}
?>

<style>
    .system-footer {
        background: var(--cor-card);
        border-top: 1px solid var(--cor-borda);
        padding: 25px 20px;
        text-align: center;
        margin-top: 60px;
    }

    .system-footer p {
        color: var(--cor-texto-secundario);
        font-size: 14px;
        margin: 5px 0;
    }

    .system-footer a {
        color: var(--cor-primaria);
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .system-footer a:hover {
        color: var(--cor-hover);
    }

    .system-footer .version {
        display: inline-block;
        background: var(--cor-primaria);
        color: #000;
        padding: 3px 10px;
        border-radius: 10px;
        font-size: 12px;
        font-weight: 700;
        margin-left: 8px;
    }
</style>

<footer class="system-footer">
    <p>
        <a href="<?= htmlspecialchars($rodape_config['link_desenvolvedor']) ?>" target="_blank" rel="noopener">
            <?= htmlspecialchars($rodape_config['texto_desenvolvido']) ?>
        </a>
        © <?= htmlspecialchars($rodape_config['ano']) ?>
        <?php if ($rodape_config['mostrar_versao']): ?>
            <span class="version"><?= htmlspecialchars($rodape_config['versao_sistema']) ?></span>
        <?php endif; ?>
    </p>
    <p><?= htmlspecialchars($rodape_config['texto_licenciado']) ?></p>
</footer>
