<?php
// Navbar compartilhada - Sistema Promoters
// Incluir este arquivo em todas as páginas

// Verificar se $usuario e $role estão definidos
if (!isset($usuario) || !isset($role)) {
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $usuario = $stmt->fetch();
    $role = $_SESSION['role'];
}

// Foto de perfil padrão se não existir
$foto_perfil = !empty($usuario['foto_perfil']) && file_exists($usuario['foto_perfil'])
    ? $usuario['foto_perfil']
    : 'assets/default-avatar.png';
?>

<nav class="navbar">
    <div class="navbar-container">
        <div class="navbar-brand">
            <i class="fas fa-gem"></i>
            <?php
            if ($role === 'admin') {
                echo 'Dashboard Admin';
            } elseif ($role === 'produtor') {
                echo 'Dashboard Produtor';
            } else {
                echo 'Dashboard Promoter';
            }
            ?>
        </div>

        <div class="navbar-links">
            <!-- User Profile -->
            <div class="navbar-user">
                <img src="<?= htmlspecialchars($foto_perfil) ?>"
                     alt="<?= htmlspecialchars($usuario['nome']) ?>"
                     class="navbar-user-avatar"
                     onerror="this.src='assets/default-avatar.png'">
                <div class="navbar-user-info">
                    <div class="navbar-user-name">
                        <?= htmlspecialchars(explode(' ', $usuario['nome'])[0]) ?>
                    </div>
                    <div class="navbar-user-role">
                        <?php
                        if ($role === 'admin') echo 'Administrador';
                        elseif ($role === 'produtor') echo 'Produtor';
                        elseif ($role === 'gerente') echo 'Gerente';
                        else echo 'Promoter';
                        ?>
                    </div>
                </div>
            </div>

            <!-- Dashboard -->
            <a href="dashboard.php" class="nav-link">
                <i class="fas fa-home"></i> Dashboard
            </a>

            <!-- Menu Admin -->
            <?php if ($role === 'admin'): ?>
                <a href="admin_eventos.php" class="nav-link">
                    <i class="fas fa-calendar-alt"></i> Eventos
                </a>
                <a href="admin_usuarios.php" class="nav-link">
                    <i class="fas fa-users"></i> Usuários
                </a>
                <a href="admin_convidados.php" class="nav-link">
                    <i class="fas fa-list"></i> Convidados
                </a>
                <a href="admin_checkin.php" class="nav-link">
                    <i class="fas fa-qrcode"></i> Check-in
                </a>
                <a href="admin_saques.php" class="nav-link">
                    <i class="fas fa-money-bill-wave"></i> Saques
                </a>
                <a href="admin_relatorios.php" class="nav-link">
                    <i class="fas fa-chart-bar"></i> Relatórios
                </a>

            <!-- Menu Produtor -->
            <?php elseif ($role === 'produtor'): ?>
                <a href="produtor_eventos.php" class="nav-link">
                    <i class="fas fa-calendar-alt"></i> Meus Eventos
                </a>
                <a href="produtor_listas.php" class="nav-link">
                    <i class="fas fa-list"></i> Minhas Listas
                </a>
                <a href="produtor_financeiro.php" class="nav-link">
                    <i class="fas fa-wallet"></i> Financeiro
                </a>

            <!-- Menu Promoter -->
            <?php else: ?>
                <a href="eventos.php" class="nav-link">
                    <i class="fas fa-calendar-alt"></i> Eventos
                </a>
                <a href="minhas_listas.php" class="nav-link">
                    <i class="fas fa-list"></i> Minhas Listas
                </a>
                <a href="financeiro.php" class="nav-link">
                    <i class="fas fa-wallet"></i> Financeiro
                </a>
                <a href="ranking.php" class="nav-link">
                    <i class="fas fa-trophy"></i> Ranking
                </a>
            <?php endif; ?>

            <!-- Configurações e Artigos - Apenas Admin -->
            <?php if ($role === 'admin'): ?>
                <a href="configuracoes.php" class="nav-link">
                    <i class="fas fa-palette"></i> Configurações
                </a>
                <a href="admin_artigos.php" class="nav-link">
                    <i class="fas fa-book"></i> Artigos de Ajuda
                </a>
            <?php endif; ?>

            <!-- Ajuda - Disponível para todos -->
            <a href="ajuda.php" class="nav-link">
                <i class="fas fa-question-circle"></i> Ajuda
            </a>

            <!-- Meu Perfil - Disponível para todos -->
            <a href="meu_perfil.php" class="nav-link">
                <i class="fas fa-user-circle"></i> Meu Perfil
            </a>

            <!-- Logout -->
            <a href="logout.php" class="nav-link logout">
                <i class="fas fa-sign-out-alt"></i> Sair
            </a>
        </div>
    </div>
</nav>
