<?php
/**
 * TEMPLATE DE INÍCIO DE PÁGINA
 * Inclui: CSS dinâmico + Sidebar + Container principal
 * Usar no início de todas as páginas do sistema
 */

// Verificar se config.php foi incluído
if (!isset($pdo)) {
    require_once __DIR__ . '/../config.php';
}

// Verificar login
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Buscar dados do usuário se não existir
if (!isset($usuario)) {
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $usuario = $stmt->fetch();
}

if (!isset($role)) {
    $role = $_SESSION['role'];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($page_title) ? htmlspecialchars($page_title) : 'PromoTaal' ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <?php if (isset($extra_css)): ?>
        <?= $extra_css ?>
    <?php endif; ?>
</head>
<body>
    <?php include __DIR__ . '/sidebar-navbar.php'; ?>

    <div class="main-content">
        <div class="content-wrapper">
