<?php
/**
 * SIDEBAR NAVBAR - Estilo WordPress MELHORADO
 * Menu lateral retrátil e responsivo
 * Versão mobile moderna inspirada em apps modernos
 */

// Verificar se $usuario e $role estão definidos
if (!isset($usuario) || !isset($role)) {
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $usuario = $stmt->fetch();
    $role = $_SESSION['role'];
}

// Buscar configurações visuais
$config_visual = [
    'nome_sistema' => 'PromoTaal',
    'logo_path' => ''
];

try {
    $stmt = $pdo->query("SELECT nome_sistema, logo_path FROM configuracoes_visual WHERE id = 1");
    $db_config = $stmt->fetch();
    if ($db_config) {
        $config_visual = $db_config;
    }
} catch (PDOException $e) {
    // Usar valores padrão
}

// Foto de perfil padrão se não existir
$foto_perfil = !empty($usuario['foto_perfil']) && file_exists($usuario['foto_perfil'])
    ? $usuario['foto_perfil']
    : 'assets/default-avatar.png';

// Pegar a página atual para destacar o menu ativo
$current_page = basename($_SERVER['PHP_SELF']);
?>

<!-- Incluir CSS Dinâmico com Cores do Sistema -->
<style><?php include __DIR__ . '/../sistema_theme.php'; ?></style>

<style>
/* ========================================
   RESET E CONFIGURAÇÕES GLOBAIS
   ======================================== */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
    background-color: var(--cor-fundo) !important;
    color: var(--cor-texto) !important;
    overflow-x: hidden;
}

/* ========================================
   CONTAINER PRINCIPAL
   ======================================== */
.app-container {
    display: flex;
    min-height: 100vh;
}

/* ========================================
   SIDEBAR - DESKTOP
   ======================================== */
.sidebar {
    width: 260px;
    background-color: var(--cor-card);
    color: var(--cor-texto);
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    overflow-y: auto;
    overflow-x: hidden;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    z-index: 1000;
    border-right: 1px solid var(--cor-borda);
    box-shadow: 2px 0 20px rgba(0,0,0,0.1);
}

.sidebar::-webkit-scrollbar {
    width: 6px;
}

.sidebar::-webkit-scrollbar-track {
    background: transparent;
}

.sidebar::-webkit-scrollbar-thumb {
    background: var(--cor-primaria);
    border-radius: 10px;
}

/* Sidebar colapsada */
.sidebar.collapsed {
    width: 70px;
}

.sidebar.collapsed .sidebar-brand-text,
.sidebar.collapsed .menu-item-text,
.sidebar.collapsed .user-info-details {
    display: none;
}

.sidebar.collapsed .sidebar-brand {
    justify-content: center;
}

.sidebar.collapsed .menu-item {
    justify-content: center;
    padding: 14px;
}

.sidebar.collapsed .user-info {
    flex-direction: column;
    align-items: center;
    padding: 15px 10px;
}

/* ========================================
   LOGO/BRAND
   ======================================== */
.sidebar-brand {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 24px 20px;
    border-bottom: 1px solid var(--cor-borda);
    background: linear-gradient(135deg, var(--cor-secundaria), var(--cor-card));
}

.sidebar-brand-logo {
    width: 40px;
    height: 40px;
    object-fit: contain;
}

.sidebar-brand-icon {
    font-size: 28px;
    color: var(--cor-primaria);
}

.sidebar-brand-text {
    font-size: 20px;
    font-weight: 700;
    color: var(--cor-primaria);
    white-space: nowrap;
}

/* ========================================
   INFORMAÇÕES DO USUÁRIO
   ======================================== */
.user-info {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 20px;
    border-bottom: 1px solid var(--cor-borda);
    background: var(--cor-secundaria);
    transition: all 0.3s;
}

.user-info:hover {
    background: color-mix(in srgb, var(--cor-secundaria) 90%, var(--cor-primaria));
}

.user-avatar {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid var(--cor-primaria);
    flex-shrink: 0;
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}

.user-info-details {
    flex: 1;
    min-width: 0;
}

.user-name {
    font-size: 15px;
    font-weight: 600;
    color: var(--cor-texto);
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    margin-bottom: 2px;
}

.user-role {
    font-size: 12px;
    color: var(--cor-texto-secundario);
    white-space: nowrap;
}

/* ========================================
   MENU DE NAVEGAÇÃO
   ======================================== */
.sidebar-menu {
    padding: 20px 0;
}

.menu-item {
    display: flex;
    align-items: center;
    gap: 14px;
    padding: 14px 20px;
    color: var(--cor-texto-secundario);
    text-decoration: none;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    margin: 2px 8px;
    border-radius: 12px;
}

.menu-item:hover {
    background: color-mix(in srgb, var(--cor-primaria) 15%, transparent);
    color: var(--cor-primaria);
    transform: translateX(4px);
}

.menu-item.active {
    background: linear-gradient(90deg, var(--cor-primaria), var(--cor-secundaria));
    color: #000;
    font-weight: 600;
    box-shadow: 0 4px 12px color-mix(in srgb, var(--cor-primaria) 30%, transparent);
}

.menu-item.active .menu-item-icon {
    color: #000;
}

.menu-item-icon {
    font-size: 20px;
    width: 24px;
    text-align: center;
    flex-shrink: 0;
}

.menu-item-text {
    font-size: 14px;
    font-weight: 500;
    white-space: nowrap;
}

.menu-item.logout {
    color: var(--cor-erro);
    margin-top: 30px;
    border-top: 1px solid var(--cor-borda);
    padding-top: 20px;
    margin-left: 8px;
    margin-right: 8px;
    border-radius: 12px;
}

.menu-item.logout:hover {
    background: color-mix(in srgb, var(--cor-erro) 15%, transparent);
    color: var(--cor-erro);
}

/* ========================================
   BOTÃO DE TOGGLE
   ======================================== */
.sidebar-toggle {
    position: absolute;
    top: 28px;
    right: -18px;
    width: 36px;
    height: 36px;
    background: var(--cor-primaria);
    border: 3px solid var(--cor-borda);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    z-index: 1001;
    transition: all 0.3s;
    color: #000;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}

.sidebar-toggle:hover {
    background: var(--cor-hover);
    transform: scale(1.15);
}

/* ========================================
   CONTEÚDO PRINCIPAL
   ======================================== */
.main-content {
    flex: 1;
    margin-left: 260px;
    transition: all 0.3s ease;
    min-height: 100vh;
    background-color: var(--cor-fundo);
}

.sidebar.collapsed + .main-content {
    margin-left: 70px;
}

.content-wrapper {
    padding: 30px;
    max-width: 1400px;
    margin: 0 auto;
}

/* ========================================
   MOBILE - DESIGN MODERNO (Inspirado em Apps)
   ======================================== */
@media (max-width: 768px) {
    .sidebar {
        width: 100%;
        max-width: 320px;
        transform: translateX(-100%);
        border-radius: 0 24px 24px 0;
    }

    .sidebar.active {
        transform: translateX(0);
    }

    .main-content {
        margin-left: 0 !important;
    }

    /* Botão flutuante moderno */
    .sidebar-toggle {
        position: fixed;
        top: auto;
        bottom: 24px;
        right: 24px;
        left: auto;
        width: 56px;
        height: 56px;
        background: linear-gradient(135deg, var(--cor-primaria), var(--cor-secundaria));
        border: none;
        box-shadow: 0 8px 24px rgba(0,0,0,0.3);
        z-index: 1002;
    }

    .sidebar-toggle i {
        font-size: 24px;
    }

    .sidebar.active + .sidebar-toggle {
        background: var(--cor-erro);
        transform: rotate(45deg);
    }

    .sidebar.active + .sidebar-toggle i:before {
        content: "\f00d"; /* X icon */
    }

    /* Overlay com blur */
    .sidebar-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0,0,0,0.6);
        backdrop-filter: blur(8px);
        z-index: 999;
        animation: fadeIn 0.3s;
    }

    .sidebar-overlay.active {
        display: block;
    }

    /* Animação do menu mobile */
    .sidebar {
        box-shadow: 0 0 60px rgba(0,0,0,0.5);
    }

    /* Ajustar espaçamento mobile */
    .content-wrapper {
        padding: 20px;
    }

    /* User info destaque no mobile */
    .user-info {
        padding: 24px 20px;
    }

    .user-avatar {
        width: 56px;
        height: 56px;
    }

    .user-name {
        font-size: 16px;
    }

    /* Menu items maiores no mobile */
    .menu-item {
        padding: 16px 20px;
        margin: 4px 12px;
    }

    .menu-item-icon {
        font-size: 22px;
    }

    .menu-item-text {
        font-size: 15px;
    }
}

/* Animações */
@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}
</style>

<!-- Overlay para mobile -->
<div class="sidebar-overlay" id="sidebarOverlay"></div>

<!-- SIDEBAR -->
<div class="sidebar" id="sidebar">
    <!-- Botão de Toggle -->
    <div class="sidebar-toggle" id="sidebarToggle">
        <i class="fas fa-bars"></i>
    </div>

    <!-- Logo/Brand -->
    <div class="sidebar-brand">
        <?php if (!empty($config_visual['logo_path']) && file_exists($config_visual['logo_path'])): ?>
            <img src="<?= htmlspecialchars($config_visual['logo_path']) ?>" alt="Logo" class="sidebar-brand-logo">
        <?php else: ?>
            <i class="fas fa-theater-masks sidebar-brand-icon"></i>
        <?php endif; ?>
        <span class="sidebar-brand-text"><?= htmlspecialchars($config_visual['nome_sistema']) ?></span>
    </div>

    <!-- Informações do Usuário -->
    <a href="meu_perfil.php" class="user-info" style="text-decoration: none;">
        <img src="<?= htmlspecialchars($foto_perfil) ?>" alt="<?= htmlspecialchars($usuario['nome']) ?>" class="user-avatar" onerror="this.src='assets/default-avatar.png'">
        <div class="user-info-details">
            <div class="user-name"><?= htmlspecialchars($usuario['nome']) ?></div>
            <div class="user-role">
                <?php
                if ($role === 'admin') echo 'Administrador';
                elseif ($role === 'produtor') echo 'Produtor';
                elseif ($role === 'gerente') echo 'Gerente';
                else echo 'Promoter';
                ?>
            </div>
        </div>
    </a>

    <!-- Menu de Navegação -->
    <nav class="sidebar-menu">
        <a href="dashboard.php" class="menu-item <?= $current_page === 'dashboard.php' ? 'active' : '' ?>">
            <i class="fas fa-home menu-item-icon"></i>
            <span class="menu-item-text">Dashboard</span>
        </a>

        <!-- Menu Admin -->
        <?php if ($role === 'admin'): ?>
            <a href="admin_eventos.php" class="menu-item <?= $current_page === 'admin_eventos.php' ? 'active' : '' ?>">
                <i class="fas fa-calendar-alt menu-item-icon"></i>
                <span class="menu-item-text">Eventos</span>
            </a>

            <a href="admin_usuarios.php" class="menu-item <?= $current_page === 'admin_usuarios.php' ? 'active' : '' ?>">
                <i class="fas fa-users menu-item-icon"></i>
                <span class="menu-item-text">Promoters</span>
            </a>

            <a href="admin_convidados.php" class="menu-item <?= $current_page === 'admin_convidados.php' ? 'active' : '' ?>">
                <i class="fas fa-list menu-item-icon"></i>
                <span class="menu-item-text">Convidados</span>
            </a>

            <a href="admin_checkin.php" class="menu-item <?= $current_page === 'admin_checkin.php' ? 'active' : '' ?>">
                <i class="fas fa-qrcode menu-item-icon"></i>
                <span class="menu-item-text">Check-in</span>
            </a>

            <a href="admin_saques.php" class="menu-item <?= $current_page === 'admin_saques.php' ? 'active' : '' ?>">
                <i class="fas fa-money-bill-wave menu-item-icon"></i>
                <span class="menu-item-text">Saques</span>
            </a>

            <a href="admin_relatorios.php" class="menu-item <?= $current_page === 'admin_relatorios.php' ? 'active' : '' ?>">
                <i class="fas fa-chart-bar menu-item-icon"></i>
                <span class="menu-item-text">Relatórios</span>
            </a>

            <a href="configuracoes.php" class="menu-item <?= $current_page === 'configuracoes.php' ? 'active' : '' ?>">
                <i class="fas fa-palette menu-item-icon"></i>
                <span class="menu-item-text">Configurações</span>
            </a>

            <a href="admin_artigos.php" class="menu-item <?= $current_page === 'admin_artigos.php' ? 'active' : '' ?>">
                <i class="fas fa-book menu-item-icon"></i>
                <span class="menu-item-text">Ajuda</span>
            </a>

        <!-- Menu Produtor -->
        <?php elseif ($role === 'produtor'): ?>
            <a href="produtor_eventos.php" class="menu-item <?= $current_page === 'produtor_eventos.php' ? 'active' : '' ?>">
                <i class="fas fa-calendar-alt menu-item-icon"></i>
                <span class="menu-item-text">Meus Eventos</span>
            </a>

            <a href="produtor_listas.php" class="menu-item <?= $current_page === 'produtor_listas.php' ? 'active' : '' ?>">
                <i class="fas fa-list menu-item-icon"></i>
                <span class="menu-item-text">Listas</span>
            </a>

            <a href="produtor_financeiro.php" class="menu-item <?= $current_page === 'produtor_financeiro.php' ? 'active' : '' ?>">
                <i class="fas fa-wallet menu-item-icon"></i>
                <span class="menu-item-text">Financeiro</span>
            </a>

        <!-- Menu Promoter -->
        <?php else: ?>
            <a href="eventos.php" class="menu-item <?= $current_page === 'eventos.php' ? 'active' : '' ?>">
                <i class="fas fa-calendar-alt menu-item-icon"></i>
                <span class="menu-item-text">Eventos</span>
            </a>

            <a href="minhas_listas.php" class="menu-item <?= $current_page === 'minhas_listas.php' ? 'active' : '' ?>">
                <i class="fas fa-list menu-item-icon"></i>
                <span class="menu-item-text">Minhas Listas</span>
            </a>

            <a href="financeiro.php" class="menu-item <?= $current_page === 'financeiro.php' ? 'active' : '' ?>">
                <i class="fas fa-wallet menu-item-icon"></i>
                <span class="menu-item-text">Financeiro</span>
            </a>

            <a href="ranking.php" class="menu-item <?= $current_page === 'ranking.php' ? 'active' : '' ?>">
                <i class="fas fa-trophy menu-item-icon"></i>
                <span class="menu-item-text">Ranking</span>
            </a>

            <a href="ajuda.php" class="menu-item <?= $current_page === 'ajuda.php' ? 'active' : '' ?>">
                <i class="fas fa-question-circle menu-item-icon"></i>
                <span class="menu-item-text">Ajuda</span>
            </a>
        <?php endif; ?>

        <a href="meu_perfil.php" class="menu-item <?= $current_page === 'meu_perfil.php' ? 'active' : '' ?>">
            <i class="fas fa-user-circle menu-item-icon"></i>
            <span class="menu-item-text">Meu Perfil</span>
        </a>

        <a href="logout.php" class="menu-item logout">
            <i class="fas fa-sign-out-alt menu-item-icon"></i>
            <span class="menu-item-text">Sair</span>
        </a>
    </nav>
</div>

<!-- JavaScript para controlar sidebar -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const sidebar = document.getElementById('sidebar');
    const sidebarToggle = document.getElementById('sidebarToggle');
    const sidebarOverlay = document.getElementById('sidebarOverlay');
    const toggleIcon = sidebarToggle.querySelector('i');

    // Carregar estado do localStorage (apenas desktop)
    if (window.innerWidth > 768) {
        const sidebarState = localStorage.getItem('sidebar_collapsed');
        if (sidebarState === 'true') {
            sidebar.classList.add('collapsed');
            toggleIcon.classList.replace('fa-bars', 'fa-chevron-right');
        }
    }

    // Toggle sidebar
    sidebarToggle.addEventListener('click', function() {
        if (window.innerWidth <= 768) {
            // Mobile: abrir/fechar
            sidebar.classList.toggle('active');
            sidebarOverlay.classList.toggle('active');
        } else {
            // Desktop: colapsar/expandir
            sidebar.classList.toggle('collapsed');

            if (sidebar.classList.contains('collapsed')) {
                toggleIcon.classList.replace('fa-bars', 'fa-chevron-right');
                localStorage.setItem('sidebar_collapsed', 'true');
            } else {
                toggleIcon.classList.replace('fa-chevron-right', 'fa-bars');
                localStorage.setItem('sidebar_collapsed', 'false');
            }
        }
    });

    // Fechar sidebar ao clicar no overlay (mobile)
    sidebarOverlay.addEventListener('click', function() {
        sidebar.classList.remove('active');
        sidebarOverlay.classList.remove('active');
    });

    // Ajustar comportamento ao redimensionar
    window.addEventListener('resize', function() {
        if (window.innerWidth > 768) {
            sidebar.classList.remove('active');
            sidebarOverlay.classList.remove('active');
            toggleIcon.classList.replace('fa-times', 'fa-bars');
        } else {
            // No mobile, sempre mostrar ícone de menu
            if (!sidebar.classList.contains('active')) {
                toggleIcon.classList.replace('fa-chevron-right', 'fa-bars');
                toggleIcon.classList.replace('fa-chevron-left', 'fa-bars');
            }
        }
    });

    // Fechar menu ao clicar em um link no mobile
    if (window.innerWidth <= 768) {
        const menuItems = document.querySelectorAll('.menu-item');
        menuItems.forEach(item => {
            item.addEventListener('click', function() {
                sidebar.classList.remove('active');
                sidebarOverlay.classList.remove('active');
            });
        });
    }
});
</script>
