<?php
// config.php - Configuração do Sistema
// IMPORTANTE: Salve como UTF-8 sem BOM

// Iniciar output buffering
if (ob_get_level() == 0) {
    ob_start();
}

// Iniciar sessão (CORRETO: PHP_SESSION_NONE)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Configurações do Banco de Dados
define('DB_HOST', 'localhost');
define('DB_PORT', '3306');
define('DB_NAME', 'invitmecom_promosis');
define('DB_USER', 'invitmecom_promosis');
define('DB_PASS', 'rH]&iG%{ysipNDnB');

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Conexão com Banco de Dados
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch(PDOException $e) {
    error_log("Erro na conexão: " . $e->getMessage());
    die("Erro ao conectar no banco de dados: " . $e->getMessage());
}

// ====================================
// FUNÇÕES AUXILIARES
// ====================================

function verificarLogin() {
    if (!isset($_SESSION['user_id'])) {
        header('Location: login.php');
        exit;
    }
}

function verificarRole($roles_permitidas) {
    verificarLogin();
    if (!in_array($_SESSION['role'], $roles_permitidas)) {
        header('Location: dashboard.php');
        exit;
    }
}

function gerarToken($tamanho = 32) {
    return bin2hex(random_bytes($tamanho));
}

function formatarMoeda($valor) {
    if ($valor === null || $valor === '') {
        return 'R$ 0,00';
    }
    return 'R$ ' . number_format(floatval($valor), 2, ',', '.');
}

function formatarData($data) {
    if (empty($data)) {
        return '-';
    }
    try {
        $timestamp = strtotime($data);
        if ($timestamp === false) {
            return '-';
        }
        return date('d/m/Y', $timestamp);
    } catch (Exception $e) {
        return '-';
    }
}

function formatarDataHora($data) {
    if (empty($data)) {
        return '-';
    }
    try {
        $timestamp = strtotime($data);
        if ($timestamp === false) {
            return '-';
        }
        return date('d/m/Y H:i', $timestamp);
    } catch (Exception $e) {
        return '-';
    }
}

function sanitizar($string) {
    if (is_array($string)) {
        return array_map('sanitizar', $string);
    }
    return htmlspecialchars(trim($string), ENT_QUOTES, 'UTF-8');
}

function validarEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

function validarTelefone($telefone) {
    $telefone = preg_replace('/[^0-9]/', '', $telefone);
    return strlen($telefone) >= 10 && strlen($telefone) <= 11;
}

function gerarQRCode() {
    return strtoupper(bin2hex(random_bytes(8)));
}

function logErro($mensagem, $arquivo = '', $linha = '') {
    $log = date('[Y-m-d H:i:s] ');
    if ($arquivo) {
        $log .= "[$arquivo";
        if ($linha) {
            $log .= ":$linha";
        }
        $log .= "] ";
    }
    $log .= $mensagem . "\n";

    $log_dir = __DIR__ . '/logs';
    if (!is_dir($log_dir)) {
        @mkdir($log_dir, 0755, true);
    }

    @error_log($log, 3, $log_dir . '/erros.log');
}
?>
