<?php
// convite_qrcode.php - Visualizar e baixar QR Code
require_once 'config.php';

$token = $_GET['token'] ?? '';

if (empty($token)) {
    die('Token inválido');
}

// Buscar informações do convidado
$stmt = $pdo->prepare("
    SELECT c.*, e.nome as evento_nome, e.data, e.hora, e.imagem, e.informacoes_importantes,
           u.nome as promoter_nome
    FROM convidados c
    INNER JOIN eventos e ON c.evento_id = e.id
    INNER JOIN usuarios u ON c.promoter_id = u.id
    WHERE c.qr_code = ?
");
$stmt->execute([$token]);
$convite = $stmt->fetch();

if (!$convite) {
    die('
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>QR Code Inválido</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                background: #000;
                color: white;
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                text-align: center;
                padding: 20px;
            }
        </style>
    </head>
    <body>
        <div>
            <h1 style="font-size: 80px;"><i class="fas fa-times-circle" style="color: #ff4444;"></i></h1>
            <h2>QR Code Inválido</h2>
            <p>Este código não foi encontrado no sistema.</p>
        </div>
    </body>
    </html>
    ');
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Seu Ingresso - <?= htmlspecialchars($convite['evento_nome']) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #000 0%, #1a1a1a 100%);
            color: #fff;
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 600px;
            margin: 0 auto;
        }
        
        .card {
            background: #2a2a2a;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.5);
            text-align: center;
        }
        
        .header-icon {
            font-size: 80px;
            margin-bottom: 20px;
        }
        
        h1 {
            color: #FFD700;
            font-size: 32px;
            margin-bottom: 10px;
        }
        
        .evento-nome {
            font-size: 24px;
            font-weight: bold;
            color: #FFD700;
            margin: 20px 0;
        }
        
        .info-item {
            font-size: 18px;
            margin: 10px 0;
            color: #ccc;
        }
        
        .qr-container {
            background: #fff;
            padding: 30px;
            border-radius: 15px;
            margin: 30px 0;
        }
        
        #qrcode {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .qr-text {
            background: #000;
            color: #FFD700;
            padding: 15px;
            border-radius: 10px;
            font-family: monospace;
            font-size: 16px;
            word-break: break-all;
        }
        
        .btn {
            display: inline-block;
            padding: 18px 40px;
            border: none;
            border-radius: 10px;
            background: linear-gradient(135deg, #FFD700, #FFA500);
            color: #000;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            text-decoration: none;
            margin: 10px;
            transition: all 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(255, 215, 0, 0.5);
        }
        
        .btn-print {
            background: #007bff;
        }
        
        .alert {
            background: rgba(255, 165, 0, 0.1);
            border: 2px solid #FFA500;
            color: #FFA500;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            line-height: 1.6;
        }
        
        .footer {
            text-align: center;
            margin-top: 40px;
            color: #999;
            font-size: 14px;
        }
        
        @media print {
            body {
                background: white;
                color: black;
            }
            .btn {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="header-icon"><i class="fas fa-ticket-alt" style="color: #FFD700;"></i></div>
            <h1>Seu Ingresso</h1>
            <p style="color: #999; margin-bottom: 30px;">Apresente este QR Code na entrada</p>
            
            <div class="evento-nome"><?= htmlspecialchars($convite['evento_nome']) ?></div>

            <div class="info-item">
                <i class="fas fa-user"></i> <strong><?= htmlspecialchars($convite['nome']) ?></strong>
            </div>

            <div class="info-item">
                <i class="fas fa-calendar-alt"></i> <?= formatarData($convite['data']) ?>
            </div>

            <div class="info-item">
                <i class="fas fa-clock"></i> <?= date('H:i', strtotime($convite['hora'])) ?>
            </div>
            
            <div class="qr-container">
                <div id="qrcode"></div>
                <div class="qr-text"><?= htmlspecialchars($convite['qr_code']) ?></div>
            </div>
            
            <div class="alert">
                <strong><i class="fas fa-exclamation-triangle"></i> IMPORTANTE:</strong><br>
                • Guarde este código com cuidado<br>
                • Você pode imprimir esta página<br>
                • Tire um screenshot para ter um backup
            </div>
            
            <?php if (!empty($convite['informacoes_importantes'])): ?>
                <div style="background: #1a1a1a; padding: 20px; border-radius: 10px; margin: 20px 0; text-align: left;">
                    <h3 style="color: #FFD700; margin-bottom: 15px; text-align: center;"><i class="fas fa-clipboard-list"></i> Informações Importantes</h3>
                    <p style="line-height: 1.6; white-space: pre-line;">
                        <?= nl2br(htmlspecialchars($convite['informacoes_importantes'])) ?>
                    </p>
                </div>
            <?php endif; ?>

            <button class="btn" onclick="baixarIngresso()">
                <i class="fas fa-download"></i> Baixar Ingresso
            </button>

            <button class="btn btn-print" onclick="window.print()">
                <i class="fas fa-print"></i> Imprimir
            </button>
            
            <p style="margin-top: 30px; color: #666; font-size: 14px;">
                Cadastrado por: <strong><?= htmlspecialchars($convite['promoter_nome']) ?></strong>
            </p>
        </div>
        
        <div class="footer">
            Desenvolvido por <strong>Alerson Araújo</strong><br>
            Licenciado para <strong>Espaço Taal</strong>
        </div>
    </div>
    
    <script>
        // Dados do evento
        const eventoData = {
            nome: "<?= addslashes($convite['evento_nome']) ?>",
            data: "<?= formatarData($convite['data']) ?>",
            hora: "<?= date('H:i', strtotime($convite['hora'])) ?>",
            qrcode: "<?= $convite['qr_code'] ?>",
            convidado: "<?= addslashes($convite['nome']) ?>",
            promoter: "<?= addslashes($convite['promoter_nome']) ?>",
            informacoes: <?= json_encode($convite['informacoes_importantes'] ?? '') ?>,
            imagemEvento: "<?= $convite['imagem'] ?? '' ?>"
        };
        
        // Gerar QR Code
        new QRCode(document.getElementById("qrcode"), {
            text: eventoData.qrcode,
            width: 300,
            height: 300,
            colorDark: "#000000",
            colorLight: "#ffffff",
            correctLevel: QRCode.CorrectLevel.H
        });
        
        // DOWNLOAD AUTOMÁTICO ao abrir a página (conforme especificação)
        window.addEventListener('load', function() {
            // Aguardar 1 segundo para garantir que QR Code foi gerado
            setTimeout(() => {
                // Iniciar download automaticamente
                baixarIngresso();
            }, 1000);
        });
        
        // Função de baixar ingresso (mesma lógica do convite.php)
        function baixarIngresso() {
            const qrCanvas = document.querySelector('#qrcode canvas');
            if (!qrCanvas) {
                alert('Aguarde o QR Code carregar...');
                return;
            }
            
            const canvas = document.createElement('canvas');
            const ctx = canvas.getContext('2d');
            canvas.width = 1080;
            
            let totalHeight = 600 + 200 + 720 + 180 + 120;
            if (eventoData.informacoes && eventoData.informacoes.trim() !== '') {
                ctx.font = '28px Arial';
                const infoLines = wrapText(ctx, eventoData.informacoes, 980);
                totalHeight += 150 + (infoLines.length * 40) + 80;
            }
            canvas.height = totalHeight;
            
            ctx.fillStyle = '#ffffff';
            ctx.fillRect(0, 0, canvas.width, canvas.height);
            
            let y = 0;
            
            function desenharFlyer() {
                const flyerHeight = 600;
                
                if (eventoData.imagemEvento && eventoData.imagemEvento.trim() !== '') {
                    const img = new Image();
                    img.crossOrigin = 'anonymous';
                    
                    img.onload = function() {
                        const imgRatio = img.width / img.height;
                        const canvasRatio = canvas.width / flyerHeight;
                        let sx, sy, sw, sh;
                        
                        if (imgRatio > canvasRatio) {
                            sh = img.height;
                            sw = img.height * canvasRatio;
                            sx = (img.width - sw) / 2;
                            sy = 0;
                        } else {
                            sw = img.width;
                            sh = img.width / canvasRatio;
                            sx = 0;
                            sy = (img.height - sh) / 2;
                        }
                        
                        ctx.drawImage(img, sx, sy, sw, sh, 0, 0, canvas.width, flyerHeight);
                        continuarDesenho(flyerHeight);
                    };
                    
                    img.onerror = function() {
                        desenharFlyerSemImagem(flyerHeight);
                        continuarDesenho(flyerHeight);
                    };
                    
                    img.src = eventoData.imagemEvento;
                } else {
                    desenharFlyerSemImagem(flyerHeight);
                    continuarDesenho(flyerHeight);
                }
            }
            
            function desenharFlyerSemImagem(height) {
                const gradient = ctx.createLinearGradient(0, 0, 0, height);
                gradient.addColorStop(0, '#667eea');
                gradient.addColorStop(1, '#764ba2');
                ctx.fillStyle = gradient;
                ctx.fillRect(0, 0, canvas.width, height);
                
                ctx.fillStyle = '#ffffff';
                ctx.font = 'bold 80px Arial';
                ctx.textAlign = 'center';
                
                const nomeEvento = eventoData.nome.toUpperCase();
                if (ctx.measureText(nomeEvento).width > canvas.width - 100) {
                    ctx.font = 'bold 60px Arial';
                }
                ctx.fillText(nomeEvento, canvas.width/2, height/2);
            }
            
            function continuarDesenho(startY) {
                y = startY + 40;
                
                ctx.strokeStyle = '#e0e0e0';
                ctx.lineWidth = 2;
                ctx.beginPath();
                ctx.moveTo(50, y);
                ctx.lineTo(canvas.width - 50, y);
                ctx.stroke();
                
                y += 50;
                
                ctx.fillStyle = '#888888';
                ctx.font = '32px Arial';
                ctx.textAlign = 'left';
                ctx.fillText('🎫 INGRESSO DE', 50, y);
                
                y += 50;
                
                ctx.fillStyle = '#000000';
                ctx.font = 'bold 48px Arial';
                ctx.fillText(eventoData.convidado.toUpperCase(), 50, y);
                
                y += 60;
                
                ctx.strokeStyle = '#e0e0e0';
                ctx.lineWidth = 2;
                ctx.beginPath();
                ctx.moveTo(50, y);
                ctx.lineTo(canvas.width - 50, y);
                ctx.stroke();
                
                y += 60;
                
                const qrSize = 600;
                const qrX = (canvas.width - qrSize) / 2;
                ctx.drawImage(qrCanvas, qrX, y, qrSize, qrSize);
                
                y += qrSize + 30;
                
                ctx.fillStyle = '#666666';
                ctx.font = '28px Courier New';
                ctx.textAlign = 'center';
                ctx.fillText(eventoData.qrcode, canvas.width/2, y);
                
                y += 60;
                
                ctx.strokeStyle = '#e0e0e0';
                ctx.lineWidth = 2;
                ctx.beginPath();
                ctx.moveTo(50, y);
                ctx.lineTo(canvas.width - 50, y);
                ctx.stroke();
                
                y += 60;
                
                ctx.fillStyle = '#888888';
                ctx.font = '28px Arial';
                ctx.textAlign = 'left';
                ctx.fillText('📅 Data', 50, y);
                
                ctx.fillStyle = '#000000';
                ctx.font = 'bold 36px Arial';
                ctx.fillText(eventoData.data, 50, y + 45);
                
                ctx.fillStyle = '#888888';
                ctx.font = '28px Arial';
                ctx.textAlign = 'right';
                ctx.fillText('🕐 Horário', canvas.width - 50, y);
                
                ctx.fillStyle = '#000000';
                ctx.font = 'bold 36px Arial';
                ctx.fillText(eventoData.hora, canvas.width - 50, y + 45);
                
                y += 120;
                
                if (eventoData.informacoes && eventoData.informacoes.trim() !== '') {
                    ctx.strokeStyle = '#e0e0e0';
                    ctx.lineWidth = 2;
                    ctx.beginPath();
                    ctx.moveTo(50, y);
                    ctx.lineTo(canvas.width - 50, y);
                    ctx.stroke();
                    
                    y += 50;
                    
                    ctx.fillStyle = '#FF6B6B';
                    ctx.font = 'bold 36px Arial';
                    ctx.textAlign = 'left';
                    ctx.fillText('⚠️ INFORMAÇÕES IMPORTANTES', 50, y);
                    
                    y += 50;
                    
                    const infoLines = wrapText(ctx, eventoData.informacoes, 980);
                    const infoBoxHeight = (infoLines.length * 40) + 60;
                    
                    ctx.fillStyle = '#f8f8f8';
                    ctx.fillRect(50, y, canvas.width - 100, infoBoxHeight);
                    
                    ctx.strokeStyle = '#FF6B6B';
                    ctx.lineWidth = 3;
                    ctx.strokeRect(50, y, canvas.width - 100, infoBoxHeight);
                    
                    y += 40;
                    
                    ctx.fillStyle = '#000000';
                    ctx.font = '28px Arial';
                    ctx.textAlign = 'left';
                    
                    infoLines.forEach(line => {
                        ctx.fillText('• ' + line, 80, y);
                        y += 40;
                    });
                    
                    y += 40;
                }
                
                ctx.strokeStyle = '#e0e0e0';
                ctx.lineWidth = 2;
                ctx.beginPath();
                ctx.moveTo(50, y);
                ctx.lineTo(canvas.width - 50, y);
                ctx.stroke();
                
                y += 40;
                
                ctx.fillStyle = '#888888';
                ctx.font = '24px Arial';
                ctx.textAlign = 'center';
                ctx.fillText('Convidado por: ' + eventoData.promoter, canvas.width/2, y);
                
                y += 35;
                
                ctx.fillText('PromoSys desenvolvido por Alerson Araújo • Licenciado para Espaço Taal', canvas.width/2, y);
                
                canvas.toBlob(function(blob) {
                    const url = URL.createObjectURL(blob);
                    const link = document.createElement('a');
                    
                    const nomeEvento = eventoData.nome.replace(/[^a-z0-9]/gi, '_');
                    const nomeConvidado = eventoData.convidado.replace(/[^a-z0-9]/gi, '_');
                    link.download = `Ingresso_${nomeEvento}_${nomeConvidado}.png`;
                    
                    link.href = url;
                    link.click();
                    URL.revokeObjectURL(url);
                }, 'image/png', 1.0);
            }
            
            function wrapText(context, text, maxWidth) {
                const words = text.split(' ');
                const lines = [];
                let currentLine = words[0];
                
                for (let i = 1; i < words.length; i++) {
                    const word = words[i];
                    const width = context.measureText(currentLine + ' ' + word).width;
                    if (width < maxWidth) {
                        currentLine += ' ' + word;
                    } else {
                        lines.push(currentLine);
                        currentLine = word;
                    }
                }
                lines.push(currentLine);
                return lines;
            }
            
            desenharFlyer();
        }
    </script>
</body>
</html>