<?php
// corrigir_estrutura_usuarios.php - Corrige a estrutura da tabela usuarios
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Conectar DIRETAMENTE
$DB_HOST = 'localhost';
$DB_PORT = '3306';
$DB_NAME = 'invitmecom_promosis';
$DB_USER = 'invitmecom_promosis';
$DB_PASS = 'rH]&iG%{ysipNDnB';

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Corrigir Estrutura da Tabela usuarios</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; margin-bottom: 20px; }
        h2 {
            color: #764ba2;
            margin: 25px 0 15px 0;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
        }
        .success {
            background: #d4edda;
            border-left: 4px solid #28a745;
            padding: 15px;
            margin: 15px 0;
            color: #155724;
            border-radius: 5px;
        }
        .error {
            background: #f8d7da;
            border-left: 4px solid #dc3545;
            padding: 15px;
            margin: 15px 0;
            color: #721c24;
            border-radius: 5px;
        }
        .warning {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 15px 0;
            color: #856404;
            border-radius: 5px;
        }
        .info {
            background: #d1ecf1;
            border-left: 4px solid #0c5460;
            padding: 15px;
            margin: 15px 0;
            color: #0c5460;
            border-radius: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
            font-size: 14px;
        }
        table th {
            background: #667eea;
            color: white;
            padding: 12px;
            text-align: left;
        }
        table td {
            padding: 10px 12px;
            border-bottom: 1px solid #dee2e6;
        }
        table tr:hover {
            background: #f8f9fa;
        }
        .btn {
            background: #667eea;
            color: white;
            padding: 12px 25px;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin: 5px;
        }
        .btn:hover { background: #5568d3; }
        .btn-success { background: #28a745; }
        .btn-success:hover { background: #218838; }
        .btn-danger { background: #dc3545; }
        .btn-danger:hover { background: #c82333; }
        pre {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            font-size: 12px;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>🔧 Corrigir Estrutura da Tabela 'usuarios'</h1>

<?php
try {
    $pdo = new PDO(
        "mysql:host=$DB_HOST;port=$DB_PORT;dbname=$DB_NAME;charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );

    echo "<div class='success'>";
    echo "<p>✅ Conectado ao banco: <strong>$DB_NAME</strong></p>";
    echo "</div>";

    // Verificar estrutura atual da tabela
    echo "<h2>📋 Estrutura ATUAL da Tabela 'usuarios'</h2>";

    $stmt = $pdo->query("DESCRIBE usuarios");
    $colunas_atuais = $stmt->fetchAll();

    echo "<table>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Chave</th><th>Padrão</th><th>Extra</th></tr>";

    $colunas_existentes = [];
    foreach ($colunas_atuais as $coluna) {
        $colunas_existentes[] = $coluna['Field'];
        echo "<tr>";
        echo "<td><strong>{$coluna['Field']}</strong></td>";
        echo "<td>{$coluna['Type']}</td>";
        echo "<td>{$coluna['Null']}</td>";
        echo "<td>{$coluna['Key']}</td>";
        echo "<td>{$coluna['Default']}</td>";
        echo "<td>{$coluna['Extra']}</td>";
        echo "</tr>";
    }
    echo "</table>";

    echo "<div class='info'>";
    echo "<p><strong>Total de colunas:</strong> " . count($colunas_existentes) . "</p>";
    echo "</div>";

    // Colunas esperadas
    echo "<h2>✅ Estrutura ESPERADA (Correta)</h2>";

    $colunas_esperadas = [
        'id' => 'int(11) AUTO_INCREMENT PRIMARY KEY',
        'nome' => 'varchar(255) NOT NULL',
        'email' => 'varchar(255) NOT NULL UNIQUE',
        'senha' => 'varchar(255) NOT NULL',
        'cpf' => 'varchar(14) DEFAULT NULL',
        'telefone' => 'varchar(20) DEFAULT NULL',
        'role' => "enum('admin','produtor','promoter') NOT NULL DEFAULT 'promoter'",
        'ativo' => 'tinyint(1) DEFAULT 1',
        'foto' => 'varchar(255) DEFAULT NULL',
        'bio' => 'text DEFAULT NULL',
        'data_cadastro' => 'timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP',
        'ultimo_acesso' => 'timestamp NULL DEFAULT NULL'
    ];

    echo "<table>";
    echo "<tr><th>Campo</th><th>Especificação</th><th>Status</th></tr>";

    $colunas_faltando = [];
    foreach ($colunas_esperadas as $campo => $spec) {
        $existe = in_array($campo, $colunas_existentes);
        $status = $existe ? '<span style="color: green;">✅ Existe</span>' : '<span style="color: red;">❌ FALTA</span>';

        if (!$existe) {
            $colunas_faltando[$campo] = $spec;
        }

        echo "<tr>";
        echo "<td><strong>$campo</strong></td>";
        echo "<td><code>$spec</code></td>";
        echo "<td>$status</td>";
        echo "</tr>";
    }
    echo "</table>";

    // Mostrar o que falta
    if (!empty($colunas_faltando)) {
        echo "<div class='error'>";
        echo "<h3>❌ PROBLEMA: Faltam " . count($colunas_faltando) . " colunas!</h3>";
        echo "<p>Colunas que precisam ser adicionadas:</p>";
        echo "<ul>";
        foreach ($colunas_faltando as $campo => $spec) {
            echo "<li><code>$campo</code></li>";
        }
        echo "</ul>";
        echo "</div>";

        // Botão para corrigir automaticamente
        echo "<div class='warning'>";
        echo "<h3>🔧 Corrigir Automaticamente</h3>";
        echo "<p>Clique no botão abaixo para adicionar as colunas que faltam:</p>";
        echo "<form method='POST'>";
        echo "<button type='submit' name='corrigir' value='1' class='btn btn-danger'>🔨 Adicionar Colunas Faltantes</button>";
        echo "</form>";
        echo "</div>";

    } else {
        echo "<div class='success'>";
        echo "<h3>✅ Estrutura Perfeita!</h3>";
        echo "<p>A tabela tem todas as colunas necessárias.</p>";
        echo "<p><a href='diagnostico_banco.php' class='btn btn-success'>➡️ Voltar ao Diagnóstico</a></p>";
        echo "</div>";
    }

    // Processar correção
    if (isset($_POST['corrigir'])) {
        echo "<h2>🔨 Adicionando Colunas...</h2>";

        $comandos_sql = [];

        // Preparar comandos ALTER TABLE
        if (!in_array('ativo', $colunas_existentes)) {
            $comandos_sql[] = "ALTER TABLE usuarios ADD COLUMN ativo tinyint(1) DEFAULT 1";
        }
        if (!in_array('cpf', $colunas_existentes)) {
            $comandos_sql[] = "ALTER TABLE usuarios ADD COLUMN cpf varchar(14) DEFAULT NULL";
        }
        if (!in_array('telefone', $colunas_existentes)) {
            $comandos_sql[] = "ALTER TABLE usuarios ADD COLUMN telefone varchar(20) DEFAULT NULL";
        }
        if (!in_array('foto', $colunas_existentes)) {
            $comandos_sql[] = "ALTER TABLE usuarios ADD COLUMN foto varchar(255) DEFAULT NULL";
        }
        if (!in_array('bio', $colunas_existentes)) {
            $comandos_sql[] = "ALTER TABLE usuarios ADD COLUMN bio text DEFAULT NULL";
        }
        if (!in_array('data_cadastro', $colunas_existentes)) {
            $comandos_sql[] = "ALTER TABLE usuarios ADD COLUMN data_cadastro timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP";
        }
        if (!in_array('ultimo_acesso', $colunas_existentes)) {
            $comandos_sql[] = "ALTER TABLE usuarios ADD COLUMN ultimo_acesso timestamp NULL DEFAULT NULL";
        }

        // Verificar se role existe e se é ENUM
        $role_existe = in_array('role', $colunas_existentes);
        if ($role_existe) {
            // Verificar se é ENUM correto
            $stmt = $pdo->query("SHOW COLUMNS FROM usuarios LIKE 'role'");
            $role_info = $stmt->fetch();
            if ($role_info && strpos($role_info['Type'], 'enum') === false) {
                $comandos_sql[] = "ALTER TABLE usuarios MODIFY COLUMN role enum('admin','produtor','promoter') NOT NULL DEFAULT 'promoter'";
            }
        } else {
            $comandos_sql[] = "ALTER TABLE usuarios ADD COLUMN role enum('admin','produtor','promoter') NOT NULL DEFAULT 'promoter'";
        }

        // Verificar status vs ativo
        if (in_array('status', $colunas_existentes) && !in_array('ativo', $colunas_existentes)) {
            // Tem status mas não tem ativo - renomear
            $comandos_sql[] = "ALTER TABLE usuarios CHANGE COLUMN status ativo tinyint(1) DEFAULT 1";
        }

        $sucesso = 0;
        $erros = 0;

        echo "<div class='info'>";
        echo "<p><strong>Total de alterações:</strong> " . count($comandos_sql) . "</p>";
        echo "</div>";

        echo "<pre>";
        foreach ($comandos_sql as $sql) {
            try {
                $pdo->exec($sql);
                echo "✅ " . htmlspecialchars($sql) . "\n";
                $sucesso++;
            } catch (PDOException $e) {
                echo "❌ ERRO: " . htmlspecialchars($e->getMessage()) . "\n";
                echo "   SQL: " . htmlspecialchars($sql) . "\n";
                $erros++;
            }
        }
        echo "</pre>";

        if ($erros === 0) {
            echo "<div class='success'>";
            echo "<h3>🎉 Estrutura Corrigida com Sucesso!</h3>";
            echo "<p>Todas as $sucesso alterações foram aplicadas.</p>";
            echo "<p><a href='corrigir_estrutura_usuarios.php' class='btn'>🔄 Verificar Novamente</a></p>";
            echo "<p><a href='diagnostico_banco.php' class='btn btn-success'>➡️ Ir para Diagnóstico do Banco</a></p>";
            echo "</div>";
        } else {
            echo "<div class='warning'>";
            echo "<h3>⚠️ Correção Parcial</h3>";
            echo "<p><strong>Sucesso:</strong> $sucesso alterações</p>";
            echo "<p><strong>Erros:</strong> $erros alterações</p>";
            echo "<p>Revise os erros acima.</p>";
            echo "</div>";
        }
    }

} catch (PDOException $e) {
    echo "<div class='error'>";
    echo "<h3>❌ Erro de Conexão</h3>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}
?>

</div>
</body>
</html>
