<?php
/**
 * CORRIGIR ROLE ENUM - URGENTE
 * Problema: Role está sendo salvo como 'user' em vez de 'promoter'
 * Solução: Corrigir o ENUM para aceitar os valores corretos
 */

require_once 'config.php';

echo "<h1>Correção URGENTE - Role ENUM</h1>";

try {
    // 1. Verificar estrutura atual
    echo "<h2>1. Estrutura Atual da Coluna Role:</h2>";
    $stmt = $pdo->query("SHOW COLUMNS FROM usuarios WHERE Field = 'role'");
    $column = $stmt->fetch();
    echo "<pre>";
    print_r($column);
    echo "</pre>";

    echo "<p><strong>Tipo atual:</strong> {$column['Type']}</p>";

    // 2. Modificar o ENUM para incluir os valores corretos
    echo "<h2>2. Modificando ENUM da Coluna Role:</h2>";

    // O ENUM correto deve ser: 'promoter', 'admin', 'produtor'
    // Removendo 'user' se existir
    $sql = "ALTER TABLE usuarios MODIFY COLUMN role ENUM('promoter', 'admin', 'produtor') NOT NULL DEFAULT 'promoter'";

    echo "<p>Executando SQL:</p>";
    echo "<code>{$sql}</code><br><br>";

    $pdo->exec($sql);
    echo "<p style='color: green; font-weight: bold;'>✓ ENUM modificado com sucesso!</p>";

    // 3. Verificar novamente
    echo "<h2>3. Estrutura Após Correção:</h2>";
    $stmt = $pdo->query("SHOW COLUMNS FROM usuarios WHERE Field = 'role'");
    $column = $stmt->fetch();
    echo "<pre>";
    print_r($column);
    echo "</pre>";

    // 4. Corrigir usuários que estão como 'user' para 'promoter'
    echo "<h2>4. Corrigindo Usuários Existentes com Role 'user':</h2>";

    // Verificar quantos têm role inválido
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios WHERE role NOT IN ('promoter', 'admin', 'produtor')");
    $count = $stmt->fetch()['total'];

    if ($count > 0) {
        echo "<p>Encontrados <strong>{$count}</strong> usuários com role inválido.</p>";

        // Atualizar para 'promoter' (exceto admins)
        $sql = "UPDATE usuarios SET role = 'promoter' WHERE role NOT IN ('promoter', 'admin', 'produtor')";
        $pdo->exec($sql);

        echo "<p style='color: green; font-weight: bold;'>✓ Usuários corrigidos para 'promoter'!</p>";
    } else {
        echo "<p style='color: green;'>✓ Nenhum usuário com role inválido encontrado.</p>";
    }

    // 5. Mostrar status final
    echo "<h2>5. Status Final - Últimos 10 Usuários:</h2>";
    $stmt = $pdo->query("SELECT id, nome, email, role, status FROM usuarios ORDER BY id DESC LIMIT 10");
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr style='background: #f0f0f0;'><th>ID</th><th>Nome</th><th>Email</th><th>Role</th><th>Status</th></tr>";
    while ($user = $stmt->fetch()) {
        $roleColor = $user['role'] === 'admin' ? 'red' : ($user['role'] === 'produtor' ? 'blue' : 'green');
        echo "<tr>";
        echo "<td>{$user['id']}</td>";
        echo "<td>{$user['nome']}</td>";
        echo "<td>{$user['email']}</td>";
        echo "<td style='color: {$roleColor}; font-weight: bold;'>{$user['role']}</td>";
        echo "<td>{$user['status']}</td>";
        echo "</tr>";
    }
    echo "</table>";

    echo "<hr>";
    echo "<h2 style='color: green;'>✓ CORREÇÃO CONCLUÍDA!</h2>";
    echo "<p>O ENUM agora aceita apenas: <strong>'promoter', 'admin', 'produtor'</strong></p>";
    echo "<p>Todos os novos cadastros serão salvos como <strong>'promoter'</strong> por padrão.</p>";
    echo "<p>Usuários existentes com role inválido foram corrigidos.</p>";

} catch (PDOException $e) {
    echo "<p style='color: red; font-weight: bold;'>❌ ERRO: {$e->getMessage()}</p>";
    echo "<pre>";
    print_r($e);
    echo "</pre>";
}
?>

<style>
    body { font-family: Arial, sans-serif; padding: 20px; }
    h1 { color: #333; }
    h2 { color: #666; margin-top: 30px; }
    code { background: #f5f5f5; padding: 10px; display: block; margin: 10px 0; }
    table { margin: 20px 0; }
    th { text-align: left; padding: 8px; }
    td { padding: 8px; }
</style>
