<?php
// Dashboard - Versao Final com Menu Padronizado
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

require_once 'config.php';
verificarLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];

// Buscar dados do usuario
$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

// Buscar estatisticas
if ($role === 'admin') {
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios WHERE status = 'aprovado' AND role != 'admin'");
    $total_promoters = $stmt->fetch()['total'];

    $stmt = $pdo->query("SELECT COUNT(*) as total FROM eventos WHERE status = 'ativo'");
    $total_eventos = $stmt->fetch()['total'];

    $stmt = $pdo->query("SELECT COUNT(*) as total FROM convidados");
    $total_convidados = $stmt->fetch()['total'];

    $stmt = $pdo->query("SELECT COUNT(*) as total FROM convidados WHERE checkin = 1");
    $total_checkins = $stmt->fetch()['total'];
} elseif ($role === 'produtor') {
    // Estatísticas específicas para produtores (apenas eventos associados)
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM produtor_eventos WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $total_eventos_associados = $stmt->fetch()['total'];

    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM convidados WHERE promoter_id = ?");
    $stmt->execute([$user_id]);
    $total_convidados = $stmt->fetch()['total'];

    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM convidados WHERE promoter_id = ? AND checkin = 1");
    $stmt->execute([$user_id]);
    $total_checkins = $stmt->fetch()['total'];

    $stmt = $pdo->prepare("SELECT COALESCE(SUM(valor), 0) as total FROM comissoes WHERE user_id = ? AND status = 'disponivel'");
    $stmt->execute([$user_id]);
    $result = $stmt->fetch();
    $saldo_disponivel = $result ? $result['total'] : 0;
} else {
    // Estatísticas para promoters (usuários normais)
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM convidados WHERE promoter_id = ?");
    $stmt->execute([$user_id]);
    $total_convidados = $stmt->fetch()['total'];

    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM convidados WHERE promoter_id = ? AND checkin = 1");
    $stmt->execute([$user_id]);
    $total_checkins = $stmt->fetch()['total'];

    $stmt = $pdo->prepare("SELECT COALESCE(SUM(valor), 0) as total FROM comissoes WHERE user_id = ? AND status = 'disponivel'");
    $stmt->execute([$user_id]);
    $result = $stmt->fetch();
    $saldo_disponivel = $result ? $result['total'] : 0;

    $stmt = $pdo->prepare("SELECT pontuacao FROM usuarios WHERE id = ?");
    $stmt->execute([$user_id]);
    $pontuacao = $stmt->fetch()['pontuacao'];
}
?>
<!DOCTYPE html>
<html lang="pt-BR" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">

    <title>Dashboard - Sistema Promoters</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">

    <style>
        .admin-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: rgba(0,0,0,0.2);
            padding: 8px 16px;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 700;
            margin-top: 15px;
        }
    </style>
</head>
<body>

    <?php include 'assets/sidebar-navbar.php'; ?>

    <div class="main-content">
        <div class="content-wrapper">
            <div class="container">
        
        <div class="welcome-section">
            <h1 class="welcome-title">
                <i class="fas fa-hand-wave"></i>
                Olá, <?= htmlspecialchars(explode(' ', $usuario['nome'])[0]) ?>!
            </h1>
            <p class="welcome-subtitle">
                <?php
                if ($role === 'admin') {
                    echo 'Bem-vindo ao painel de administração do sistema';
                } elseif ($role === 'produtor') {
                    echo 'Gerencie seus eventos e acompanhe suas listas';
                } else {
                    echo 'Pronto para gerenciar suas listas e check-ins?';
                }
                ?>
            </p>
            <?php if ($role === 'admin'): ?>
                <div class="admin-badge">
                    <i class="fas fa-crown"></i> ADMINISTRADOR
                </div>
            <?php elseif ($role === 'produtor'): ?>
                <div class="admin-badge">
                    <i class="fas fa-theater-masks"></i> PRODUTOR
                </div>
            <?php elseif (isset($pontuacao)): ?>
                <p class="welcome-subtitle" style="margin-top: 10px;">
                    <i class="fas fa-star"></i>
                    Pontuação: <strong><?= $pontuacao ?></strong> pontos
                </p>
            <?php endif; ?>
        </div>
        
        <div class="stats-grid">
            <?php if ($role === 'admin'): ?>
                <div class="stat-card">
                    <i class="fas fa-users stat-icon"></i>
                    <div class="stat-value"><?= $total_promoters ?></div>
                    <div class="stat-label">Promoters Ativos</div>
                </div>

                <div class="stat-card">
                    <i class="fas fa-calendar-alt stat-icon"></i>
                    <div class="stat-value"><?= $total_eventos ?></div>
                    <div class="stat-label">Eventos Ativos</div>
                </div>

                <div class="stat-card">
                    <i class="fas fa-user-friends stat-icon"></i>
                    <div class="stat-value"><?= $total_convidados ?></div>
                    <div class="stat-label">Total Convidados</div>
                </div>

                <div class="stat-card">
                    <i class="fas fa-check-circle stat-icon"></i>
                    <div class="stat-value"><?= $total_checkins ?></div>
                    <div class="stat-label">Check-ins Realizados</div>
                </div>
            <?php elseif ($role === 'produtor'): ?>
                <div class="stat-card">
                    <i class="fas fa-calendar-alt stat-icon"></i>
                    <div class="stat-value"><?= $total_eventos_associados ?></div>
                    <div class="stat-label">Eventos Associados</div>
                </div>

                <div class="stat-card">
                    <i class="fas fa-user-friends stat-icon"></i>
                    <div class="stat-value"><?= $total_convidados ?></div>
                    <div class="stat-label">Meus Convidados</div>
                </div>

                <div class="stat-card">
                    <i class="fas fa-check-circle stat-icon"></i>
                    <div class="stat-value"><?= $total_checkins ?></div>
                    <div class="stat-label">Presentes</div>
                </div>

                <div class="stat-card">
                    <i class="fas fa-wallet stat-icon"></i>
                    <div class="stat-value"><?= formatarMoeda($saldo_disponivel) ?></div>
                    <div class="stat-label">Saldo Disponível</div>
                </div>
            <?php else: ?>
                <div class="stat-card">
                    <i class="fas fa-user-friends stat-icon"></i>
                    <div class="stat-value"><?= $total_convidados ?></div>
                    <div class="stat-label">Meus Convidados</div>
                </div>
                
                <div class="stat-card">
                    <i class="fas fa-check-circle stat-icon"></i>
                    <div class="stat-value"><?= $total_checkins ?></div>
                    <div class="stat-label">Presentes</div>
                </div>
                
                <div class="stat-card">
                    <i class="fas fa-wallet stat-icon"></i>
                    <div class="stat-value"><?= formatarMoeda($saldo_disponivel) ?></div>
                    <div class="stat-label">Saldo Disponível</div>
                </div>
                
                <div class="stat-card">
                    <i class="fas fa-chart-line stat-icon"></i>
                    <div class="stat-value"><?= $total_convidados > 0 ? round(($total_checkins / $total_convidados) * 100, 1) : 0 ?>%</div>
                    <div class="stat-label">Taxa de Presença</div>
                </div>
            <?php endif; ?>
        </div>

        <?php if ($role === 'admin' || $role === 'gerente'): ?>
        <!-- Painel de Check-ins em Tempo Real -->
        <div id="live-checkins-panel" style="display: none;">
            <div class="live-checkins-container">
                <div class="live-checkins-header">
                    <div class="live-header-left">
                        <i class="fas fa-tower-broadcast live-icon-pulse"></i>
                        <div>
                            <h2 class="live-title">Check-ins em Tempo Real</h2>
                            <p class="live-subtitle">Evento: <span id="evento-nome-live">-</span></p>
                        </div>
                    </div>
                    <div class="live-stats">
                        <div class="live-stat-item">
                            <div class="live-stat-value" id="total-checkins-live">0</div>
                            <div class="live-stat-label">Check-ins Hoje</div>
                        </div>
                    </div>
                </div>

                <div class="live-checkins-list" id="live-checkins-list">
                    <div class="live-empty">
                        <i class="fas fa-hourglass-half"></i>
                        <p>Aguardando check-ins...</p>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <h2 class="section-title">
            <i class="fas fa-bolt"></i>
            Acesso Rápido
        </h2>
        
        <div class="menu-grid">
            <?php if ($role === 'admin'): ?>
                <a href="admin_eventos.php" class="menu-item">
                    <i class="fas fa-calendar-alt menu-icon"></i>
                    <div class="menu-title">Gerenciar Eventos</div>
                </a>

                <a href="admin_usuarios.php" class="menu-item">
                    <i class="fas fa-users menu-icon"></i>
                    <div class="menu-title">Gerenciar Usuários</div>
                </a>

                <a href="admin_convidados.php" class="menu-item">
                    <i class="fas fa-list menu-icon"></i>
                    <div class="menu-title">Ver Convidados</div>
                </a>

                <a href="admin_checkin.php" class="menu-item">
                    <i class="fas fa-qrcode menu-icon"></i>
                    <div class="menu-title">Check-in QR</div>
                </a>

                <a href="admin_checkin_manual.php" class="menu-item">
                    <i class="fas fa-clipboard-check menu-icon"></i>
                    <div class="menu-title">Check-in Manual</div>
                </a>

                <a href="admin_saques.php" class="menu-item">
                    <i class="fas fa-money-bill-wave menu-icon"></i>
                    <div class="menu-title">Saques</div>
                </a>

                <a href="admin_relatorios.php" class="menu-item">
                    <i class="fas fa-chart-bar menu-icon"></i>
                    <div class="menu-title">Relatórios</div>
                </a>
            <?php elseif ($role === 'produtor'): ?>
                <a href="produtor_eventos.php" class="menu-item">
                    <i class="fas fa-calendar-alt menu-icon"></i>
                    <div class="menu-title">Meus Eventos</div>
                </a>

                <a href="produtor_listas.php" class="menu-item">
                    <i class="fas fa-list menu-icon"></i>
                    <div class="menu-title">Minhas Listas</div>
                </a>

                <a href="produtor_financeiro.php" class="menu-item">
                    <i class="fas fa-wallet menu-icon"></i>
                    <div class="menu-title">Financeiro</div>
                </a>
            <?php else: ?>
                <a href="eventos.php" class="menu-item">
                    <i class="fas fa-calendar-alt menu-icon"></i>
                    <div class="menu-title">Eventos</div>
                </a>
                
                <a href="minhas_listas.php" class="menu-item">
                    <i class="fas fa-list menu-icon"></i>
                    <div class="menu-title">Minhas Listas</div>
                </a>
                
                <a href="financeiro.php" class="menu-item">
                    <i class="fas fa-wallet menu-icon"></i>
                    <div class="menu-title">Financeiro</div>
                </a>
                
                <a href="ranking.php" class="menu-item">
                    <i class="fas fa-trophy menu-icon"></i>
                    <div class="menu-title">Ranking</div>
                </a>
            <?php endif; ?>
        </div>

            </div><!-- .container -->
        </div><!-- .content-wrapper -->
    </div><!-- .main-content -->

    <style>
        /* Estilos para painel de check-ins em tempo real - Estilo Hospital/Aeroporto */
        .live-checkins-container {
            background: linear-gradient(135deg, #1a1a1a 0%, #2a2a2a 100%);
            border: 2px solid var(--color-gold);
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 40px;
            box-shadow: 0 10px 40px rgba(255, 215, 0, 0.2);
            animation: slideDown 0.5s ease-out;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .live-checkins-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-bottom: 25px;
            border-bottom: 2px solid rgba(255, 215, 0, 0.3);
            margin-bottom: 25px;
        }

        .live-header-left {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .live-icon-pulse {
            font-size: 48px;
            color: var(--color-gold);
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% {
                opacity: 1;
                transform: scale(1);
            }
            50% {
                opacity: 0.7;
                transform: scale(1.1);
            }
        }

        .live-title {
            font-size: 28px;
            font-weight: 700;
            color: var(--color-gold);
            margin: 0;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .live-subtitle {
            font-size: 16px;
            color: var(--text-secondary);
            margin: 5px 0 0 0;
        }

        .live-stats {
            display: flex;
            gap: 30px;
        }

        .live-stat-item {
            text-align: center;
            background: rgba(255, 215, 0, 0.1);
            padding: 15px 25px;
            border-radius: 12px;
            border: 1px solid rgba(255, 215, 0, 0.3);
        }

        .live-stat-value {
            font-size: 36px;
            font-weight: 700;
            color: var(--color-gold);
            line-height: 1;
        }

        .live-stat-label {
            font-size: 12px;
            color: var(--text-secondary);
            margin-top: 5px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .live-checkins-list {
            max-height: 400px;
            overflow-y: auto;
            overflow-x: hidden;
        }

        .live-checkins-list::-webkit-scrollbar {
            width: 8px;
        }

        .live-checkins-list::-webkit-scrollbar-track {
            background: rgba(0, 0, 0, 0.2);
            border-radius: 10px;
        }

        .live-checkins-list::-webkit-scrollbar-thumb {
            background: var(--color-gold);
            border-radius: 10px;
        }

        .live-checkin-item {
            background: rgba(0, 0, 0, 0.3);
            border-left: 4px solid var(--color-gold);
            padding: 20px;
            margin-bottom: 15px;
            border-radius: 10px;
            animation: slideInLeft 0.5s ease-out;
            transition: all 0.3s;
        }

        .live-checkin-item:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: translateX(5px);
        }

        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-50px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .live-checkin-item.newest {
            background: rgba(255, 215, 0, 0.2);
            border-left-color: #FFD700;
            box-shadow: 0 0 20px rgba(255, 215, 0, 0.3);
        }

        .live-checkin-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 12px;
        }

        .live-checkin-name {
            font-size: 20px;
            font-weight: 700;
            color: var(--color-gold);
            margin-bottom: 5px;
        }

        .live-checkin-time {
            font-size: 16px;
            color: var(--color-gold);
            background: rgba(255, 215, 0, 0.2);
            padding: 5px 12px;
            border-radius: 8px;
            font-weight: 600;
        }

        .live-checkin-details {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 10px;
            margin-top: 10px;
        }

        .live-detail-item {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            color: var(--text-secondary);
        }

        .live-detail-item i {
            color: var(--color-gold);
            font-size: 16px;
        }

        .live-empty {
            text-align: center;
            padding: 60px 20px;
            color: var(--text-secondary);
        }

        .live-empty i {
            font-size: 64px;
            color: rgba(255, 215, 0, 0.3);
            margin-bottom: 15px;
        }

        .live-empty p {
            font-size: 18px;
            margin: 0;
        }

        @media (max-width: 768px) {
            .live-checkins-header {
                flex-direction: column;
                gap: 20px;
            }

            .live-header-left {
                width: 100%;
            }

            .live-stats {
                width: 100%;
                justify-content: center;
            }

            .live-title {
                font-size: 22px;
            }

            .live-checkin-header {
                flex-direction: column;
                gap: 10px;
            }

            .live-checkin-details {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <?php if ($role === 'admin' || $role === 'gerente'): ?>
    <script>
        let lastCheckinId = 0;

        async function atualizarCheckinsLive() {
            try {
                const response = await fetch('checkins_live.php');
                const data = await response.json();

                const panel = document.getElementById('live-checkins-panel');
                const list = document.getElementById('live-checkins-list');
                const eventoNome = document.getElementById('evento-nome-live');
                const totalCheckins = document.getElementById('total-checkins-live');

                if (data.success && data.evento_aberto) {
                    // Mostrar painel
                    panel.style.display = 'block';

                    // Atualizar nome do evento
                    eventoNome.textContent = data.evento.nome;

                    // Atualizar total de check-ins
                    totalCheckins.textContent = data.total_hoje;

                    // Atualizar lista de check-ins
                    if (data.checkins && data.checkins.length > 0) {
                        let html = '';
                        data.checkins.forEach((checkin, index) => {
                            const isNewest = index === 0;
                            const data_formatada = new Date(checkin.checkin_data).toLocaleString('pt-BR');
                            const hora = new Date(checkin.checkin_data).toLocaleTimeString('pt-BR', {
                                hour: '2-digit',
                                minute: '2-digit'
                            });

                            html += `
                                <div class="live-checkin-item ${isNewest ? 'newest' : ''}">
                                    <div class="live-checkin-header">
                                        <div>
                                            <div class="live-checkin-name">
                                                <i class="fas fa-user-check"></i> ${checkin.convidado_nome}
                                            </div>
                                        </div>
                                        <div class="live-checkin-time">
                                            <i class="fas fa-clock"></i> ${hora}
                                        </div>
                                    </div>
                                    <div class="live-checkin-details">
                                        <div class="live-detail-item">
                                            <i class="fas fa-phone"></i>
                                            <span>${checkin.whatsapp}</span>
                                        </div>
                                        <div class="live-detail-item">
                                            <i class="fas fa-calendar-alt"></i>
                                            <span>${checkin.evento_nome}</span>
                                        </div>
                                        <div class="live-detail-item">
                                            <i class="fas fa-user"></i>
                                            <span>Promoter: ${checkin.promoter_nome}</span>
                                        </div>
                                        ${checkin.admin_nome ? `
                                        <div class="live-detail-item">
                                            <i class="fas fa-user-shield"></i>
                                            <span>Admin: ${checkin.admin_nome}</span>
                                        </div>
                                        ` : ''}
                                    </div>
                                </div>
                            `;
                        });
                        list.innerHTML = html;
                    } else {
                        list.innerHTML = `
                            <div class="live-empty">
                                <i class="fas fa-hourglass-half"></i>
                                <p>Aguardando check-ins...</p>
                            </div>
                        `;
                    }
                } else {
                    // Ocultar painel se não há evento aberto
                    panel.style.display = 'none';
                }
            } catch (error) {
                console.error('Erro ao atualizar check-ins:', error);
            }
        }

        // Atualizar a cada 3 segundos
        setInterval(atualizarCheckinsLive, 3000);

        // Atualizar imediatamente ao carregar
        atualizarCheckinsLive();
    </script>
    <?php endif; ?>

</body>
</html>