<?php
// ============================================
// DASHBOARD - VERSÃO DE PRODUÇÃO
// ============================================
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header("Expires: Wed, 11 Jan 1984 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");

require_once 'config.php';
verificarLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];

// Buscar dados do usuário
$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

// Buscar estatísticas gerais
if ($role === 'admin') {
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios WHERE status = 'aprovado' AND role != 'admin'");
    $total_promoters = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM eventos WHERE status = 'ativo'");
    $total_eventos = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM convidados");
    $total_convidados = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM convidados WHERE checkin = 1");
    $total_checkins = $stmt->fetch()['total'];
} else {
    // Estatísticas do promoter
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM convidados WHERE promoter_id = ?");
    $stmt->execute([$user_id]);
    $total_convidados = $stmt->fetch()['total'];
    
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM convidados WHERE promoter_id = ? AND checkin = 1");
    $stmt->execute([$user_id]);
    $total_checkins = $stmt->fetch()['total'];
    
    $stmt = $pdo->prepare("SELECT COALESCE(SUM(valor), 0) as total FROM comissoes WHERE user_id = ? AND status = 'disponivel'");
    $stmt->execute([$user_id]);
    $result = $stmt->fetch();
    $saldo_disponivel = $result ? $result['total'] : 0;
    
    $stmt = $pdo->prepare("SELECT pontuacao FROM usuarios WHERE id = ?");
    $stmt->execute([$user_id]);
    $pontuacao = $stmt->fetch()['pontuacao'];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- META TAGS ANTI-CACHE -->
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    
    <title>Dashboard - Sistema Promoters</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        :root[data-theme="dark"] {
            --bg-primary: #000000;
            --bg-secondary: #1a1a1a;
            --bg-card: #2a2a2a;
            --color-primary: #FFD700;
            --color-secondary: #FFA500;
            --color-text: #ffffff;
            --color-text-secondary: #999999;
            --border-color: #333333;
        }
        
        :root[data-theme="light"] {
            --bg-primary: #ffffff;
            --bg-secondary: #f5f5f5;
            --bg-card: #ffffff;
            --color-primary: #003366;
            --color-secondary: #0066cc;
            --color-text: #000000;
            --color-text-secondary: #666666;
            --border-color: #e0e0e0;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-secondary);
            color: var(--color-text);
            transition: all 0.3s;
        }
        
        .navbar {
            background: var(--bg-primary);
            border-bottom: 2px solid var(--border-color);
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: var(--color-primary);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .navbar-menu {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        
        .nav-link {
            color: var(--color-text);
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 8px;
            transition: all 0.3s;
            font-weight: 500;
        }
        
        .nav-link:hover {
            background: var(--bg-card);
            color: var(--color-primary);
        }
        
        .theme-toggle {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 20px;
            padding: 8px 15px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s;
        }
        
        .theme-toggle:hover {
            border-color: var(--color-primary);
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        
        .welcome-section {
            background: linear-gradient(135deg, var(--color-primary), var(--color-secondary));
            padding: 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            color: #000;
        }
        
        .welcome-section h1 {
            font-size: 32px;
            margin-bottom: 10px;
        }
        
        .welcome-section p {
            font-size: 16px;
            opacity: 0.9;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 15px;
            padding: 25px;
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            border-color: var(--color-primary);
        }
        
        .stat-icon {
            font-size: 40px;
            margin-bottom: 15px;
        }
        
        .stat-value {
            font-size: 36px;
            font-weight: bold;
            color: var(--color-primary);
            margin-bottom: 5px;
        }
        
        .stat-label {
            font-size: 14px;
            color: var(--color-text-secondary);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .card {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
        }
        
        .card-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
            color: var(--color-primary);
        }
        
        .menu-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }
        
        .menu-item {
            background: var(--bg-secondary);
            border: 2px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            text-decoration: none;
            color: var(--color-text);
            transition: all 0.3s;
            text-align: center;
        }
        
        .menu-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            border-color: var(--color-primary);
        }
        
        .menu-item-icon {
            font-size: 48px;
            margin-bottom: 10px;
        }
        
        .menu-item-title {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .menu-item-desc {
            font-size: 14px;
            color: var(--color-text-secondary);
        }
        
        .mobile-menu-toggle {
            display: none;
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            color: var(--color-text);
            font-size: 24px;
            padding: 8px 15px;
            border-radius: 8px;
            cursor: pointer;
        }
        
        @media (max-width: 768px) {
            .mobile-menu-toggle {
                display: block;
            }
            
            .navbar-menu {
                display: none;
                position: absolute;
                top: 70px;
                left: 0;
                right: 0;
                background: var(--bg-primary);
                flex-direction: column;
                padding: 20px;
                border-bottom: 2px solid var(--border-color);
                box-shadow: 0 5px 10px rgba(0,0,0,0.2);
            }
            
            .navbar-menu.active {
                display: flex;
            }
            
            .menu-grid {
                grid-template-columns: 1fr;
            }
            
            .welcome-section h1 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-brand">
            🎉 Promoters System
        </div>
        
        <button class="mobile-menu-toggle" onclick="toggleMobileMenu()">☰</button>
        
        <div class="navbar-menu" id="navbarMenu">
            <a href="dashboard.php" class="nav-link">Dashboard</a>
            <?php if ($role === 'admin'): ?>
                <a href="admin_eventos.php" class="nav-link">Eventos</a>
                <a href="admin_usuarios.php" class="nav-link">Usuários</a>
                <a href="admin_convidados.php" class="nav-link">Convidados</a>
                <a href="admin_saques.php" class="nav-link">Saques</a>
                <a href="admin_checkin.php" class="nav-link">Check-in</a>
            <?php elseif ($role === 'gerente'): ?>
                <a href="gerente_promoters.php" class="nav-link">Promoters</a>
                <a href="gerente_relatorios.php" class="nav-link">Relatórios</a>
            <?php else: ?>
                <a href="eventos.php" class="nav-link">Eventos</a>
                <a href="minhas_listas.php" class="nav-link">Minhas Listas</a>
                <a href="financeiro.php" class="nav-link">Financeiro</a>
            <?php endif; ?>
            <button class="theme-toggle" onclick="toggleTheme()">
                <span id="themeIcon">🌙</span>
                <span id="themeText">Escuro</span>
            </button>
            <a href="logout.php" class="nav-link">Sair</a>
        </div>
    </nav>
    
    <div class="container">
        <div class="welcome-section">
            <h1>Olá, <?= htmlspecialchars($usuario['nome']) ?>! 👋</h1>
            <p>Seja bem-vindo ao seu painel de controle</p>
            <?php if ($role !== 'admin'): ?>
                <p style="margin-top: 10px; font-size: 14px;">
                    ⭐ Pontuação: <?= $pontuacao ?> pontos
                </p>
            <?php endif; ?>
        </div>
        
        <div class="stats-grid">
            <?php if ($role === 'admin'): ?>
                <div class="stat-card">
                    <div class="stat-icon">👥</div>
                    <div class="stat-value"><?= $total_promoters ?></div>
                    <div class="stat-label">Promoters Ativos</div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">🎪</div>
                    <div class="stat-value"><?= $total_eventos ?></div>
                    <div class="stat-label">Eventos Ativos</div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">📋</div>
                    <div class="stat-value"><?= $total_convidados ?></div>
                    <div class="stat-label">Total Convidados</div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">✅</div>
                    <div class="stat-value"><?= $total_checkins ?></div>
                    <div class="stat-label">Check-ins Realizados</div>
                </div>
            <?php else: ?>
                <div class="stat-card">
                    <div class="stat-icon">📋</div>
                    <div class="stat-value"><?= $total_convidados ?></div>
                    <div class="stat-label">Meus Convidados</div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">✅</div>
                    <div class="stat-value"><?= $total_checkins ?></div>
                    <div class="stat-label">Presentes</div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">💰</div>
                    <div class="stat-value"><?= formatarMoeda($saldo_disponivel) ?></div>
                    <div class="stat-label">Saldo Disponível</div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">📊</div>
                    <div class="stat-value"><?= $total_convidados > 0 ? round(($total_checkins / $total_convidados) * 100, 1) : 0 ?>%</div>
                    <div class="stat-label">Taxa de Presença</div>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="card">
            <div class="card-title">🚀 Acesso Rápido</div>
            <div class="menu-grid">
                <?php if ($role === 'admin'): ?>
                    <a href="admin_eventos.php" class="menu-item">
                        <div class="menu-item-icon">🎪</div>
                        <div class="menu-item-title">Gerenciar Eventos</div>
                        <div class="menu-item-desc">Criar e editar eventos</div>
                    </a>
                    
                    <a href="admin_usuarios.php" class="menu-item">
                        <div class="menu-item-icon">👥</div>
                        <div class="menu-item-title">Gerenciar Usuários</div>
                        <div class="menu-item-desc">Aprovar e gerenciar promoters</div>
                    </a>
                    
                    <a href="admin_convidados.php" class="menu-item">
                        <div class="menu-item-icon">📋</div>
                        <div class="menu-item-title">Ver Convidados</div>
                        <div class="menu-item-desc">Visualizar listas por evento</div>
                    </a>
                    
                    <a href="admin_checkin.php" class="menu-item">
                        <div class="menu-item-icon">📱</div>
                        <div class="menu-item-title">Check-in QR</div>
                        <div class="menu-item-desc">Scanner QR Code</div>
                    </a>
                    
                    <a href="admin_checkin_manual.php" class="menu-item">
                        <div class="menu-item-icon">✍️</div>
                        <div class="menu-item-title">Check-in Manual</div>
                        <div class="menu-item-desc">Check-in por lista</div>
                    </a>
                    
                    <a href="admin_relatorios.php" class="menu-item">
                        <div class="menu-item-icon">📊</div>
                        <div class="menu-item-title">Relatórios</div>
                        <div class="menu-item-desc">Análises e estatísticas</div>
                    </a>
                <?php else: ?>
                    <a href="eventos.php" class="menu-item">
                        <div class="menu-item-icon">🎪</div>
                        <div class="menu-item-title">Eventos</div>
                        <div class="menu-item-desc">Ver e participar de eventos</div>
                    </a>
                    
                    <a href="minhas_listas.php" class="menu-item">
                        <div class="menu-item-icon">📋</div>
                        <div class="menu-item-title">Minhas Listas</div>
                        <div class="menu-item-desc">Gerenciar convidados</div>
                    </a>
                    
                    <a href="financeiro.php" class="menu-item">
                        <div class="menu-item-icon">💰</div>
                        <div class="menu-item-title">Financeiro</div>
                        <div class="menu-item-desc">Comissões e saques</div>
                    </a>
                    
                    <a href="ranking.php" class="menu-item">
                        <div class="menu-item-icon">🏆</div>
                        <div class="menu-item-title">Ranking</div>
                        <div class="menu-item-desc">Ver classificação</div>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script>
        // Gerenciamento de tema
        const root = document.documentElement;
        const themeIcon = document.getElementById('themeIcon');
        const themeText = document.getElementById('themeText');
        
        // Carregar tema salvo
        const savedTheme = localStorage.getItem('theme') || 'dark';
        root.setAttribute('data-theme', savedTheme);
        updateThemeButton(savedTheme);
        
        function toggleTheme() {
            const currentTheme = root.getAttribute('data-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            
            root.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
            updateThemeButton(newTheme);
        }
        
        function updateThemeButton(theme) {
            if (theme === 'dark') {
                themeIcon.textContent = '🌙';
                themeText.textContent = 'Escuro';
            } else {
                themeIcon.textContent = '☀️';
                themeText.textContent = 'Claro';
            }
        }
        
        function toggleMobileMenu() {
            document.getElementById('navbarMenu').classList.toggle('active');
        }
    </script>
</body>
</html>