-- Query de Debug: Verificar créditos e cartões do promoter
-- Execute esta query no PhpMyAdmin substituindo USER_ID pelo ID do promoter

-- 1. Ver TODOS os créditos de consumação (tipo = 'credito')
SELECT
    id,
    valor,
    tipo,
    status,
    created_at,
    'CREDITO' as categoria
FROM saques
WHERE user_id = USER_ID AND tipo = 'credito'
ORDER BY created_at DESC;

-- 2. Ver TODOS os cartões de consumo (tipo = 'cartao_consumo')
SELECT
    id,
    valor,
    tipo,
    status,
    created_at,
    'CARTAO' as categoria
FROM saques
WHERE user_id = USER_ID AND tipo = 'cartao_consumo'
ORDER BY created_at DESC;

-- 3. Cálculo atual (o que o sistema faz):
-- Total de créditos com status 'processando' ou 'concluido'
SELECT
    'Créditos Totais' as descricao,
    COALESCE(SUM(valor), 0) as valor
FROM saques
WHERE user_id = USER_ID
AND tipo = 'credito'
AND status IN ('processando', 'concluido');

-- Total de cartões com status 'pendente', 'processando' ou 'concluido'
SELECT
    'Cartões Utilizados' as descricao,
    COALESCE(SUM(valor), 0) as valor
FROM saques
WHERE user_id = USER_ID
AND tipo = 'cartao_consumo'
AND status IN ('pendente', 'processando', 'concluido');

-- 4. Resumo completo por status
SELECT
    tipo,
    status,
    COUNT(*) as quantidade,
    SUM(valor) as valor_total
FROM saques
WHERE user_id = USER_ID
GROUP BY tipo, status
ORDER BY tipo, status;

-- INSTRUÇÕES:
-- 1. Substitua USER_ID pelo ID do promoter (ex: WHERE user_id = 5)
-- 2. Execute cada query separadamente no PhpMyAdmin
-- 3. Anote os resultados para análise
