<?php
/**
 * PÁGINA SECRETA PARA DESENVOLVEDORES
 * Editar informações de rodapé e licenciamento
 *
 * IMPORTANTE: Esta página não aparece em nenhum menu.
 * Acesse diretamente via URL: /dev_footer.php
 * Use apenas quando precisar alterar informações de desenvolvedor/licença.
 * Recomendado: Apague este arquivo após usar.
 */
require_once 'config.php';

// Apenas admin pode acessar
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    die('Acesso negado');
}

$sucesso = '';
$erro = '';

// Buscar configurações atuais do rodapé
try {
    $stmt = $pdo->query("SELECT * FROM rodape_sistema WHERE id = 1");
    $rodape = $stmt->fetch();

    if (!$rodape) {
        $pdo->exec("INSERT INTO rodape_sistema (id) VALUES (1)");
        $stmt = $pdo->query("SELECT * FROM rodape_sistema WHERE id = 1");
        $rodape = $stmt->fetch();
    }
} catch (PDOException $e) {
    $erro = "⚠️ Execute a migration primeiro: migration_whitelabel_v2.sql";
    $rodape = false;
}

// Processar formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$erro) {
    try {
        $stmt = $pdo->prepare("
            UPDATE rodape_sistema SET
                texto_desenvolvido = ?,
                link_desenvolvedor = ?,
                texto_licenciado = ?,
                ano = ?,
                mostrar_versao = ?,
                versao_sistema = ?
            WHERE id = 1
        ");

        if ($stmt->execute([
            $_POST['texto_desenvolvido'],
            $_POST['link_desenvolvedor'],
            $_POST['texto_licenciado'],
            $_POST['ano'],
            isset($_POST['mostrar_versao']) ? 1 : 0,
            $_POST['versao_sistema']
        ])) {
            $sucesso = 'Rodapé atualizado com sucesso!';
            $stmt = $pdo->query("SELECT * FROM rodape_sistema WHERE id = 1");
            $rodape = $stmt->fetch();
        }
    } catch (PDOException $e) {
        $erro = 'Erro: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🔧 DEV - Configuração de Rodapé</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 20px;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
        }

        .warning-banner {
            background: #ff3860;
            color: white;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 30px;
            text-align: center;
            font-weight: 700;
            box-shadow: 0 10px 40px rgba(255, 56, 96, 0.3);
        }

        .warning-banner i {
            font-size: 24px;
            margin-right: 10px;
        }

        .card {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
        }

        .header {
            text-align: center;
            margin-bottom: 40px;
            padding-bottom: 30px;
            border-bottom: 3px solid #667eea;
        }

        .header-icon {
            font-size: 64px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            margin-bottom: 20px;
        }

        .header h1 {
            font-size: 32px;
            color: #2c3e50;
            margin-bottom: 10px;
        }

        .header p {
            color: #7f8c8d;
            font-size: 16px;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-label {
            display: block;
            color: #2c3e50;
            font-weight: 600;
            margin-bottom: 8px;
            font-size: 15px;
        }

        .form-input {
            width: 100%;
            padding: 14px 18px;
            border: 2px solid #e0e6ed;
            border-radius: 10px;
            font-size: 15px;
            transition: all 0.3s ease;
        }

        .form-input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
        }

        .form-checkbox {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 10px;
        }

        .form-checkbox input[type="checkbox"] {
            width: 20px;
            height: 20px;
            cursor: pointer;
        }

        .btn-save {
            width: 100%;
            padding: 18px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 18px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-save:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }

        .btn-back {
            display: block;
            text-align: center;
            margin-top: 20px;
            color: #7f8c8d;
            text-decoration: none;
            font-weight: 600;
        }

        .btn-back:hover {
            color: #667eea;
        }

        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 12px;
            font-weight: 600;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 2px solid #28a745;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 2px solid #dc3545;
        }

        .preview {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin-top: 30px;
            text-align: center;
            border: 2px dashed #dee2e6;
        }

        .preview h3 {
            color: #2c3e50;
            margin-bottom: 15px;
            font-size: 18px;
        }

        .footer-preview {
            color: #6c757d;
            font-size: 14px;
        }

        .footer-preview a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }

        .info-box {
            background: #fff3cd;
            border: 2px solid #ffc107;
            color: #856404;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 25px;
            font-size: 14px;
            line-height: 1.6;
        }

        .info-box strong {
            display: block;
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="warning-banner">
            <i class="fas fa-exclamation-triangle"></i>
            ATENÇÃO: PÁGINA RESTRITA PARA DESENVOLVEDORES
        </div>

        <?php if ($sucesso): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span><?= $sucesso ?></span>
            </div>
        <?php endif; ?>

        <?php if ($erro): ?>
            <div class="alert alert-error">
                <i class="fas fa-times-circle"></i>
                <span><?= $erro ?></span>
            </div>
        <?php endif; ?>

        <div class="card">
            <div class="header">
                <div class="header-icon"><i class="fas fa-code"></i></div>
                <h1>Configuração de Rodapé</h1>
                <p>Edite as informações de desenvolvedor e licenciamento do sistema</p>
            </div>

            <div class="info-box">
                <strong><i class="fas fa-info-circle"></i> Instruções de Uso:</strong>
                Esta página é somente para o desenvolvedor/programador. Após editar as informações, salve e <strong>DELETE ESTE ARQUIVO (dev_footer.php)</strong> por segurança. Você pode fazer upload dele novamente quando precisar fazer alterações.
            </div>

            <?php if ($rodape): ?>
            <form method="POST">
                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-code-branch"></i>
                        Texto "Desenvolvido por"
                    </label>
                    <input type="text" name="texto_desenvolvido" class="form-input"
                           value="<?= htmlspecialchars($rodape['texto_desenvolvido']) ?>"
                           placeholder="Ex: Desenvolvido por Luminaink">
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-link"></i>
                        Link do Desenvolvedor
                    </label>
                    <input type="url" name="link_desenvolvedor" class="form-input"
                           value="<?= htmlspecialchars($rodape['link_desenvolvedor']) ?>"
                           placeholder="Ex: https://luminaink.com.br">
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-copyright"></i>
                        Texto de Licenciamento
                    </label>
                    <input type="text" name="texto_licenciado" class="form-input"
                           value="<?= htmlspecialchars($rodape['texto_licenciado']) ?>"
                           placeholder="Ex: Todos os direitos reservados">
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-calendar"></i>
                            Ano
                        </label>
                        <input type="number" name="ano" class="form-input"
                               value="<?= htmlspecialchars($rodape['ano']) ?>"
                               min="2020" max="2030">
                    </div>

                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-tag"></i>
                            Versão do Sistema
                        </label>
                        <input type="text" name="versao_sistema" class="form-input"
                               value="<?= htmlspecialchars($rodape['versao_sistema']) ?>"
                               placeholder="Ex: v2.0">
                    </div>
                </div>

                <div class="form-group">
                    <div class="form-checkbox">
                        <input type="checkbox" name="mostrar_versao" id="mostrar_versao"
                               <?= $rodape['mostrar_versao'] ? 'checked' : '' ?>>
                        <label for="mostrar_versao">Mostrar versão do sistema no rodapé</label>
                    </div>
                </div>

                <div class="preview">
                    <h3><i class="fas fa-eye"></i> Pré-visualização do Rodapé</h3>
                    <div class="footer-preview">
                        <p>
                            <a href="<?= htmlspecialchars($rodape['link_desenvolvedor']) ?>" target="_blank">
                                <?= htmlspecialchars($rodape['texto_desenvolvido']) ?>
                            </a>
                            © <?= htmlspecialchars($rodape['ano']) ?>
                            <?php if ($rodape['mostrar_versao']): ?>
                                - <?= htmlspecialchars($rodape['versao_sistema']) ?>
                            <?php endif; ?>
                        </p>
                        <p><?= htmlspecialchars($rodape['texto_licenciado']) ?></p>
                    </div>
                </div>

                <button type="submit" class="btn-save">
                    <i class="fas fa-save"></i> Salvar Configurações
                </button>
            </form>
            <?php endif; ?>

            <a href="dashboard.php" class="btn-back">
                <i class="fas fa-arrow-left"></i> Voltar ao Dashboard
            </a>
        </div>
    </div>
</body>
</html>
