<?php
// diagnostico_banco.php - Diagnóstico completo do banco de dados
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Conectar DIRETAMENTE (sem config.php para evitar problemas)
$DB_HOST = 'localhost';
$DB_PORT = '3306';
$DB_NAME = 'invitmecom_promosis';
$DB_USER = 'invitmecom_promosis';
$DB_PASS = 'rH]&iG%{ysipNDnB';

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Diagnóstico do Banco de Dados</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; margin-bottom: 20px; }
        h2 {
            color: #764ba2;
            margin: 25px 0 15px 0;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
        }
        .success {
            background: #d4edda;
            border-left: 4px solid #28a745;
            padding: 15px;
            margin: 15px 0;
            color: #155724;
            border-radius: 5px;
        }
        .error {
            background: #f8d7da;
            border-left: 4px solid #dc3545;
            padding: 15px;
            margin: 15px 0;
            color: #721c24;
            border-radius: 5px;
        }
        .warning {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 15px 0;
            color: #856404;
            border-radius: 5px;
        }
        .info {
            background: #d1ecf1;
            border-left: 4px solid #0c5460;
            padding: 15px;
            margin: 15px 0;
            color: #0c5460;
            border-radius: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
            font-size: 14px;
        }
        table th {
            background: #667eea;
            color: white;
            padding: 12px;
            text-align: left;
        }
        table td {
            padding: 10px 12px;
            border-bottom: 1px solid #dee2e6;
        }
        table tr:hover {
            background: #f8f9fa;
        }
        code {
            background: #e9ecef;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
        }
        .btn {
            background: #667eea;
            color: white;
            padding: 12px 25px;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin: 5px;
        }
        .btn:hover { background: #5568d3; }
        .btn-success { background: #28a745; }
        .btn-success:hover { background: #218838; }
        .btn-danger { background: #dc3545; }
        .btn-danger:hover { background: #c82333; }
        pre {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            font-size: 12px;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>🔍 Diagnóstico Completo do Banco de Dados</h1>

<?php
try {
    $pdo = new PDO(
        "mysql:host=$DB_HOST;port=$DB_PORT;dbname=$DB_NAME;charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );

    echo "<div class='success'>";
    echo "<h3>✅ Conexão com Banco de Dados OK!</h3>";
    echo "<p><strong>Host:</strong> $DB_HOST</p>";
    echo "<p><strong>Banco:</strong> $DB_NAME</p>";
    echo "<p><strong>Usuário:</strong> $DB_USER</p>";
    echo "</div>";

    // 1. Listar todas as tabelas
    echo "<h2>📋 Tabelas no Banco de Dados</h2>";
    $stmt = $pdo->query("SHOW TABLES");
    $tabelas = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($tabelas)) {
        echo "<div class='warning'>";
        echo "<h3>⚠️ Banco de Dados VAZIO!</h3>";
        echo "<p>Nenhuma tabela encontrada. Você precisa executar a instalação.</p>";
        echo "<p><a href='install_direto.php' class='btn btn-success'>🚀 Executar Instalação Agora</a></p>";
        echo "</div>";
    } else {
        echo "<div class='info'>";
        echo "<p>Total de tabelas: <strong>" . count($tabelas) . "</strong></p>";
        echo "<ul style='columns: 2; padding-left: 20px;'>";
        foreach ($tabelas as $tabela) {
            echo "<li>📊 $tabela</li>";
        }
        echo "</ul>";
        echo "</div>";

        // 2. Verificar especificamente as tabelas de usuários
        echo "<h2>👤 Verificar Tabela de Usuários</h2>";

        $tem_users = in_array('users', $tabelas);
        $tem_usuarios = in_array('usuarios', $tabelas);

        echo "<table>";
        echo "<tr><th>Tabela</th><th>Existe?</th><th>Ação</th></tr>";

        echo "<tr>";
        echo "<td><code>users</code> (inglês - ERRADO)</td>";
        echo "<td>" . ($tem_users ? '✅ SIM' : '❌ NÃO') . "</td>";
        echo "<td>" . ($tem_users ? '<span style="color: red;">PRECISA RENOMEAR!</span>' : '✅ OK') . "</td>";
        echo "</tr>";

        echo "<tr>";
        echo "<td><code>usuarios</code> (português - CORRETO)</td>";
        echo "<td>" . ($tem_usuarios ? '✅ SIM' : '❌ NÃO') . "</td>";
        echo "<td>" . ($tem_usuarios ? '✅ OK' : '<span style="color: red;">PRECISA CRIAR!</span>') . "</td>";
        echo "</tr>";

        echo "</table>";

        // Se tem users mas não tem usuarios, oferecer renomear
        if ($tem_users && !$tem_usuarios) {
            echo "<div class='error'>";
            echo "<h3>❌ PROBLEMA: Tabela está com nome errado!</h3>";
            echo "<p>A tabela está como <code>users</code> (inglês), mas o código procura <code>usuarios</code> (português).</p>";
            echo "<form method='POST'>";
            echo "<button type='submit' name='renomear_tabela' value='1' class='btn btn-danger'>🔧 Renomear users → usuarios</button>";
            echo "</form>";
            echo "</div>";
        }

        // Se tem usuarios, mostrar dados
        if ($tem_usuarios) {
            echo "<h2>📊 Dados da Tabela 'usuarios'</h2>";

            try {
                $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios");
                $result = $stmt->fetch();
                $total_usuarios = $result['total'];

                echo "<div class='info'>";
                echo "<p><strong>Total de usuários:</strong> $total_usuarios</p>";
                echo "</div>";

                if ($total_usuarios == 0) {
                    echo "<div class='warning'>";
                    echo "<h3>⚠️ Tabela vazia!</h3>";
                    echo "<p>A tabela existe mas não tem usuários cadastrados.</p>";
                    echo "<p>Você precisa criar o primeiro usuário administrador.</p>";
                    echo "</div>";

                    // Formulário para criar admin
                    echo "<h3>👤 Criar Primeiro Administrador</h3>";
                    echo "<form method='POST' style='background: #f8f9fa; padding: 20px; border-radius: 10px;'>";
                    echo "<div style='margin-bottom: 15px;'>";
                    echo "<label style='display: block; margin-bottom: 5px; font-weight: bold;'>Nome Completo:</label>";
                    echo "<input type='text' name='nome' required style='width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px;' placeholder='Ex: João Silva'>";
                    echo "</div>";

                    echo "<div style='margin-bottom: 15px;'>";
                    echo "<label style='display: block; margin-bottom: 5px; font-weight: bold;'>E-mail:</label>";
                    echo "<input type='email' name='email' required style='width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px;' placeholder='Ex: admin@empresa.com'>";
                    echo "</div>";

                    echo "<div style='margin-bottom: 15px;'>";
                    echo "<label style='display: block; margin-bottom: 5px; font-weight: bold;'>Senha:</label>";
                    echo "<input type='password' name='senha' required minlength='6' style='width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px;' placeholder='Mínimo 6 caracteres'>";
                    echo "</div>";

                    echo "<button type='submit' name='criar_admin' value='1' class='btn btn-success'>✅ Criar Administrador</button>";
                    echo "</form>";

                } else {
                    echo "<h3>Usuários Cadastrados:</h3>";
                    $stmt = $pdo->query("SELECT id, nome, email, role, ativo, data_cadastro FROM usuarios ORDER BY id ASC");
                    $usuarios = $stmt->fetchAll();

                    echo "<table>";
                    echo "<tr><th>ID</th><th>Nome</th><th>E-mail</th><th>Tipo</th><th>Status</th><th>Cadastro</th></tr>";

                    foreach ($usuarios as $user) {
                        $status = $user['ativo'] ? '<span style="color: green;">✅ Ativo</span>' : '<span style="color: red;">❌ Inativo</span>';
                        $role_badge = '';
                        switch($user['role']) {
                            case 'admin': $role_badge = '<span style="background: #dc3545; color: white; padding: 3px 8px; border-radius: 3px; font-size: 11px;">ADMIN</span>'; break;
                            case 'produtor': $role_badge = '<span style="background: #ffc107; color: black; padding: 3px 8px; border-radius: 3px; font-size: 11px;">PRODUTOR</span>'; break;
                            case 'promoter': $role_badge = '<span style="background: #28a745; color: white; padding: 3px 8px; border-radius: 3px; font-size: 11px;">PROMOTER</span>'; break;
                        }

                        echo "<tr>";
                        echo "<td>{$user['id']}</td>";
                        echo "<td>{$user['nome']}</td>";
                        echo "<td>{$user['email']}</td>";
                        echo "<td>$role_badge</td>";
                        echo "<td>$status</td>";
                        echo "<td>" . date('d/m/Y H:i', strtotime($user['data_cadastro'])) . "</td>";
                        echo "</tr>";
                    }

                    echo "</table>";

                    echo "<div class='success'>";
                    echo "<h3>✅ Usuários encontrados!</h3>";
                    echo "<p>Você pode fazer login com um dos e-mails acima.</p>";
                    echo "<p><a href='login.php' class='btn'>➡️ Ir para Login</a></p>";
                    echo "</div>";
                }

            } catch (PDOException $e) {
                echo "<div class='error'>";
                echo "<p>❌ Erro ao consultar tabela usuarios: " . htmlspecialchars($e->getMessage()) . "</p>";
                echo "</div>";
            }
        }

        // Se tem users (inglês), mostrar dados também
        if ($tem_users) {
            echo "<h2>📊 Dados da Tabela 'users' (NOME ERRADO - em inglês)</h2>";

            try {
                $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios");
                $result = $stmt->fetch();
                $total_users = $result['total'];

                echo "<div class='warning'>";
                echo "<p><strong>Total de usuários na tabela 'users':</strong> $total_users</p>";
                echo "</div>";

                if ($total_users > 0) {
                    $stmt = $pdo->query("SELECT id, nome, email, role FROM usuarios LIMIT 5");
                    $users = $stmt->fetchAll();

                    echo "<p>Primeiros usuários encontrados:</p>";
                    echo "<table>";
                    echo "<tr><th>ID</th><th>Nome</th><th>E-mail</th><th>Tipo</th></tr>";
                    foreach ($users as $user) {
                        echo "<tr>";
                        echo "<td>{$user['id']}</td>";
                        echo "<td>{$user['nome']}</td>";
                        echo "<td>{$user['email']}</td>";
                        echo "<td>{$user['role']}</td>";
                        echo "</tr>";
                    }
                    echo "</table>";

                    echo "<div class='error'>";
                    echo "<h3>⚠️ ATENÇÃO: Você tem $total_users usuários na tabela 'users'</h3>";
                    echo "<p>Mas o sistema procura na tabela 'usuarios'. Por isso o login não funciona!</p>";
                    echo "<p><strong>Solução:</strong> Renomear a tabela clicando no botão acima.</p>";
                    echo "</div>";
                }

            } catch (PDOException $e) {
                echo "<div class='error'>";
                echo "<p>❌ Erro ao consultar tabela users: " . htmlspecialchars($e->getMessage()) . "</p>";
                echo "</div>";
            }
        }
    }

    // Processar ação de renomear tabela
    if (isset($_POST['renomear_tabela'])) {
        echo "<h2>🔧 Renomeando Tabela...</h2>";

        try {
            $pdo->exec("RENAME TABLE `users` TO `usuarios`");

            echo "<div class='success'>";
            echo "<h3>✅ Tabela renomeada com sucesso!</h3>";
            echo "<p><code>users</code> → <code>usuarios</code></p>";
            echo "<p><a href='diagnostico_banco.php' class='btn'>🔄 Atualizar Página</a></p>";
            echo "<p><a href='login.php' class='btn btn-success'>➡️ Fazer Login Agora</a></p>";
            echo "</div>";

        } catch (PDOException $e) {
            echo "<div class='error'>";
            echo "<h3>❌ Erro ao renomear tabela</h3>";
            echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
            echo "</div>";
        }
    }

    // Processar criação de admin
    if (isset($_POST['criar_admin'])) {
        echo "<h2>👤 Criando Administrador...</h2>";

        $nome = trim($_POST['nome']);
        $email = trim($_POST['email']);
        $senha = $_POST['senha'];
        $senha_hash = password_hash($senha, PASSWORD_DEFAULT);

        try {
            $stmt = $pdo->prepare("INSERT INTO usuarios (nome, email, senha, role, ativo, data_cadastro) VALUES (?, ?, ?, 'admin', 1, NOW())");
            $stmt->execute([$nome, $email, $senha_hash]);

            echo "<div class='success'>";
            echo "<h3>✅ Administrador Criado com Sucesso!</h3>";
            echo "<p><strong>Nome:</strong> $nome</p>";
            echo "<p><strong>E-mail:</strong> $email</p>";
            echo "<p><strong>Senha:</strong> (a que você digitou)</p>";
            echo "<p><strong>Tipo:</strong> Administrador</p>";
            echo "<hr>";
            echo "<p><a href='login.php' class='btn btn-success' style='font-size: 18px; padding: 15px 30px;'>🎉 Fazer Login Agora!</a></p>";
            echo "</div>";

        } catch (PDOException $e) {
            echo "<div class='error'>";
            echo "<h3>❌ Erro ao criar administrador</h3>";
            echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";

            if (strpos($e->getMessage(), 'Duplicate entry') !== false) {
                echo "<p><strong>Este e-mail já está cadastrado!</strong> Use outro e-mail ou faça login.</p>";
            }
            echo "</div>";
        }
    }

} catch (PDOException $e) {
    echo "<div class='error'>";
    echo "<h3>❌ Erro de Conexão com Banco de Dados</h3>";
    echo "<p><strong>Erro:</strong> " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<hr>";
    echo "<p><strong>Configurações utilizadas:</strong></p>";
    echo "<ul>";
    echo "<li><strong>Host:</strong> <code>$DB_HOST</code></li>";
    echo "<li><strong>Porta:</strong> <code>$DB_PORT</code></li>";
    echo "<li><strong>Banco:</strong> <code>$DB_NAME</code></li>";
    echo "<li><strong>Usuário:</strong> <code>$DB_USER</code></li>";
    echo "</ul>";
    echo "<p>Verifique as credenciais no cPanel.</p>";
    echo "</div>";
}
?>

</div>
</body>
</html>
