<?php
/**
 * DIAGNÓSTICO LOGIN URGENTE
 * Verificar por que promoter/produtor não conseguem logar (erro 500)
 */

require_once 'config.php';

echo "<h1>Diagnóstico de Login - Erro 500</h1>";

// 1. Verificar estrutura da tabela usuarios
echo "<h2>1. Estrutura da Coluna Role:</h2>";
try {
    $stmt = $pdo->query("SHOW COLUMNS FROM usuarios WHERE Field = 'role'");
    $column = $stmt->fetch();
    echo "<p><strong>Tipo:</strong> {$column['Type']}</p>";
    echo "<p><strong>Null:</strong> {$column['Null']}</p>";
    echo "<p><strong>Default:</strong> " . ($column['Default'] ?? 'NULL') . "</p>";

    // Extrair valores do ENUM
    if (preg_match("/^enum\((.+)\)$/i", $column['Type'], $matches)) {
        $enum_str = str_replace("'", "", $matches[1]);
        echo "<p><strong>Valores permitidos:</strong> {$enum_str}</p>";

        $enum_values = explode(',', $enum_str);
        echo "<ul>";
        foreach ($enum_values as $val) {
            echo "<li>" . trim($val) . "</li>";
        }
        echo "</ul>";

        // Verificar se tem 'user' em vez de 'promoter'
        if (in_array('user', $enum_values)) {
            echo "<p style='color: red; font-weight: bold;'>❌ PROBLEMA: Encontrado 'user' no ENUM!</p>";
            echo "<p>O sistema espera 'promoter', mas o ENUM permite 'user'.</p>";
        }

        if (!in_array('promoter', $enum_values)) {
            echo "<p style='color: red; font-weight: bold;'>❌ PROBLEMA: 'promoter' NÃO está no ENUM!</p>";
            echo "<p>Quando tenta salvar 'promoter', o MySQL está usando o primeiro valor do ENUM.</p>";
        }
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Erro: {$e->getMessage()}</p>";
}

// 2. Verificar últimos usuários cadastrados
echo "<h2>2. Últimos 10 Usuários Cadastrados:</h2>";
try {
    $stmt = $pdo->query("SELECT id, nome, email, role, status, data_cadastro FROM usuarios ORDER BY id DESC LIMIT 10");
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background: #f0f0f0;'><th>ID</th><th>Nome</th><th>Email</th><th>Role</th><th>Status</th><th>Data</th></tr>";
    while ($user = $stmt->fetch()) {
        $roleStyle = '';
        if ($user['role'] === 'user') {
            $roleStyle = "color: red; font-weight: bold; background: #ffe0e0;";
        } elseif ($user['role'] === 'admin') {
            $roleStyle = "color: blue; font-weight: bold;";
        } else {
            $roleStyle = "color: green; font-weight: bold;";
        }

        echo "<tr>";
        echo "<td>{$user['id']}</td>";
        echo "<td>{$user['nome']}</td>";
        echo "<td>{$user['email']}</td>";
        echo "<td style='{$roleStyle}'>{$user['role']}</td>";
        echo "<td>{$user['status']}</td>";
        echo "<td>{$user['data_cadastro']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} catch (Exception $e) {
    echo "<p style='color: red;'>Erro: {$e->getMessage()}</p>";
}

// 3. Simular o que acontece no login
echo "<h2>3. Teste de Login (Simulação):</h2>";
echo "<p>O que acontece quando um usuário com role='user' tenta logar:</p>";

try {
    // Buscar um usuário com role diferente de admin
    $stmt = $pdo->query("SELECT * FROM usuarios WHERE role != 'admin' AND status = 'aprovado' LIMIT 1");
    $test_user = $stmt->fetch();

    if ($test_user) {
        echo "<p><strong>Usuário de teste:</strong></p>";
        echo "<ul>";
        echo "<li>ID: {$test_user['id']}</li>";
        echo "<li>Nome: {$test_user['nome']}</li>";
        echo "<li>Email: {$test_user['email']}</li>";
        echo "<li>Role: <strong style='color: " . ($test_user['role'] === 'user' ? 'red' : 'green') . ";'>{$test_user['role']}</strong></li>";
        echo "<li>Status: {$test_user['status']}</li>";
        echo "</ul>";

        // Simular o que aconteceria no dashboard
        echo "<h3>Simulação de Acesso ao Dashboard:</h3>";
        echo "<p>Quando este usuário acessa o dashboard.php:</p>";
        echo "<ol>";
        echo "<li>verificarLogin() ✓ (usuário está logado)</li>";
        echo "<li>\$role = '{$test_user['role']}'</li>";

        // Verificar o que acontece com cada role
        if ($test_user['role'] === 'admin') {
            echo "<li style='color: green;'>✓ Role 'admin' - Mostra estatísticas de admin</li>";
        } elseif ($test_user['role'] === 'produtor') {
            echo "<li style='color: green;'>✓ Role 'produtor' - Mostra estatísticas de produtor</li>";
        } elseif ($test_user['role'] === 'promoter') {
            echo "<li style='color: green;'>✓ Role 'promoter' - Mostra estatísticas de promoter</li>";
        } elseif ($test_user['role'] === 'user') {
            echo "<li style='color: red; font-weight: bold;'>❌ Role 'user' - PODE CAUSAR ERRO!</li>";
            echo "<li style='color: red;'>O código não está preparado para role='user', espera 'promoter'</li>";
        } else {
            echo "<li style='color: red; font-weight: bold;'>❌ Role desconhecida: '{$test_user['role']}'</li>";
        }
        echo "</ol>";
    } else {
        echo "<p>Nenhum usuário não-admin aprovado encontrado.</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Erro: {$e->getMessage()}</p>";
}

// 4. Verificar quantos usuários têm cada role
echo "<h2>4. Contagem por Role:</h2>";
try {
    $stmt = $pdo->query("SELECT role, COUNT(*) as total FROM usuarios GROUP BY role");
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr style='background: #f0f0f0;'><th>Role</th><th>Total</th></tr>";
    while ($row = $stmt->fetch()) {
        $style = $row['role'] === 'user' ? "color: red; font-weight: bold;" : "";
        echo "<tr>";
        echo "<td style='{$style}'>{$row['role']}</td>";
        echo "<td style='{$style}'>{$row['total']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} catch (Exception $e) {
    echo "<p style='color: red;'>Erro: {$e->getMessage()}</p>";
}

// 5. Recomendações
echo "<h2>5. RECOMENDAÇÕES:</h2>";
echo "<div style='background: #ffe; padding: 15px; border-left: 4px solid #fa0;'>";
echo "<p><strong>Se encontrou usuários com role='user':</strong></p>";
echo "<ol>";
echo "<li>Execute o script <code>corrigir_role_enum_urgente.php</code></li>";
echo "<li>Isso vai:";
echo "<ul>";
echo "<li>Modificar o ENUM para aceitar apenas: 'promoter', 'admin', 'produtor'</li>";
echo "<li>Corrigir todos os usuários com role='user' para 'promoter'</li>";
echo "</ul>";
echo "</li>";
echo "<li>Após isso, todos os novos cadastros serão salvos corretamente como 'promoter'</li>";
echo "<li>Os logins de promoter/produtor funcionarão sem erro 500</li>";
echo "</ol>";
echo "</div>";

?>

<style>
    body { font-family: Arial, sans-serif; padding: 20px; max-width: 1200px; margin: 0 auto; }
    h1 { color: #333; border-bottom: 3px solid #333; padding-bottom: 10px; }
    h2 { color: #666; margin-top: 30px; border-bottom: 2px solid #ccc; padding-bottom: 5px; }
    h3 { color: #888; }
    table { margin: 20px 0; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    th { text-align: left; padding: 10px; background: #f0f0f0; }
    td { padding: 8px; border-bottom: 1px solid #eee; }
    code { background: #f5f5f5; padding: 2px 6px; border-radius: 3px; font-family: 'Courier New', monospace; }
</style>
