<?php
// fix_all_users_references.php - Corrige todas as referências de users para usuarios
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('max_execution_time', 300);

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Corrigir Referências users → usuarios</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; margin-bottom: 20px; }
        h2 {
            color: #764ba2;
            margin: 25px 0 15px 0;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
        }
        .success {
            background: #d4edda;
            border-left: 4px solid #28a745;
            padding: 15px;
            margin: 15px 0;
            color: #155724;
            border-radius: 5px;
        }
        .error {
            background: #f8d7da;
            border-left: 4px solid #dc3545;
            padding: 15px;
            margin: 15px 0;
            color: #721c24;
            border-radius: 5px;
        }
        .warning {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 15px 0;
            color: #856404;
            border-radius: 5px;
        }
        .info {
            background: #d1ecf1;
            border-left: 4px solid #0c5460;
            padding: 15px;
            margin: 15px 0;
            color: #0c5460;
            border-radius: 5px;
        }
        pre {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            font-size: 12px;
            border: 1px solid #dee2e6;
            max-height: 400px;
            overflow-y: auto;
        }
        .btn {
            background: #667eea;
            color: white;
            padding: 12px 25px;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin: 5px;
        }
        .btn:hover { background: #5568d3; }
        .btn-danger { background: #dc3545; }
        .btn-danger:hover { background: #c82333; }
    </style>
</head>
<body>
<div class="container">
    <h1>🔧 Corrigir Referências: users → usuarios</h1>

<?php

if (!isset($_POST['confirmar'])) {
    // Escanear arquivos
    echo "<h2>📂 Arquivos com Referências a 'users'</h2>";

    $arquivos_php = glob(__DIR__ . '/*.php');
    $arquivos_com_users = [];

    foreach ($arquivos_php as $arquivo) {
        $conteudo = file_get_contents($arquivo);

        // Buscar padrões SQL
        $padroes = [
            'FROM users',
            'INTO users',
            'JOIN users',
            'TABLE users',
            'UPDATE users'
        ];

        $tem_users = false;
        $ocorrencias = [];

        foreach ($padroes as $padrao) {
            if (stripos($conteudo, $padrao) !== false) {
                $tem_users = true;
                $count = substr_count(strtolower($conteudo), strtolower($padrao));
                $ocorrencias[] = "$count x '$padrao'";
            }
        }

        if ($tem_users) {
            $arquivos_com_users[basename($arquivo)] = $ocorrencias;
        }
    }

    if (empty($arquivos_com_users)) {
        echo "<div class='success'>";
        echo "<h3>✅ Nenhum arquivo com referências a 'users' encontrado!</h3>";
        echo "<p>Todos os arquivos já estão corretos.</p>";
        echo "</div>";
    } else {
        echo "<div class='warning'>";
        echo "<p><strong>Total de arquivos encontrados:</strong> " . count($arquivos_com_users) . "</p>";
        echo "</div>";

        echo "<table style='width: 100%; border-collapse: collapse; margin: 15px 0;'>";
        echo "<tr style='background: #667eea; color: white;'>";
        echo "<th style='padding: 12px; text-align: left;'>Arquivo</th>";
        echo "<th style='padding: 12px; text-align: left;'>Ocorrências</th>";
        echo "</tr>";

        foreach ($arquivos_com_users as $arquivo => $ocorrencias) {
            echo "<tr style='border-bottom: 1px solid #dee2e6;'>";
            echo "<td style='padding: 10px;'><strong>$arquivo</strong></td>";
            echo "<td style='padding: 10px;'>" . implode(', ', $ocorrencias) . "</td>";
            echo "</tr>";
        }

        echo "</table>";

        echo "<div class='error'>";
        echo "<h3>⚠️ ATENÇÃO</h3>";
        echo "<p>Este script vai:</p>";
        echo "<ol style='padding-left: 30px; margin: 15px 0;'>";
        echo "<li>Fazer <strong>backup</strong> de cada arquivo antes de alterar</li>";
        echo "<li>Substituir <code>FROM users</code> por <code>FROM usuarios</code></li>";
        echo "<li>Substituir <code>INTO users</code> por <code>INTO usuarios</code></li>";
        echo "<li>Substituir <code>JOIN users</code> por <code>JOIN usuarios</code></li>";
        echo "<li>Substituir <code>UPDATE users</code> por <code>UPDATE usuarios</code></li>";
        echo "<li>Mostrar um relatório completo</li>";
        echo "</ol>";
        echo "<p><strong>Total de arquivos que serão alterados:</strong> " . count($arquivos_com_users) . "</p>";
        echo "</div>";

        echo "<form method='POST'>";
        echo "<button type='submit' name='confirmar' value='1' class='btn btn-danger'>🔨 CORRIGIR TODOS OS ARQUIVOS AGORA</button>";
        echo "</form>";
    }

} else {
    // Executar correção
    echo "<h2>🔨 Executando Correções...</h2>";

    $arquivos_php = glob(__DIR__ . '/*.php');
    $total_arquivos = 0;
    $total_substituicoes = 0;
    $erros = [];

    echo "<pre>";

    foreach ($arquivos_php as $arquivo) {
        $nome_arquivo = basename($arquivo);

        // Pular este próprio script
        if ($nome_arquivo === 'fix_all_users_references.php') {
            continue;
        }

        $conteudo_original = file_get_contents($arquivo);
        $conteudo_novo = $conteudo_original;

        // Padrões a substituir (case-insensitive)
        $substituicoes = [
            '/FROM\s+users\b/i' => 'FROM usuarios',
            '/INTO\s+users\b/i' => 'INTO usuarios',
            '/JOIN\s+users\b/i' => 'JOIN usuarios',
            '/UPDATE\s+users\b/i' => 'UPDATE usuarios',
            '/TABLE\s+users\b/i' => 'TABLE usuarios',
        ];

        $substituicoes_arquivo = 0;

        foreach ($substituicoes as $pattern => $replacement) {
            $antes = $conteudo_novo;
            $conteudo_novo = preg_replace($pattern, $replacement, $conteudo_novo, -1, $count);
            $substituicoes_arquivo += $count;
        }

        // Se houve mudanças
        if ($conteudo_novo !== $conteudo_original) {
            // Fazer backup
            $backup_file = $arquivo . '.backup_users_' . date('YmdHis');
            if (file_put_contents($backup_file, $conteudo_original)) {
                echo "📦 Backup criado: " . basename($backup_file) . "\n";
            }

            // Salvar arquivo corrigido
            if (file_put_contents($arquivo, $conteudo_novo)) {
                echo "✅ $nome_arquivo - $substituicoes_arquivo substituições\n";
                $total_arquivos++;
                $total_substituicoes += $substituicoes_arquivo;
            } else {
                echo "❌ ERRO ao salvar: $nome_arquivo\n";
                $erros[] = $nome_arquivo;
            }
        }
    }

    echo "</pre>";

    if (empty($erros)) {
        echo "<div class='success'>";
        echo "<h3>🎉 Correção Concluída com Sucesso!</h3>";
        echo "<p><strong>Arquivos corrigidos:</strong> $total_arquivos</p>";
        echo "<p><strong>Total de substituições:</strong> $total_substituicoes</p>";
        echo "<hr>";
        echo "<h4>✅ AGORA TESTE O SISTEMA:</h4>";
        echo "<p><a href='login.php' class='btn' style='font-size: 18px; padding: 15px 30px;'>➡️ ACESSAR LOGIN</a></p>";
        echo "<p><a href='diagnostico_banco.php' class='btn'>🔍 Verificar Banco</a></p>";
        echo "</div>";

        echo "<div class='info'>";
        echo "<h4>📦 Backups Criados</h4>";
        echo "<p>Todos os arquivos alterados têm backup com extensão <code>.backup_users_TIMESTAMP</code></p>";
        echo "<p>Se algo der errado, você pode restaurar os backups.</p>";
        echo "</div>";

    } else {
        echo "<div class='error'>";
        echo "<h3>⚠️ Correção Parcial</h3>";
        echo "<p><strong>Arquivos corrigidos:</strong> $total_arquivos</p>";
        echo "<p><strong>Arquivos com erro:</strong> " . count($erros) . "</p>";
        echo "<p>Arquivos com erro:</p>";
        echo "<ul>";
        foreach ($erros as $erro) {
            echo "<li>$erro</li>";
        }
        echo "</ul>";
        echo "</div>";
    }
}

?>

</div>
</body>
</html>
