<?php
// forcar_limpar_cache.php - Limpar TODOS os caches possíveis
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔄 Limpando TODOS os Caches</h1>";

$resultados = [];

// 1. OPcache
if (function_exists('opcache_reset')) {
    if (opcache_reset()) {
        $resultados[] = "✅ OPcache resetado com sucesso";
    } else {
        $resultados[] = "❌ Falha ao resetar OPcache";
    }
} else {
    $resultados[] = "⚠️ OPcache não disponível";
}

// 2. APC Cache (se disponível)
if (function_exists('apc_clear_cache')) {
    apc_clear_cache();
    $resultados[] = "✅ APC Cache limpo";
}

// 3. Invalidar config.php especificamente
$config_files = [
    __DIR__ . '/config.php',
    __DIR__ . '/../config.php',
    $_SERVER['DOCUMENT_ROOT'] . '/sis/config.php',
    $_SERVER['DOCUMENT_ROOT'] . '/config.php',
];

foreach ($config_files as $file) {
    if (file_exists($file)) {
        if (function_exists('opcache_invalidate')) {
            opcache_invalidate($file, true);
            $resultados[] = "✅ Cache invalidado: $file";
        }
        // Forçar reload tocando no arquivo
        touch($file);
        $resultados[] = "✅ Arquivo atualizado (touch): $file";
    }
}

// 4. Limpar stat cache
clearstatcache(true);
$resultados[] = "✅ Stat cache limpo";

// 5. Mostrar resultados
echo "<ul>";
foreach ($resultados as $resultado) {
    echo "<li>$resultado</li>";
}
echo "</ul>";

// 6. Mostrar status do OPcache
if (function_exists('opcache_get_status')) {
    echo "<h2>Status do OPcache</h2>";
    $status = opcache_get_status(false);
    if ($status) {
        echo "<pre>";
        echo "Habilitado: " . ($status['opcache_enabled'] ? 'SIM' : 'NÃO') . "\n";
        echo "Cache cheio: " . ($status['cache_full'] ? 'SIM' : 'NÃO') . "\n";
        echo "Scripts em cache: " . ($status['opcache_statistics']['num_cached_scripts'] ?? 0) . "\n";
        echo "</pre>";
    }
}

echo "<hr>";
echo "<h2>✅ Ação Completada!</h2>";
echo "<p><strong>Agora tente acessar:</strong></p>";
echo "<p><a href='install.php' style='font-size: 20px; padding: 10px 20px; background: green; color: white; text-decoration: none; border-radius: 5px;'>➡️ ACESSAR INSTALL.PHP</a></p>";

echo "<hr>";
echo "<p style='color: red;'><strong>⚠️ IMPORTANTE:</strong> Se ainda der erro, o problema pode ser cache do navegador ou do servidor Apache. Tente:</p>";
echo "<ol>";
echo "<li>Abrir install.php em <strong>aba anônima/privada</strong> do navegador</li>";
echo "<li>Ou adicionar <strong>?nocache=" . time() . "</strong> na URL</li>";
echo "<li>Ou pedir para reiniciar PHP-FPM no cPanel (se disponível)</li>";
echo "</ol>";
?>
