<?php
// install.php - Instalador Automático do Sistema de Gestão de Promoters
// IMPORTANTE: Apague este arquivo após a instalação!

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

$step = isset($_GET['step']) ? (int)$_GET['step'] : 1;
$error = '';
$success = '';

// Verificar se já está instalado
if (file_exists('config.php') && $step === 1) {
    $config_content = file_get_contents('config.php');
    if (strpos($config_content, 'INSTALACAO_CONCLUIDA') !== false) {
        die('<h1>Sistema já instalado!</h1><p>Por segurança, apague o arquivo install.php</p>');
    }
}

// STEP 1: Verificar requisitos
if ($step === 1) {
    $requirements = [
        'PHP >= 7.4' => version_compare(PHP_VERSION, '7.4.0', '>='),
        'PDO Extension' => extension_loaded('pdo'),
        'PDO MySQL' => extension_loaded('pdo_mysql'),
        'OpenSSL' => extension_loaded('openssl'),
        'cURL' => extension_loaded('curl'),
        'GD Library' => extension_loaded('gd'),
        'Permissão de Escrita' => is_writable(__DIR__)
    ];
}

// STEP 2: Configurar banco de dados
if ($step === 2 && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_POST['db_host'] ?? 'localhost';
    $db_name = $_POST['db_name'] ?? '';
    $db_user = $_POST['db_user'] ?? '';
    $db_pass = $_POST['db_pass'] ?? '';
    $db_port = $_POST['db_port'] ?? '3306';

    if (empty($db_name) || empty($db_user)) {
        $error = 'Preencha todos os campos obrigatórios!';
    } else {
        try {
            // Testar conexão
            $dsn = "mysql:host=$db_host;port=$db_port;charset=utf8mb4";
            $pdo = new PDO($dsn, $db_user, $db_pass, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ]);

            // Criar banco de dados se não existir
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $pdo->exec("USE `$db_name`");

            // Executar SQL de instalação
            $sql = file_get_contents('install_database.sql');
            $pdo->exec($sql);

            // Criar arquivo config.php
            $config_content = "<?php
// config.php - Configurações do Sistema
// Gerado automaticamente pelo instalador em " . date('Y-m-d H:i:s') . "
// INSTALACAO_CONCLUIDA

// Configurações do Banco de Dados
define('DB_HOST', '$db_host');
define('DB_PORT', '$db_port');
define('DB_NAME', '$db_name');
define('DB_USER', '$db_user');
define('DB_PASS', '$db_pass');

// Configurações de Segurança
define('SESSION_NAME', 'PROMOTERS_SESSION');
define('SESSION_LIFETIME', 7200); // 2 horas

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Iniciar sessão
if (session_status() === PHP_STATUS_NONE) {
    session_name(SESSION_NAME);
    session_set_cookie_params([
        'lifetime' => SESSION_LIFETIME,
        'path' => '/',
        'domain' => '',
        'secure' => isset(\$_SERVER['HTTPS']),
        'httponly' => true,
        'samesite' => 'Strict'
    ]);
    session_start();
}

// Conexão com o banco de dados
try {
    \$dsn = 'mysql:host=' . DB_HOST . ';port=' . DB_PORT . ';dbname=' . DB_NAME . ';charset=utf8mb4';
    \$pdo = new PDO(\$dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
        PDO::MYSQL_ATTR_INIT_COMMAND => \"SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci\"
    ]);
} catch (PDOException \$e) {
    error_log('Erro de conexão: ' . \$e->getMessage());
    die('<h1>Erro na conexão com o banco de dados</h1><p>Verifique as configurações em config.php</p>');
}

// Funções de segurança
function verificarLogin() {
    if (!isset(\$_SESSION['user_id'])) {
        header('Location: login.php');
        exit;
    }
}

function verificarRole(\$roles_permitidos) {
    if (!isset(\$_SESSION['role']) || !in_array(\$_SESSION['role'], \$roles_permitidos)) {
        header('Location: dashboard.php');
        exit;
    }
}

// Funções auxiliares
function formatarMoeda(\$valor) {
    return 'R$ ' . number_format(\$valor, 2, ',', '.');
}

function formatarData(\$data) {
    return date('d/m/Y', strtotime(\$data));
}

function formatarDataHora(\$data) {
    return date('d/m/Y H:i', strtotime(\$data));
}

// Configurações adicionais
ini_set('upload_max_filesize', '50M');
ini_set('post_max_size', '50M');
ini_set('max_execution_time', '300');
";

            file_put_contents('config.php', $config_content);
            chmod('config.php', 0644);

            $_SESSION['install_success'] = true;
            header('Location: install.php?step=3');
            exit;

        } catch (PDOException $e) {
            $error = 'Erro ao conectar no banco de dados: ' . $e->getMessage();
        } catch (Exception $e) {
            $error = 'Erro na instalação: ' . $e->getMessage();
        }
    }
}

// STEP 3: Configurar admin
if ($step === 3 && $_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once 'config.php';

    $admin_nome = trim($_POST['admin_nome'] ?? '');
    $admin_email = trim($_POST['admin_email'] ?? '');
    $admin_senha = $_POST['admin_senha'] ?? '';
    $admin_confirmar = $_POST['admin_confirmar'] ?? '';

    if (empty($admin_nome) || empty($admin_email) || empty($admin_senha)) {
        $error = 'Preencha todos os campos!';
    } elseif (!filter_var($admin_email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Email inválido!';
    } elseif (strlen($admin_senha) < 6) {
        $error = 'A senha deve ter no mínimo 6 caracteres!';
    } elseif ($admin_senha !== $admin_confirmar) {
        $error = 'As senhas não conferem!';
    } else {
        try {
            // Atualizar ou criar usuário admin
            $senha_hash = password_hash($admin_senha, PASSWORD_DEFAULT);

            $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE email = ?");
            $stmt->execute([$admin_email]);

            if ($stmt->fetch()) {
                // Atualizar admin existente
                $stmt = $pdo->prepare("UPDATE usuarios SET nome = ?, senha = ?, status = 'aprovado' WHERE email = ?");
                $stmt->execute([$admin_nome, $senha_hash, $admin_email]);
            } else {
                // Criar novo admin
                $stmt = $pdo->prepare("INSERT INTO usuarios (nome, email, senha, role, status) VALUES (?, ?, ?, 'admin', 'aprovado')");
                $stmt->execute([$admin_nome, $admin_email, $senha_hash]);
            }

            $_SESSION['install_complete'] = true;
            header('Location: install.php?step=4');
            exit;

        } catch (PDOException $e) {
            $error = 'Erro ao criar administrador: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalação - Sistema de Gestão de Promoters</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a1a1a 0%, #2a2a2a 100%);
            color: #ffffff;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .install-container {
            background: #2a2a2a;
            border-radius: 20px;
            padding: 40px;
            max-width: 700px;
            width: 100%;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5);
            border: 2px solid #FFD700;
        }

        .install-header {
            text-align: center;
            margin-bottom: 40px;
        }

        .install-header h1 {
            font-size: 32px;
            color: #FFD700;
            margin-bottom: 10px;
        }

        .install-header p {
            color: #999;
            font-size: 14px;
        }

        .progress-bar {
            display: flex;
            justify-content: space-between;
            margin-bottom: 40px;
            position: relative;
        }

        .progress-bar::before {
            content: '';
            position: absolute;
            top: 20px;
            left: 0;
            right: 0;
            height: 2px;
            background: #444;
            z-index: 0;
        }

        .progress-step {
            text-align: center;
            flex: 1;
            position: relative;
            z-index: 1;
        }

        .progress-step-circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #444;
            color: #999;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            font-weight: bold;
            transition: all 0.3s;
        }

        .progress-step.active .progress-step-circle {
            background: #FFD700;
            color: #000;
        }

        .progress-step.completed .progress-step-circle {
            background: #00C851;
            color: #fff;
        }

        .progress-step-label {
            font-size: 12px;
            color: #999;
        }

        .progress-step.active .progress-step-label {
            color: #FFD700;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #FFD700;
            font-weight: 600;
        }

        .form-group input {
            width: 100%;
            padding: 12px 15px;
            background: #1a1a1a;
            border: 2px solid #444;
            border-radius: 8px;
            color: #fff;
            font-size: 14px;
            transition: border-color 0.3s;
        }

        .form-group input:focus {
            outline: none;
            border-color: #FFD700;
        }

        .form-group small {
            display: block;
            margin-top: 5px;
            color: #999;
            font-size: 12px;
        }

        .alert {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
        }

        .alert-error {
            background: rgba(255, 68, 68, 0.2);
            border: 1px solid #ff4444;
            color: #ff4444;
        }

        .alert-success {
            background: rgba(0, 200, 81, 0.2);
            border: 1px solid #00C851;
            color: #00C851;
        }

        .requirements-list {
            list-style: none;
        }

        .requirements-list li {
            padding: 12px;
            margin-bottom: 10px;
            background: #1a1a1a;
            border-radius: 8px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .req-ok {
            color: #00C851;
        }

        .req-error {
            color: #ff4444;
        }

        .btn {
            padding: 14px 30px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-block;
        }

        .btn-primary {
            background: #FFD700;
            color: #000;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 215, 0, 0.4);
        }

        .btn-secondary {
            background: #444;
            color: #fff;
            margin-right: 10px;
        }

        .actions {
            display: flex;
            gap: 10px;
            margin-top: 30px;
        }

        .success-icon {
            font-size: 80px;
            color: #00C851;
            text-align: center;
            margin-bottom: 20px;
        }

        .warning-box {
            background: rgba(255, 165, 0, 0.1);
            border: 2px solid #FFA500;
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
        }

        .warning-box strong {
            color: #FFA500;
        }

        @media (max-width: 600px) {
            .install-container {
                padding: 20px;
            }

            .install-header h1 {
                font-size: 24px;
            }

            .progress-bar {
                flex-wrap: wrap;
            }

            .progress-step {
                flex-basis: 100%;
                margin-bottom: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="install-container">
        <div class="install-header">
            <h1><i class="fas fa-rocket"></i> Instalação do Sistema</h1>
            <p>Sistema de Gestão de Promoters</p>
        </div>

        <!-- Barra de Progresso -->
        <div class="progress-bar">
            <div class="progress-step <?= $step >= 1 ? 'active' : '' ?> <?= $step > 1 ? 'completed' : '' ?>">
                <div class="progress-step-circle">1</div>
                <div class="progress-step-label">Requisitos</div>
            </div>
            <div class="progress-step <?= $step >= 2 ? 'active' : '' ?> <?= $step > 2 ? 'completed' : '' ?>">
                <div class="progress-step-circle">2</div>
                <div class="progress-step-label">Banco de Dados</div>
            </div>
            <div class="progress-step <?= $step >= 3 ? 'active' : '' ?> <?= $step > 3 ? 'completed' : '' ?>">
                <div class="progress-step-circle">3</div>
                <div class="progress-step-label">Administrador</div>
            </div>
            <div class="progress-step <?= $step >= 4 ? 'active' : '' ?>">
                <div class="progress-step-circle">4</div>
                <div class="progress-step-label">Concluído</div>
            </div>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-triangle"></i> <?= htmlspecialchars($error) ?>
            </div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> <?= htmlspecialchars($success) ?>
            </div>
        <?php endif; ?>

        <!-- STEP 1: Verificar Requisitos -->
        <?php if ($step === 1): ?>
            <h2 style="color: #FFD700; margin-bottom: 20px;"><i class="fas fa-check-circle"></i> Verificar Requisitos</h2>

            <ul class="requirements-list">
                <?php foreach ($requirements as $name => $status): ?>
                    <li>
                        <span><?= $name ?></span>
                        <span class="<?= $status ? 'req-ok' : 'req-error' ?>">
                            <?php if ($status): ?>
                                <i class="fas fa-check-circle"></i> OK
                            <?php else: ?>
                                <i class="fas fa-times-circle"></i> ERRO
                            <?php endif; ?>
                        </span>
                    </li>
                <?php endforeach; ?>
            </ul>

            <?php if (in_array(false, $requirements)): ?>
                <div class="alert alert-error" style="margin-top: 20px;">
                    <i class="fas fa-exclamation-triangle"></i>
                    Alguns requisitos não foram atendidos. Corrija-os antes de continuar.
                </div>
            <?php else: ?>
                <div class="actions">
                    <a href="install.php?step=2" class="btn btn-primary">
                        <i class="fas fa-arrow-right"></i> Próximo: Configurar Banco
                    </a>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <!-- STEP 2: Configurar Banco de Dados -->
        <?php if ($step === 2): ?>
            <h2 style="color: #FFD700; margin-bottom: 20px;"><i class="fas fa-database"></i> Configurar Banco de Dados</h2>

            <form method="POST">
                <div class="form-group">
                    <label><i class="fas fa-server"></i> Host do Banco</label>
                    <input type="text" name="db_host" value="localhost" required>
                    <small>Geralmente "localhost" em servidores cPanel</small>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-network-wired"></i> Porta</label>
                    <input type="text" name="db_port" value="3306" required>
                    <small>Porta padrão do MySQL: 3306</small>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-database"></i> Nome do Banco de Dados</label>
                    <input type="text" name="db_name" placeholder="promoters_db" required>
                    <small>Crie o banco no cPanel/PHPMyAdmin antes</small>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-user"></i> Usuário do Banco</label>
                    <input type="text" name="db_user" placeholder="root" required>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-key"></i> Senha do Banco</label>
                    <input type="password" name="db_pass" placeholder="••••••••">
                    <small>Deixe em branco se não houver senha (localhost)</small>
                </div>

                <div class="actions">
                    <a href="install.php?step=1" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Voltar
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-database"></i> Criar Banco e Continuar
                    </button>
                </div>
            </form>
        <?php endif; ?>

        <!-- STEP 3: Configurar Administrador -->
        <?php if ($step === 3): ?>
            <h2 style="color: #FFD700; margin-bottom: 20px;"><i class="fas fa-user-shield"></i> Criar Administrador</h2>

            <form method="POST">
                <div class="form-group">
                    <label><i class="fas fa-user"></i> Nome Completo</label>
                    <input type="text" name="admin_nome" placeholder="João Silva" required>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-envelope"></i> Email</label>
                    <input type="email" name="admin_email" placeholder="admin@seu-dominio.com" required>
                    <small>Use este email para fazer login</small>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-lock"></i> Senha</label>
                    <input type="password" name="admin_senha" placeholder="••••••••" required minlength="6">
                    <small>Mínimo 6 caracteres</small>
                </div>

                <div class="form-group">
                    <label><i class="fas fa-lock"></i> Confirmar Senha</label>
                    <input type="password" name="admin_confirmar" placeholder="••••••••" required minlength="6">
                </div>

                <div class="actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-check"></i> Criar Administrador e Finalizar
                    </button>
                </div>
            </form>
        <?php endif; ?>

        <!-- STEP 4: Instalação Concluída -->
        <?php if ($step === 4): ?>
            <div class="success-icon">
                <i class="fas fa-check-circle"></i>
            </div>

            <h2 style="color: #00C851; text-align: center; margin-bottom: 20px;">
                Instalação Concluída!
            </h2>

            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                O sistema foi instalado com sucesso!
            </div>

            <div class="warning-box">
                <strong><i class="fas fa-shield-alt"></i> IMPORTANTE - SEGURANÇA:</strong>
                <ol style="margin-top: 10px; padding-left: 20px;">
                    <li>APAGUE o arquivo <code>install.php</code> AGORA!</li>
                    <li>Descomente as linhas de bloqueio no arquivo <code>.htaccess</code></li>
                    <li>Faça login e altere a senha do administrador</li>
                    <li>Configure SSL (HTTPS) no seu domínio</li>
                </ol>
            </div>

            <div style="background: #1a1a1a; padding: 20px; border-radius: 8px; margin: 20px 0;">
                <h3 style="color: #FFD700; margin-bottom: 15px;">Próximos Passos:</h3>
                <ul style="list-style: none; padding: 0;">
                    <li style="padding: 8px 0;"><i class="fas fa-check" style="color: #00C851;"></i> Banco de dados criado</li>
                    <li style="padding: 8px 0;"><i class="fas fa-check" style="color: #00C851;"></i> Tabelas criadas</li>
                    <li style="padding: 8px 0;"><i class="fas fa-check" style="color: #00C851;"></i> Administrador configurado</li>
                    <li style="padding: 8px 0;"><i class="fas fa-check" style="color: #00C851;"></i> Sistema pronto para uso</li>
                </ul>
            </div>

            <div class="actions" style="justify-content: center;">
                <a href="login.php" class="btn btn-primary">
                    <i class="fas fa-sign-in-alt"></i> Fazer Login Agora
                </a>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
