<?php
// install_direto.php - Instalador DIRETO sem usar config.php (para evitar cache)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Iniciar output buffering AQUI MESMO
if (ob_get_level() == 0) {
    ob_start();
}

// Iniciar sessão AQUI MESMO (com a constante CORRETA)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Configurações do Banco de Dados DIRETO
$DB_HOST = 'localhost';
$DB_PORT = '3306';
$DB_NAME = 'invitmecom_promosis';
$DB_USER = 'invitmecom_promosis';
$DB_PASS = 'rH]&iG%{ysipNDnB';

// Conectar DIRETAMENTE
try {
    $pdo = new PDO(
        "mysql:host=$DB_HOST;port=$DB_PORT;dbname=$DB_NAME;charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );

    echo "<!DOCTYPE html>
<html lang='pt-BR'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Instalação Direta - PromoTaal</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 20px;
            padding: 40px;
            max-width: 600px;
            width: 100%;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 {
            color: #667eea;
            margin-bottom: 10px;
            font-size: 28px;
        }
        .success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .info {
            background: #d1ecf1;
            border: 1px solid #bee5eb;
            color: #0c5460;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .btn {
            background: #667eea;
            color: white;
            padding: 15px 30px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin-top: 20px;
        }
        .btn:hover {
            background: #5568d3;
        }
        .sql-output {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
            max-height: 400px;
            overflow-y: auto;
            font-family: monospace;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class='container'>";

    echo "<h1>🎉 Conexão Bem-Sucedida!</h1>";
    echo "<div class='success'>";
    echo "<strong>✅ Banco de dados conectado com sucesso!</strong><br>";
    echo "Host: $DB_HOST<br>";
    echo "Banco: $DB_NAME<br>";
    echo "Usuário: $DB_USER<br>";
    echo "Versão PHP: " . phpversion();
    echo "</div>";

    // Verificar se o POST foi enviado
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['instalar'])) {
        echo "<h2>📦 Executando Instalação...</h2>";

        $sql_file = __DIR__ . '/install_database.sql';

        if (!file_exists($sql_file)) {
            echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 15px; border-radius: 8px;'>";
            echo "❌ Arquivo install_database.sql não encontrado em: $sql_file";
            echo "</div>";
        } else {
            // Ler o arquivo SQL
            $sql_content = file_get_contents($sql_file);

            // Dividir em comandos
            $sql_commands = array_filter(
                array_map('trim',
                    preg_split('/;(\s*\n|$)/', $sql_content)
                ),
                function($cmd) {
                    return !empty($cmd) && substr($cmd, 0, 2) !== '--' && substr($cmd, 0, 2) !== '/*';
                }
            );

            echo "<div class='info'>";
            echo "Total de comandos SQL a executar: " . count($sql_commands);
            echo "</div>";

            echo "<div class='sql-output'>";
            $sucesso = 0;
            $erros = 0;

            foreach ($sql_commands as $i => $comando) {
                try {
                    $pdo->exec($comando);
                    echo "✅ Comando " . ($i + 1) . " executado com sucesso<br>";
                    $sucesso++;
                } catch (PDOException $e) {
                    echo "<span style='color: red;'>❌ Erro no comando " . ($i + 1) . ": " . htmlspecialchars($e->getMessage()) . "</span><br>";
                    $erros++;
                }
            }

            echo "</div>";

            if ($erros === 0) {
                echo "<div class='success'>";
                echo "<h3>🎉 Instalação Completada com Sucesso!</h3>";
                echo "<p>Todos os $sucesso comandos foram executados sem erros.</p>";
                echo "<p><strong>Próximo passo:</strong> Crie seu primeiro usuário administrador no formulário abaixo.</p>";
                echo "</div>";

                // Formulário para criar admin
                echo "<h2>👤 Criar Usuário Administrador</h2>";
                echo "<form method='POST' style='margin-top: 20px;'>";
                echo "<div style='margin-bottom: 15px;'>";
                echo "<label style='display: block; margin-bottom: 5px; font-weight: bold;'>Nome Completo:</label>";
                echo "<input type='text' name='nome' required style='width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px;'>";
                echo "</div>";

                echo "<div style='margin-bottom: 15px;'>";
                echo "<label style='display: block; margin-bottom: 5px; font-weight: bold;'>E-mail:</label>";
                echo "<input type='email' name='email' required style='width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px;'>";
                echo "</div>";

                echo "<div style='margin-bottom: 15px;'>";
                echo "<label style='display: block; margin-bottom: 5px; font-weight: bold;'>Senha:</label>";
                echo "<input type='password' name='senha' required minlength='6' style='width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px;'>";
                echo "</div>";

                echo "<button type='submit' name='criar_admin' class='btn'>Criar Administrador</button>";
                echo "</form>";

            } else {
                echo "<div style='background: #fff3cd; border: 1px solid #ffeeba; color: #856404; padding: 15px; border-radius: 8px;'>";
                echo "<strong>⚠️ Instalação parcial</strong><br>";
                echo "Sucesso: $sucesso comandos<br>";
                echo "Erros: $erros comandos<br>";
                echo "Revise os erros acima e tente novamente.";
                echo "</div>";
            }
        }

    } elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['criar_admin'])) {
        // Criar usuário admin
        $nome = trim($_POST['nome']);
        $email = trim($_POST['email']);
        $senha = $_POST['senha'];
        $senha_hash = password_hash($senha, PASSWORD_DEFAULT);

        try {
            $stmt = $pdo->prepare("INSERT INTO usuarios (nome, email, senha, role, ativo, data_cadastro) VALUES (?, ?, ?, 'admin', 1, NOW())");
            $stmt->execute([$nome, $email, $senha_hash]);

            echo "<div class='success'>";
            echo "<h3>✅ Administrador Criado!</h3>";
            echo "<p><strong>Nome:</strong> $nome</p>";
            echo "<p><strong>E-mail:</strong> $email</p>";
            echo "<p><strong>Senha:</strong> (a que você digitou)</p>";
            echo "<p><a href='login.php' class='btn'>➡️ Ir para Login</a></p>";
            echo "</div>";

        } catch (PDOException $e) {
            echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 15px; border-radius: 8px;'>";
            echo "❌ Erro ao criar administrador: " . htmlspecialchars($e->getMessage());
            echo "</div>";
        }

    } else {
        // Verificar se já está instalado
        try {
            $result = $pdo->query("SHOW TABLES LIKE 'usuarios'");
            $table_exists = $result->rowCount() > 0;

            if ($table_exists) {
                echo "<div class='info'>";
                echo "<h3>ℹ️ Sistema Já Instalado</h3>";
                echo "<p>As tabelas do banco de dados já existem.</p>";
                echo "<p>Se quiser reinstalar, delete todas as tabelas primeiro via phpMyAdmin.</p>";
                echo "<p><a href='login.php' class='btn'>➡️ Ir para Login</a></p>";
                echo "</div>";
            } else {
                echo "<div class='info'>";
                echo "<h3>📋 Pronto para Instalar</h3>";
                echo "<p>O banco de dados está vazio e pronto para receber as tabelas.</p>";
                echo "<form method='POST'>";
                echo "<button type='submit' name='instalar' value='1' class='btn'>🚀 Iniciar Instalação</button>";
                echo "</form>";
                echo "</div>";
            }
        } catch (PDOException $e) {
            echo "<div class='info'>";
            echo "<h3>📋 Pronto para Instalar</h3>";
            echo "<p>O banco de dados está pronto para receber as tabelas.</p>";
            echo "<form method='POST'>";
            echo "<button type='submit' name='instalar' value='1' class='btn'>🚀 Iniciar Instalação</button>";
            echo "</form>";
            echo "</div>";
        }
    }

    echo "</div></body></html>";

} catch (PDOException $e) {
    echo "<!DOCTYPE html>
<html lang='pt-BR'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Erro de Conexão</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f8d7da;
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        .error {
            background: white;
            padding: 30px;
            border-radius: 10px;
            border: 2px solid #f5c6cb;
            max-width: 600px;
        }
        h1 { color: #721c24; }
        code {
            background: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: monospace;
        }
    </style>
</head>
<body>
    <div class='error'>
        <h1>❌ Erro de Conexão com Banco de Dados</h1>
        <p><strong>Erro:</strong> " . htmlspecialchars($e->getMessage()) . "</p>
        <hr>
        <h3>Configurações Utilizadas:</h3>
        <p><strong>Host:</strong> <code>$DB_HOST</code></p>
        <p><strong>Porta:</strong> <code>$DB_PORT</code></p>
        <p><strong>Banco:</strong> <code>$DB_NAME</code></p>
        <p><strong>Usuário:</strong> <code>$DB_USER</code></p>
        <hr>
        <p>Verifique se as credenciais estão corretas no cPanel.</p>
    </div>
</body>
</html>";
}
?>
