<?php
// limpar_cache.php - Diagnóstico e Limpeza de Cache
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔍 Diagnóstico de Cache e Config.php</h1>";

// 1. Verificar qual arquivo está sendo carregado
echo "<h2>1. Localização do config.php</h2>";
$config_path = __DIR__ . '/config.php';
echo "<p><strong>Caminho esperado:</strong> $config_path</p>";
echo "<p><strong>Arquivo existe?</strong> " . (file_exists($config_path) ? '✅ SIM' : '❌ NÃO') . "</p>";

if (file_exists($config_path)) {
    echo "<p><strong>Última modificação:</strong> " . date('d/m/Y H:i:s', filemtime($config_path)) . "</p>";
    echo "<p><strong>Tamanho:</strong> " . filesize($config_path) . " bytes</p>";
}

// 2. Limpar cache do OPcache
echo "<h2>2. Limpeza de Cache</h2>";
if (function_exists('opcache_reset')) {
    opcache_reset();
    echo "<p>✅ OPcache limpo com sucesso!</p>";
} else {
    echo "<p>⚠️ OPcache não está ativo</p>";
}

// Limpar cache de scripts
if (function_exists('opcache_invalidate')) {
    opcache_invalidate($config_path, true);
    echo "<p>✅ Cache do config.php invalidado!</p>";
}

// 3. Ler o conteúdo do arquivo diretamente
echo "<h2>3. Conteúdo da Linha 11 (deve ter PHP_SESSION_NONE)</h2>";
if (file_exists($config_path)) {
    $linhas = file($config_path);

    echo "<pre>";
    echo "Linha 10: " . htmlspecialchars($linhas[9] ?? 'N/A') . "\n";
    echo "<strong style='background: yellow;'>Linha 11: " . htmlspecialchars($linhas[10] ?? 'N/A') . "</strong>\n";
    echo "Linha 12: " . htmlspecialchars($linhas[11] ?? 'N/A') . "\n";
    echo "</pre>";

    // Verificar se tem o erro
    $linha11 = $linhas[10] ?? '';
    if (strpos($linha11, 'PHP_SESSION_NONE') !== false) {
        echo "<p style='color: green; font-weight: bold;'>✅ CORRETO! Linha 11 tem PHP_SESSION_NONE</p>";
    } elseif (strpos($linha11, 'PHP_STATUS_NONE') !== false) {
        echo "<p style='color: red; font-weight: bold;'>❌ ERRADO! Linha 11 tem PHP_STATUS_NONE (erro de digitação)</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ Linha 11 não tem nem PHP_SESSION_NONE nem PHP_STATUS_NONE</p>";
    }
}

// 4. Verificar linha 21
echo "<h2>4. Conteúdo da Linha 21 (onde o erro aparece)</h2>";
if (file_exists($config_path)) {
    $linhas = file($config_path);

    echo "<pre>";
    echo "Linha 20: " . htmlspecialchars($linhas[19] ?? 'N/A') . "\n";
    echo "<strong style='background: yellow;'>Linha 21: " . htmlspecialchars($linhas[20] ?? 'N/A') . "</strong>\n";
    echo "Linha 22: " . htmlspecialchars($linhas[21] ?? 'N/A') . "\n";
    echo "</pre>";
}

// 5. Buscar TODAS as ocorrências de PHP_STATUS_NONE no arquivo
echo "<h2>5. Buscar PHP_STATUS_NONE no arquivo inteiro</h2>";
if (file_exists($config_path)) {
    $conteudo_completo = file_get_contents($config_path);
    $ocorrencias = substr_count($conteudo_completo, 'PHP_STATUS_NONE');

    if ($ocorrencias > 0) {
        echo "<p style='color: red; font-weight: bold;'>❌ ENCONTRADO! Há $ocorrencias ocorrência(s) de PHP_STATUS_NONE no arquivo</p>";

        // Mostrar as linhas
        $linhas = file($config_path);
        echo "<h3>Linhas com PHP_STATUS_NONE:</h3>";
        echo "<pre>";
        foreach ($linhas as $num => $linha) {
            if (strpos($linha, 'PHP_STATUS_NONE') !== false) {
                $num_linha = $num + 1;
                echo "<strong style='color: red;'>Linha $num_linha: " . htmlspecialchars($linha) . "</strong>\n";
            }
        }
        echo "</pre>";
    } else {
        echo "<p style='color: green; font-weight: bold;'>✅ PERFEITO! Nenhuma ocorrência de PHP_STATUS_NONE encontrada</p>";
    }
}

// 6. Informações do PHP
echo "<h2>6. Informações do PHP</h2>";
echo "<p><strong>Versão PHP:</strong> " . phpversion() . "</p>";
echo "<p><strong>OPcache ativo?</strong> " . (function_exists('opcache_get_status') && opcache_get_status() ? 'SIM' : 'NÃO') . "</p>";

// 7. Verificar se há múltiplos config.php
echo "<h2>7. Verificar múltiplos config.php</h2>";
$possíveis_locais = [
    __DIR__ . '/config.php',
    __DIR__ . '/../config.php',
    $_SERVER['DOCUMENT_ROOT'] . '/config.php',
    $_SERVER['DOCUMENT_ROOT'] . '/sis/config.php',
];

foreach ($possíveis_locais as $local) {
    if (file_exists($local)) {
        echo "<p>✅ Encontrado: <code>$local</code> (modificado em: " . date('d/m/Y H:i:s', filemtime($local)) . ")</p>";
    }
}

echo "<hr>";
echo "<h2>🎯 PRÓXIMO PASSO</h2>";
echo "<p><strong>Após visualizar este diagnóstico:</strong></p>";
echo "<ol>";
echo "<li>Anote se encontrou PHP_STATUS_NONE em alguma linha</li>";
echo "<li>Acesse novamente: <a href='install.php'>install.php</a></li>";
echo "<li>Se o erro persistir, me envie uma captura desta página inteira</li>";
echo "</ol>";

// 8. Criar um config.php de teste limpo
echo "<h2>8. Teste de Substituição</h2>";
echo "<p>Se o diagnóstico acima mostrar PHP_STATUS_NONE, o arquivo não foi substituído corretamente.</p>";
echo "<p><strong>Solução:</strong> Delete o config.php atual via cPanel e crie um novo manualmente.</p>";
?>
