<?php
/**
 * SCRIPT DE MIGRAÇÃO - Menu Horizontal → Menu Lateral WordPress
 * Atualiza todas as páginas do sistema para usar o novo sidebar
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Migração para Sidebar - WordPress Style</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; margin-bottom: 10px; font-size: 32px; }
        h2 { color: #764ba2; margin: 30px 0 15px; border-bottom: 2px solid #667eea; padding-bottom: 10px; }
        .success { background: #d4edda; color: #155724; padding: 15px; margin: 15px 0; border-radius: 8px; border-left: 4px solid #28a745; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; margin: 15px 0; border-radius: 8px; border-left: 4px solid #dc3545; }
        .warning { background: #fff3cd; color: #856404; padding: 15px; margin: 15px 0; border-radius: 8px; border-left: 4px solid #ffc107; }
        .info { background: #d1ecf1; color: #0c5460; padding: 15px; margin: 15px 0; border-radius: 8px; border-left: 4px solid #17a2b8; }
        .btn { background: #28a745; color: white; padding: 15px 30px; border: none; border-radius: 8px; font-size: 16px; cursor: pointer; text-decoration: none; display: inline-block; }
        .btn:hover { background: #218838; }
        .btn-secondary { background: #667eea; }
        .btn-secondary:hover { background: #5568d3; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto; font-size: 12px; }
        .file-list { display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px; margin: 20px 0; }
        .file-item { background: #f8f9fa; padding: 10px; border-radius: 5px; font-size: 13px; border-left: 3px solid #667eea; }
        .stats { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin: 20px 0; }
        .stat-card { background: linear-gradient(135deg, #667eea, #764ba2); color: white; padding: 20px; border-radius: 10px; text-align: center; }
        .stat-value { font-size: 32px; font-weight: bold; margin-bottom: 5px; }
        .stat-label { font-size: 14px; opacity: 0.9; }
    </style>
</head>
<body>
<div class="container">
    <h1><i class="fas fa-magic"></i> Migração para Sidebar WordPress</h1>
    <p style="color: #666; margin-bottom: 30px;">Transforme o menu horizontal em um menu lateral profissional estilo WordPress</p>

    <?php
    if (!isset($_POST['executar_migracao'])) {
        // PASSO 1: Analisar arquivos
        echo "<h2><i class='fas fa-search'></i> Análise do Sistema</h2>";

        $arquivos_php = glob(__DIR__ . '/*.php');
        $arquivos_dashboard = [];
        $arquivos_com_navbar = [];
        $total_arquivos = 0;

        echo "<div class='info'>";
        echo "<p><strong>Analisando arquivos...</strong></p>";
        echo "</div>";

        foreach ($arquivos_php as $arquivo) {
            $nome = basename($arquivo);

            // Pular arquivos especiais
            if (in_array($nome, ['login.php', 'logout.php', 'config.php', 'migrar_para_sidebar.php', 'sistema_theme.php'])) {
                continue;
            }

            $conteudo = file_get_contents($arquivo);

            // Verificar se tem include navbar ou é página de dashboard
            if (stripos($conteudo, 'assets/navbar.php') !== false ||
                stripos($conteudo, 'dashboard') !== false ||
                stripos($conteudo, 'admin_') !== false ||
                stripos($conteudo, 'produtor_') !== false) {

                $arquivos_dashboard[] = $nome;
                $total_arquivos++;

                if (stripos($conteudo, 'assets/navbar.php') !== false) {
                    $arquivos_com_navbar[] = $nome;
                }
            }
        }

        echo "<div class='stats'>";
        echo "<div class='stat-card'>";
        echo "<div class='stat-value'>" . $total_arquivos . "</div>";
        echo "<div class='stat-label'>Páginas do Dashboard</div>";
        echo "</div>";

        echo "<div class='stat-card'>";
        echo "<div class='stat-value'>" . count($arquivos_com_navbar) . "</div>";
        echo "<div class='stat-label'>Com Navbar Antigo</div>";
        echo "</div>";

        echo "<div class='stat-card'>";
        echo "<div class='stat-value'>" . ($total_arquivos - count($arquivos_com_navbar)) . "</div>";
        echo "<div class='stat-label'>Sem Navbar</div>";
        echo "</div>";
        echo "</div>";

        if ($total_arquivos > 0) {
            echo "<div class='warning'>";
            echo "<h3><i class='fas fa-exclamation-triangle'></i> Arquivos que serão atualizados:</h3>";
            echo "<div class='file-list'>";
            foreach ($arquivos_dashboard as $arquivo) {
                echo "<div class='file-item'><i class='fas fa-file-code'></i> $arquivo</div>";
            }
            echo "</div>";
            echo "</div>";

            echo "<h2><i class='fas fa-rocket'></i> O que será feito?</h2>";
            echo "<div class='info'>";
            echo "<ol style='padding-left: 30px; margin: 15px 0;'>";
            echo "<li><strong>Backup automático:</strong> Todos os arquivos serão copiados com extensão .backup</li>";
            echo "<li><strong>Remover navbar antigo:</strong> Remove includes de 'assets/navbar.php'</li>";
            echo "<li><strong>Adicionar sidebar novo:</strong> Adiciona include de 'assets/sidebar-navbar.php'</li>";
            echo "<li><strong>Incluir CSS dinâmico:</strong> Garante que sistema_theme.php seja incluído</li>";
            echo "<li><strong>Ajustar estrutura HTML:</strong> Adiciona classes necessárias para layout</li>";
            echo "</ol>";
            echo "</div>";

            echo "<div class='warning'>";
            echo "<h3><i class='fas fa-info-circle'></i> Importante:</h3>";
            echo "<ul style='padding-left: 30px; margin: 10px 0;'>";
            echo "<li>Esta migração é <strong>REVERSÍVEL</strong> - backups serão criados</li>";
            echo "<li>O sistema continuará funcionando normalmente</li>";
            echo "<li>As cores configuradas serão aplicadas em TODAS as páginas</li>";
            echo "<li>O menu lateral é <strong>responsivo</strong> e funciona no mobile</li>";
            echo "</ul>";
            echo "</div>";

            echo "<form method='POST' style='margin-top: 30px; text-align: center;'>";
            echo "<button type='submit' name='executar_migracao' class='btn' style='font-size: 18px; padding: 20px 40px;'>";
            echo "<i class='fas fa-magic'></i> EXECUTAR MIGRAÇÃO AGORA";
            echo "</button>";
            echo "<p style='margin-top: 15px; color: #666;'>Tempo estimado: 10-30 segundos</p>";
            echo "</form>";
        } else {
            echo "<div class='success'>";
            echo "<h3>✅ Nenhum arquivo para migrar!</h3>";
            echo "<p>Todas as páginas já estão atualizadas ou não há páginas de dashboard.</p>";
            echo "</div>";
        }

    } else {
        // PASSO 2: Executar migração
        echo "<h2><i class='fas fa-cog fa-spin'></i> Executando Migração...</h2>";

        $arquivos_php = glob(__DIR__ . '/*.php');
        $migrados = 0;
        $erros = 0;
        $logs = [];

        foreach ($arquivos_php as $arquivo) {
            $nome = basename($arquivo);

            // Pular arquivos especiais
            if (in_array($nome, ['login.php', 'logout.php', 'config.php', 'migrar_para_sidebar.php', 'sistema_theme.php'])) {
                continue;
            }

            $conteudo = file_get_contents($arquivo);

            // Verificar se é página de dashboard
            if (stripos($conteudo, 'dashboard') === false &&
                stripos($conteudo, 'admin_') === false &&
                stripos($conteudo, 'produtor_') === false &&
                stripos($conteudo, 'assets/navbar.php') === false) {
                continue;
            }

            try {
                // 1. Fazer backup
                $backup_file = $arquivo . '.backup_' . date('YmdHis');
                copy($arquivo, $backup_file);
                $logs[] = "✅ Backup criado: " . basename($backup_file);

                // 2. Processar conteúdo
                $novo_conteudo = $conteudo;

                // Remover includes do navbar antigo
                $novo_conteudo = preg_replace(
                    '/<\\?php\\s+include\\s+[\'"]assets\\/navbar\\.php[\'"];?\\s*\\?>/i',
                    '',
                    $novo_conteudo
                );

                // Adicionar include do sidebar no início do body (se ainda não existir)
                if (stripos($novo_conteudo, 'sidebar-navbar.php') === false) {
                    // Procurar tag <body> e adicionar após ela
                    $novo_conteudo = preg_replace(
                        '/(<body[^>]*>)/i',
                        '$1' . "\n<?php include 'assets/sidebar-navbar.php'; ?>\n<div class=\"main-content\"><div class=\"content-wrapper\">",
                        $novo_conteudo,
                        1
                    );

                    // Adicionar fechamento antes de </body>
                    $novo_conteudo = preg_replace(
                        '/(<\\/body>)/i',
                        "</div></div>\n$1",
                        $novo_conteudo,
                        1
                    );
                }

                // Adicionar include do sistema_theme.php no head (se ainda não existir)
                if (stripos($novo_conteudo, 'sistema_theme.php') === false) {
                    $novo_conteudo = preg_replace(
                        '/(<\\/head>)/i',
                        "<style><?php include 'sistema_theme.php'; ?></style>\n$1",
                        $novo_conteudo,
                        1
                    );
                }

                // 3. Salvar arquivo atualizado
                file_put_contents($arquivo, $novo_conteudo);
                $logs[] = "✅ Migrado: $nome";
                $migrados++;

            } catch (Exception $e) {
                $logs[] = "❌ Erro em $nome: " . $e->getMessage();
                $erros++;
            }
        }

        // Mostrar resultados
        echo "<div class='stats'>";
        echo "<div class='stat-card'>";
        echo "<div class='stat-value'>$migrados</div>";
        echo "<div class='stat-label'>Arquivos Migrados</div>";
        echo "</div>";

        echo "<div class='stat-card'>";
        echo "<div class='stat-value'>$erros</div>";
        echo "<div class='stat-label'>Erros</div>";
        echo "</div>";
        echo "</div>";

        echo "<h3>Log Detalhado:</h3>";
        echo "<pre>";
        foreach ($logs as $log) {
            echo htmlspecialchars($log) . "\n";
        }
        echo "</pre>";

        if ($erros === 0) {
            echo "<div class='success'>";
            echo "<h3><i class='fas fa-check-circle'></i> Migração Concluída com Sucesso!</h3>";
            echo "<p><strong>$migrados</strong> arquivos foram atualizados para usar o novo menu lateral.</p>";
            echo "<hr style='margin: 20px 0;'>";
            echo "<h4>✅ Próximos Passos:</h4>";
            echo "<ol style='padding-left: 30px; margin: 15px 0;'>";
            echo "<li>Acesse o <a href='dashboard.php' class='btn-secondary' style='padding: 8px 16px; margin: 0 5px;'>Dashboard</a> para ver o novo menu</li>";
            echo "<li>Acesse <a href='configuracoes.php' class='btn-secondary' style='padding: 8px 16px; margin: 0 5px;'>Configurações</a> para personalizar as cores</li>";
            echo "<li>As alterações serão aplicadas em <strong>TODO o sistema</strong></li>";
            echo "<li>Use o botão ☰ para expandir/recolher o menu</li>";
            echo "</ol>";
            echo "</div>";
        } else {
            echo "<div class='error'>";
            echo "<h3>⚠️ Migração Parcial</h3>";
            echo "<p>Houve alguns erros. Verifique o log acima.</p>";
            echo "</div>";
        }
    }
    ?>
</div>
</body>
</html>
