-- Migração: Adicionar tipo 'cartao_consumo' à tabela saques
-- Data: 2025-01-16
-- Descrição: Permite solicitação de cartão de consumo usando crédito de consumação

-- IMPORTANTE: Esta migração corrige o erro "Data truncated for column 'tipo'"
-- que ocorre ao tentar inserir 'cartao_consumo' em uma coluna ENUM restrita

-- Passo 1: Atualizar registros antigos de 'consumacao_pix' para 'cartao_consumo'
-- (caso existam registros do código antigo que foi removido)
UPDATE saques SET tipo = 'cartao_consumo' WHERE tipo = 'consumacao_pix';

-- Passo 2: Modificar a coluna tipo para suportar todos os valores necessários
-- Incluindo tipos antigos para compatibilidade com registros existentes
ALTER TABLE saques MODIFY COLUMN tipo ENUM('pix', 'credito', 'cartao_consumo', 'consumacao_pix') NOT NULL DEFAULT 'pix';

-- Passo 3: Verificar integridade dos dados
-- Contar registros por tipo para confirmar
SELECT tipo, COUNT(*) as quantidade FROM saques GROUP BY tipo;

-- NOTA: Se preferir VARCHAR para mais flexibilidade futura, use:
-- ALTER TABLE saques MODIFY COLUMN tipo VARCHAR(30) NOT NULL DEFAULT 'pix';
