-- Migração: Corrigir coluna 'status' na tabela saques
-- Data: 2025-01-16
-- Descrição: Adicionar todos os status necessários para o sistema de saques

-- IMPORTANTE: Esta migração corrige o erro "Data truncated for column 'status'"
-- que ocorre ao tentar atualizar status com valores não incluídos no ENUM

-- Passo 1: Atualizar registros com status antigos para os novos valores
-- Converter 'aprovado' para 'processando' (se existir)
UPDATE saques SET status = 'processando' WHERE status = 'aprovado';

-- Passo 2: Modificar a coluna status para incluir todos os valores necessários
ALTER TABLE saques MODIFY COLUMN status ENUM(
    'pendente',      -- Aguardando aprovação do admin
    'processando',   -- Aprovado pelo admin, aguardando pagamento
    'concluido',     -- Pago/Entregue ao promoter
    'cancelado',     -- Rejeitado/Cancelado
    'usado',         -- Crédito de consumação já utilizado (marcado ao pagar cartão)
    'aprovado'       -- Status antigo (mantido para compatibilidade)
) NOT NULL DEFAULT 'pendente';

-- Passo 3: Verificar integridade dos dados
-- Contar registros por status para confirmar
SELECT status, COUNT(*) as quantidade FROM saques GROUP BY status;

-- NOTA: Se preferir VARCHAR para mais flexibilidade futura, use:
-- ALTER TABLE saques MODIFY COLUMN status VARCHAR(20) NOT NULL DEFAULT 'pendente';
