-- ========================================
-- MIGRAÇÃO PARA WHITE LABEL V2.0
-- Sistema de Personalização Completa
-- ========================================

-- Tabela de Configurações Visuais (White Label)
CREATE TABLE IF NOT EXISTS `configuracoes_visual` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome_sistema` varchar(100) DEFAULT 'PromoTaal',
  `logo_path` varchar(255) DEFAULT NULL,
  `favicon_path` varchar(255) DEFAULT NULL,

  -- Cores do Sistema (CSS Variables)
  `cor_primaria` varchar(7) DEFAULT '#FFC107',
  `cor_secundaria` varchar(7) DEFAULT '#1a1a1a',
  `cor_fundo` varchar(7) DEFAULT '#000000',
  `cor_card` varchar(7) DEFAULT '#1a1a1a',
  `cor_texto` varchar(7) DEFAULT '#ffffff',
  `cor_texto_secundario` varchar(7) DEFAULT '#b0b0b0',
  `cor_borda` varchar(7) DEFAULT '#333333',
  `cor_sucesso` varchar(7) DEFAULT '#28a745',
  `cor_erro` varchar(7) DEFAULT '#dc3545',
  `cor_aviso` varchar(7) DEFAULT '#ffc107',
  `cor_info` varchar(7) DEFAULT '#17a2b8',
  `cor_hover` varchar(7) DEFAULT '#FFD54F',

  -- Tipo de Menu Escolhido
  `tipo_menu` enum('menu_lateral','menu_rodape','menu_banco') DEFAULT 'menu_lateral',

  -- Paleta Pré-definida (NULL = personalizada)
  `paleta_ativa` varchar(50) DEFAULT NULL,

  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Inserir configuração padrão
INSERT INTO `configuracoes_visual` (id, nome_sistema, paleta_ativa)
VALUES (1, 'PromoTaal', 'atual')
ON DUPLICATE KEY UPDATE id=id;

-- Tabela de Paletas de Cores Pré-definidas
CREATE TABLE IF NOT EXISTS `paletas_cores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(50) NOT NULL,
  `descricao` text,
  `tipo` enum('clara','escura') NOT NULL,
  `cor_primaria` varchar(7) NOT NULL,
  `cor_secundaria` varchar(7) NOT NULL,
  `cor_fundo` varchar(7) NOT NULL,
  `cor_card` varchar(7) NOT NULL,
  `cor_texto` varchar(7) NOT NULL,
  `cor_texto_secundario` varchar(7) NOT NULL,
  `cor_borda` varchar(7) NOT NULL,
  `cor_sucesso` varchar(7) NOT NULL,
  `cor_erro` varchar(7) NOT NULL,
  `cor_aviso` varchar(7) NOT NULL,
  `cor_info` varchar(7) NOT NULL,
  `cor_hover` varchar(7) NOT NULL,
  `preview_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nome` (`nome`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Inserir Paletas Pré-definidas
INSERT INTO `paletas_cores` (nome, descricao, tipo, cor_primaria, cor_secundaria, cor_fundo, cor_card, cor_texto, cor_texto_secundario, cor_borda, cor_sucesso, cor_erro, cor_aviso, cor_info, cor_hover) VALUES
-- Paleta Atual (Escura)
('atual', 'Paleta atual do sistema - Amarelo e Preto (Escura)', 'escura', '#FFC107', '#1a1a1a', '#000000', '#1a1a1a', '#ffffff', '#b0b0b0', '#333333', '#28a745', '#dc3545', '#ffc107', '#17a2b8', '#FFD54F'),

-- ESCURAS (4)
('nubank', 'Inspirada no Nubank - Roxo Vibrante (Escura)', 'escura', '#8A05BE', '#1a1a1a', '#0d0d0d', '#1e1e1e', '#ffffff', '#c0c0c0', '#3d3d3d', '#00d632', '#ff4444', '#ffaa00', '#00d2ff', '#9d1fd1'),

('next', 'Inspirada no Banco Next - Verde Neon (Escura)', 'escura', '#00d86a', '#1a1a1a', '#0a0a0a', '#1c1c1c', '#ffffff', '#b8b8b8', '#2d2d2d', '#00ff7f', '#ff3860', '#ffd700', '#00e5ff', '#00ff8f'),

('neon', 'Inspirada no Neon - Azul Elétrico (Escura)', 'escura', '#00cfff', '#1a1a1a', '#0c0c0c', '#1d1d1d', '#ffffff', '#bbbbbb', '#353535', '#00ff9f', '#ff4757', '#ffa502', '#00d2d3', '#33d9ff'),

('rico', 'Inspirada no Banco Rico - Laranja Premium (Escura)', 'escura', '#ff6b00', '#1a1a1a', '#0b0b0b', '#1f1f1f', '#ffffff', '#bebebe', '#383838', '#00c853', '#ff5252', '#ffb300', '#00acc1', '#ff8533'),

-- CLARAS (3)
('aurora', 'Aurora - Rosa e Dourado Suave (Clara)', 'clara', '#ff6b9d', '#f8f9fa', '#ffffff', '#f5f5f5', '#1a1a1a', '#5a5a5a', '#e0e0e0', '#28a745', '#dc3545', '#ff9800', '#2196f3', '#ff8fb8'),

('oceano', 'Oceano - Azul Celeste e Branco (Clara)', 'clara', '#0099ff', '#f0f4f8', '#fafbfc', '#f3f6f9', '#1a1a1a', '#606060', '#d0dae5', '#00c851', '#ff3547', '#ffbb33', '#33b5e5', '#33adff'),

('menta', 'Menta - Verde Água Refrescante (Clara)', 'clara', '#00bfa5', '#f1f8f6', '#ffffff', '#f4f9f8', '#1a1a1a', '#555555', '#d5e8e5', '#00e676', '#ff5252', '#ffc107', '#00bcd4', '#26ceb8');

-- Tabela de Artigos de Ajuda
CREATE TABLE IF NOT EXISTS `artigos_ajuda` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(200) NOT NULL,
  `conteudo` text NOT NULL,
  `ordem` int(11) DEFAULT 0,
  `visivel_para` enum('todos','promoter','produtor') DEFAULT 'todos',
  `publicado` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Inserir Artigos de Ajuda Iniciais
INSERT INTO `artigos_ajuda` (titulo, conteudo, ordem, visivel_para, publicado) VALUES
('Como Solicitar Saque em PIX', '<h3>💰 Como Solicitar Saque em PIX</h3>
<p>Siga os passos abaixo para solicitar um saque das suas comissões:</p>
<ol>
<li><strong>Acesse a página Financeiro</strong> no menu principal</li>
<li>Verifique seu <strong>Saldo Disponível para PIX</strong></li>
<li>No campo "Solicitar Saque", digite o valor desejado</li>
<li>Selecione a opção <strong>PIX</strong></li>
<li>Clique em <strong>Solicitar Saque</strong></li>
<li>Aguarde a aprovação do administrador</li>
</ol>
<p><strong>⏰ Prazo:</strong> Saques são processados em até 48 horas úteis.</p>
<p><strong>⚠️ Importante:</strong> Certifique-se de que sua chave PIX está cadastrada corretamente no seu perfil.</p>', 1, 'todos', 1),

('Como Solicitar Bônus de Consumação', '<h3>🎁 Como Solicitar Bônus de Consumação</h3>
<p>O bônus de consumação permite que você converta suas comissões em créditos para usar em eventos:</p>
<ol>
<li><strong>Acesse a página Financeiro</strong></li>
<li>Verifique seu <strong>Saldo Disponível para PIX</strong></li>
<li>No campo "Converter para Consumação", digite o valor</li>
<li>Clique em <strong>Converter para Crédito</strong></li>
<li>O crédito será adicionado automaticamente ao seu saldo de consumação</li>
</ol>
<p><strong>💡 Dica:</strong> Créditos de consumação podem ser usados para solicitar cartões de consumo nos eventos.</p>
<p><strong>⚠️ Atenção:</strong> Após converter para consumação, o valor NÃO pode ser convertido de volta para PIX.</p>', 2, 'todos', 1),

('Como Solicitar Cartão de Consumo', '<h3>🎫 Como Solicitar Cartão de Consumo</h3>
<p>Use seus créditos de consumação para obter cartões de consumo nos eventos:</p>
<ol>
<li><strong>Acesse a página Financeiro</strong></li>
<li>Verifique seu <strong>Crédito de Consumação Disponível</strong></li>
<li>No campo "Solicitar Cartão de Consumo", digite o valor desejado</li>
<li>Clique em <strong>Solicitar Cartão</strong></li>
<li>Aguarde a aprovação do administrador</li>
<li>Retire seu cartão na bilheteria do evento</li>
</ol>
<p><strong>📍 Local de Retirada:</strong> Bilheteria do evento com documento de identificação.</p>
<p><strong>⏰ Prazo:</strong> Os cartões são processados em até 24 horas.</p>', 3, 'todos', 1),

('Como Baixar Arquivos dos Eventos', '<h3>📥 Como Baixar Arquivos dos Eventos</h3>
<p>Baixe a lista de convidados e QR codes dos seus eventos:</p>
<ol>
<li><strong>Acesse "Minhas Listas"</strong> no menu</li>
<li>Localize o evento desejado</li>
<li>Clique no botão <strong>"Baixar Lista"</strong> para obter o PDF com QR codes</li>
<li>O arquivo será baixado automaticamente</li>
</ol>
<p><strong>📄 O que está incluído:</strong></p>
<ul>
<li>Lista completa de convidados</li>
<li>QR Codes individuais para cada convidado</li>
<li>Informações de contato (nome, WhatsApp)</li>
</ul>
<p><strong>💡 Dica:</strong> Você pode imprimir ou enviar os QR codes digitalmente para seus convidados.</p>', 4, 'todos', 1),

('Como Alterar Seus Dados Pessoais', '<h3>👤 Como Alterar Seus Dados Pessoais</h3>
<p>Mantenha suas informações sempre atualizadas:</p>
<ol>
<li><strong>Clique em "Meu Perfil"</strong> no menu superior</li>
<li>Na seção <strong>"Dados Pessoais"</strong>, você pode alterar:
   <ul>
   <li>Nome completo</li>
   <li>E-mail</li>
   <li>Telefone/WhatsApp</li>
   <li>Instagram</li>
   <li>Chave PIX</li>
   </ul>
</li>
<li>Na seção <strong>"Foto de Perfil"</strong>, clique em "Escolher arquivo"</li>
<li>Selecione uma imagem (máximo 5MB)</li>
<li>Clique em <strong>Salvar Alterações</strong></li>
</ol>
<p><strong>🔒 Alterar Senha:</strong></p>
<ol>
<li>Role até a seção "Alterar Senha"</li>
<li>Digite sua senha atual</li>
<li>Digite a nova senha (mínimo 6 caracteres)</li>
<li>Confirme a nova senha</li>
<li>Clique em <strong>Alterar Senha</strong></li>
</ol>
<p><strong>⚠️ Importante:</strong> Certifique-se de que sua chave PIX está correta para receber seus pagamentos.</p>', 5, 'todos', 1);

-- Tabela de Menu Personalizado por Usuário
CREATE TABLE IF NOT EXISTS `menu_personalizado` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `atalho_1` varchar(100) DEFAULT 'dashboard.php',
  `atalho_1_nome` varchar(50) DEFAULT 'Dashboard',
  `atalho_1_icone` varchar(50) DEFAULT 'fas fa-home',
  `atalho_2` varchar(100) DEFAULT 'financeiro.php',
  `atalho_2_nome` varchar(50) DEFAULT 'Financeiro',
  `atalho_2_icone` varchar(50) DEFAULT 'fas fa-dollar-sign',
  `atalho_3` varchar(100) DEFAULT 'minhas_listas.php',
  `atalho_3_nome` varchar(50) DEFAULT 'Minhas Listas',
  `atalho_3_icone` varchar(50) DEFAULT 'fas fa-list',
  `atalho_4` varchar(100) DEFAULT 'meu_perfil.php',
  `atalho_4_nome` varchar(50) DEFAULT 'Perfil',
  `atalho_4_icone` varchar(50) DEFAULT 'fas fa-user',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  CONSTRAINT `fk_menu_user` FOREIGN KEY (`user_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de Rodapé do Sistema (Informações de Desenvolvedor)
CREATE TABLE IF NOT EXISTS `rodape_sistema` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `texto_desenvolvido` varchar(200) DEFAULT 'Desenvolvido por Luminaink',
  `link_desenvolvedor` varchar(255) DEFAULT 'https://luminaink.com.br',
  `texto_licenciado` varchar(200) DEFAULT 'Todos os direitos reservados',
  `ano` int(4) DEFAULT 2025,
  `mostrar_versao` tinyint(1) DEFAULT 1,
  `versao_sistema` varchar(20) DEFAULT 'v2.0',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Inserir configuração padrão de rodapé
INSERT INTO `rodape_sistema` (id, texto_desenvolvido, link_desenvolvedor, texto_licenciado, versao_sistema)
VALUES (1, 'Desenvolvido por Luminaink', 'https://luminaink.com.br', 'Todos os direitos reservados', 'v2.0')
ON DUPLICATE KEY UPDATE id=id;

-- Remover coluna de banner se existir
ALTER TABLE `configuracoes` DROP COLUMN IF EXISTS `banner_promocional`;
