<?php
// minhas_listas.php - Minhas Listas de Convidados
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

require_once 'config.php';
verificarLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$sucesso = '';
$erro = '';

// Buscar dados do usuário para navbar
$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

// Editar convidado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['editar_convidado'])) {
    $convidado_id = intval($_POST['convidado_id']);
    $nome = filter_input(INPUT_POST, 'nome', FILTER_SANITIZE_STRING);
    $whatsapp = filter_input(INPUT_POST, 'whatsapp', FILTER_SANITIZE_STRING);
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $data_nascimento = $_POST['data_nascimento'];

    $stmt = $pdo->prepare("UPDATE convidados SET nome = ?, whatsapp = ?, email = ?, data_nascimento = ? WHERE id = ? AND promoter_id = ?");
    if ($stmt->execute([$nome, $whatsapp, $email, $data_nascimento, $convidado_id, $user_id])) {
        $sucesso = 'Convidado atualizado com sucesso!';
    } else {
        $erro = 'Erro ao atualizar convidado.';
    }
}

// Deletar convidado
if (isset($_GET['deletar'])) {
    $convidado_id = intval($_GET['deletar']);
    $stmt = $pdo->prepare("DELETE FROM convidados WHERE id = ? AND promoter_id = ?");
    if ($stmt->execute([$convidado_id, $user_id])) {
        $sucesso = 'Convidado removido!';
    }
}

// Buscar todos os eventos do promoter
$stmt = $pdo->prepare("
    SELECT e.*, pe.link_exclusivo,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id) as total_convidados,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id AND c.checkin = 1) as total_checkins,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id AND c.checkin = 0) as total_pendentes
    FROM eventos e
    INNER JOIN produtor_eventos pe ON e.id = pe.evento_id
    WHERE pe.user_id = ?
    ORDER BY e.data DESC
");
$stmt->execute([$user_id, $user_id, $user_id, $user_id]);
$meus_eventos = $stmt->fetchAll();

// Se um evento foi selecionado
$evento_selecionado = null;
$convidados = [];
$convidados_checkin = [];
$convidados_pendentes = [];

if (isset($_GET['evento_id'])) {
    $evento_id = intval($_GET['evento_id']);

    $stmt = $pdo->prepare("
        SELECT e.*, pe.link_exclusivo
        FROM eventos e
        INNER JOIN produtor_eventos pe ON e.id = pe.evento_id
        WHERE e.id = ? AND pe.user_id = ?
    ");
    $stmt->execute([$evento_id, $user_id]);
    $evento_selecionado = $stmt->fetch();

    if ($evento_selecionado) {
        $stmt = $pdo->prepare("
            SELECT * FROM convidados
            WHERE promoter_id = ? AND evento_id = ?
            ORDER BY created_at DESC
        ");
        $stmt->execute([$user_id, $evento_id]);
        $convidados = $stmt->fetchAll();

        foreach ($convidados as $conv) {
            if ($conv['checkin']) {
                $convidados_checkin[] = $conv;
            } else {
                $convidados_pendentes[] = $conv;
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Minhas Listas - Sistema Promoters</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">

    <style>
        .eventos-selector { display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 20px; margin-bottom: 40px; }
        .evento-selector-card { background: var(--bg-card); border: 2px solid var(--border-color); border-radius: 15px; padding: 25px; text-decoration: none; color: var(--text-primary); transition: all 0.3s; display: block; }
        .evento-selector-card:hover, .evento-selector-card.active { border-color: var(--border-gold); transform: translateY(-5px); box-shadow: 0 10px 30px rgba(255,215,0,0.3); background: var(--bg-card-hover); }
        .evento-selector-nome { font-size: 18px; font-weight: 700; color: var(--color-gold); margin-bottom: 15px; }
        .evento-selector-stats { display: flex; justify-content: space-between; font-size: 14px; color: var(--text-secondary); }
        .tabs { display: flex; gap: 15px; margin-bottom: 25px; border-bottom: 2px solid var(--border-color); }
        .tab { padding: 14px 25px; background: none; border: none; color: var(--text-primary); font-size: 14px; font-weight: 600; cursor: pointer; border-bottom: 3px solid transparent; transition: all 0.3s; }
        .tab:hover { color: var(--color-gold); }
        .tab.active { color: var(--color-gold); border-bottom-color: var(--color-gold); }
        .tab-content { display: none; }
        .tab-content.active { display: block; }
        .stats-mini { display: flex; gap: 30px; }
        .stat-mini { text-align: center; }
        .stat-mini-value { font-size: 32px; font-weight: 700; color: var(--color-gold); }
        .stat-mini-label { font-size: 11px; color: var(--text-secondary); text-transform: uppercase; margin-top: 5px; }
        .modal { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.85); z-index: 2000; overflow-y: auto; backdrop-filter: blur(5px); }
        .modal.active { display: flex; align-items: center; justify-content: center; padding: 20px; }
        .modal-content { background: var(--bg-card); border-radius: 20px; padding: 35px; max-width: 600px; width: 100%; border: 2px solid var(--border-gold); }
        .modal-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 25px; padding-bottom: 20px; border-bottom: 2px solid var(--border-color); }
        .modal-title { font-size: 26px; font-weight: 700; color: var(--color-gold); }
        .close-modal { background: none; border: none; font-size: 32px; cursor: pointer; color: var(--text-secondary); transition: all 0.3s; }
        .close-modal:hover { color: var(--color-gold); }

        @media (max-width: 768px) {
            .eventos-selector { grid-template-columns: 1fr; }
            .card-header { flex-direction: column; align-items: flex-start; }
            .stats-mini { width: 100%; justify-content: space-around; }
        }
    </style>
</head>
<body>

    <?php include 'assets/sidebar-navbar.php'; ?>

    <div class="main-content">
        <div class="content-wrapper">
            <div class="container">
        <?php if ($sucesso): ?>
            <div class="alert alert-success"><i class="fas fa-check-circle"></i> <?= htmlspecialchars($sucesso) ?></div>
        <?php endif; ?>

        <?php if ($erro): ?>
            <div class="alert alert-danger"><i class="fas fa-exclamation-circle"></i> <?= htmlspecialchars($erro) ?></div>
        <?php endif; ?>

        <div class="welcome-section">
            <h1 class="welcome-title">
                <i class="fas fa-list-ul"></i>
                Minhas Listas de Convidados
            </h1>
            <p class="welcome-subtitle">
                Gerencie seus convidados e acompanhe check-ins por evento
            </p>
        </div>

        <?php if (count($meus_eventos) > 0): ?>
            <h2 class="section-title">
                <i class="fas fa-calendar-alt"></i>
                Selecione um Evento
            </h2>

            <div class="eventos-selector">
                <?php foreach ($meus_eventos as $evt): ?>
                    <a href="?evento_id=<?= $evt['id'] ?>" class="evento-selector-card <?= (isset($_GET['evento_id']) && $_GET['evento_id'] == $evt['id']) ? 'active' : '' ?>">
                        <div class="evento-selector-nome"><?= htmlspecialchars($evt['nome']) ?></div>
                        <div class="evento-selector-stats">
                            <span><i class="fas fa-users"></i> <?= $evt['total_convidados'] ?></span>
                            <span><i class="fas fa-check-circle"></i> <?= $evt['total_checkins'] ?></span>
                            <span><i class="fas fa-clock"></i> <?= $evt['total_pendentes'] ?></span>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <?php if ($evento_selecionado): ?>
            <div class="card">
                <div class="card-header">
                    <div>
                        <div class="card-title"><?= htmlspecialchars($evento_selecionado['nome']) ?></div>
                        <div style="font-size: 14px; color: var(--text-secondary); margin-top: 8px;">
                            <i class="fas fa-calendar-alt"></i> <?= formatarData($evento_selecionado['data']) ?> às <?= date('H:i', strtotime($evento_selecionado['hora'])) ?>
                        </div>
                    </div>
                    <div class="stats-mini">
                        <div class="stat-mini">
                            <div class="stat-mini-value"><?= count($convidados) ?></div>
                            <div class="stat-mini-label">Total</div>
                        </div>
                        <div class="stat-mini">
                            <div class="stat-mini-value"><?= count($convidados_checkin) ?></div>
                            <div class="stat-mini-label">Presentes</div>
                        </div>
                        <div class="stat-mini">
                            <div class="stat-mini-value"><?= count($convidados_pendentes) ?></div>
                            <div class="stat-mini-label">Pendentes</div>
                        </div>
                    </div>
                </div>

                <div class="tabs">
                    <button class="tab active" onclick="switchTab('todos')">
                        <i class="fas fa-list"></i> Todos (<?= count($convidados) ?>)
                    </button>
                    <button class="tab" onclick="switchTab('checkin')">
                        <i class="fas fa-check-circle"></i> Confirmados (<?= count($convidados_checkin) ?>)
                    </button>
                    <button class="tab" onclick="switchTab('pendentes')">
                        <i class="fas fa-clock"></i> Não Compareceram (<?= count($convidados_pendentes) ?>)
                    </button>
                </div>

                <div id="tab-todos" class="tab-content active">
                    <?php if (count($convidados) > 0): ?>
                        <table>
                            <thead>
                                <tr>
                                    <th><i class="fas fa-user"></i> Nome</th>
                                    <th><i class="fas fa-phone"></i> WhatsApp</th>
                                    <th><i class="fas fa-envelope"></i> Email</th>
                                    <th><i class="fas fa-birthday-cake"></i> Nascimento</th>
                                    <th><i class="fas fa-info-circle"></i> Status</th>
                                    <th><i class="fas fa-calendar-plus"></i> Cadastro</th>
                                    <th><i class="fas fa-cog"></i> Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($convidados as $conv): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($conv['nome']) ?></td>
                                        <td><?= htmlspecialchars($conv['whatsapp']) ?></td>
                                        <td><?= htmlspecialchars($conv['email']) ?></td>
                                        <td><?= $conv['data_nascimento'] ? formatarData($conv['data_nascimento']) : '-' ?></td>
                                        <td>
                                            <?php if ($conv['checkin']): ?>
                                                <span class="badge badge-success"><i class="fas fa-check"></i> Presente</span>
                                            <?php else: ?>
                                                <span class="badge badge-warning"><i class="fas fa-clock"></i> Pendente</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= formatarData($conv['created_at']) ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-primary" onclick='editarConvidado(<?= json_encode($conv) ?>)'>
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <a href="?evento_id=<?= $evento_selecionado['id'] ?>&deletar=<?= $conv['id'] ?>"
                                               class="btn btn-sm btn-danger"
                                               onclick="return confirm('Deletar este convidado?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="empty-state">
                            <i class="fas fa-inbox"></i>
                            <h3>Nenhum convidado ainda</h3>
                            <p>Compartilhe seu link para começar!</p>
                        </div>
                    <?php endif; ?>
                </div>

                <div id="tab-checkin" class="tab-content">
                    <?php if (count($convidados_checkin) > 0): ?>
                        <table>
                            <thead>
                                <tr>
                                    <th><i class="fas fa-user"></i> Nome</th>
                                    <th><i class="fas fa-phone"></i> WhatsApp</th>
                                    <th><i class="fas fa-envelope"></i> Email</th>
                                    <th><i class="fas fa-check-circle"></i> Check-in</th>
                                    <th><i class="fas fa-cog"></i> Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($convidados_checkin as $conv): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($conv['nome']) ?></td>
                                        <td><?= htmlspecialchars($conv['whatsapp']) ?></td>
                                        <td><?= htmlspecialchars($conv['email']) ?></td>
                                        <td><?= formatarDataHora($conv['checkin_data']) ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-primary" onclick='editarConvidado(<?= json_encode($conv) ?>)'>
                                                <i class="fas fa-edit"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="empty-state">
                            <i class="fas fa-hourglass-half"></i>
                            <h3>Nenhum check-in ainda</h3>
                        </div>
                    <?php endif; ?>
                </div>

                <div id="tab-pendentes" class="tab-content">
                    <?php if (count($convidados_pendentes) > 0): ?>
                        <table>
                            <thead>
                                <tr>
                                    <th><i class="fas fa-user"></i> Nome</th>
                                    <th><i class="fas fa-phone"></i> WhatsApp</th>
                                    <th><i class="fas fa-envelope"></i> Email</th>
                                    <th><i class="fas fa-calendar-plus"></i> Cadastro</th>
                                    <th><i class="fas fa-cog"></i> Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($convidados_pendentes as $conv): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($conv['nome']) ?></td>
                                        <td>
                                            <a href="https://wa.me/<?= preg_replace('/[^0-9]/', '', $conv['whatsapp']) ?>"
                                               target="_blank"
                                               style="color:var(--color-gold)">
                                                <?= htmlspecialchars($conv['whatsapp']) ?> <i class="fab fa-whatsapp"></i>
                                            </a>
                                        </td>
                                        <td><?= htmlspecialchars($conv['email']) ?></td>
                                        <td><?= formatarData($conv['created_at']) ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-primary" onclick='editarConvidado(<?= json_encode($conv) ?>)'>
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <a href="?evento_id=<?= $evento_selecionado['id'] ?>&deletar=<?= $conv['id'] ?>"
                                               class="btn btn-sm btn-danger"
                                               onclick="return confirm('Deletar este convidado?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="empty-state">
                            <i class="fas fa-check-double"></i>
                            <h3>Todos fizeram check-in!</h3>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php elseif (count($meus_eventos) === 0): ?>
            <div class="empty-state">
                <i class="fas fa-calendar-times"></i>
                <h3>Você ainda não participa de nenhum evento</h3>
                <p><a href="eventos.php" style="color:var(--color-gold)">Clique aqui para ver eventos disponíveis</a></p>
            </div>
        <?php endif; ?>
            </div><!-- .container -->
        </div><!-- .content-wrapper -->
    </div><!-- .main-content -->

    <div id="modalEditar" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title"><i class="fas fa-user-edit"></i> Editar Convidado</div>
                <button class="close-modal" onclick="closeModal()"><i class="fas fa-times"></i></button>
            </div>
            <form method="POST">
                <input type="hidden" name="convidado_id" id="edit_id">
                <div class="form-group">
                    <label><i class="fas fa-user"></i> Nome Completo</label>
                    <input type="text" name="nome" id="edit_nome" required>
                </div>
                <div class="form-group">
                    <label><i class="fas fa-phone"></i> WhatsApp</label>
                    <input type="text" name="whatsapp" id="edit_whatsapp" required>
                </div>
                <div class="form-group">
                    <label><i class="fas fa-envelope"></i> Email</label>
                    <input type="email" name="email" id="edit_email">
                </div>
                <div class="form-group">
                    <label><i class="fas fa-birthday-cake"></i> Data de Nascimento</label>
                    <input type="date" name="data_nascimento" id="edit_data_nascimento">
                </div>
                <button type="submit" name="editar_convidado" class="btn btn-primary" style="width:100%;padding:15px;justify-content:center">
                    <i class="fas fa-save"></i> Salvar Alterações
                </button>
            </form>
        </div>
    </div>

    <script>
        function switchTab(tabName) {
            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
            event.target.closest('.tab').classList.add('active');
            document.getElementById('tab-' + tabName).classList.add('active');
        }
        function editarConvidado(c) {
            document.getElementById('edit_id').value = c.id;
            document.getElementById('edit_nome').value = c.nome;
            document.getElementById('edit_whatsapp').value = c.whatsapp;
            document.getElementById('edit_email').value = c.email || '';
            document.getElementById('edit_data_nascimento').value = c.data_nascimento || '';
            document.getElementById('modalEditar').classList.add('active');
        }
        function closeModal() {
            document.getElementById('modalEditar').classList.remove('active');
        }
        window.onclick = function(e) {
            if (e.target.classList.contains('modal')) closeModal();
        }
    </script>
</body>
</html>
