<?php
// ranking.php - Ranking de Promoters (Padronizado)
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

require_once 'config.php';
verificarLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];

// Buscar dados do usuário
$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

// Buscar ranking geral
$stmt = $pdo->query("
    SELECT u.id, u.nome, u.pontuacao, u.instagram,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = u.id) as total_convidados,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = u.id AND c.checkin = 1) as total_checkins,
    (SELECT COUNT(DISTINCT evento_id) FROM produtor_eventos pe WHERE pe.user_id = u.id) as total_eventos,
    CASE
        WHEN (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = u.id) > 0
        THEN ROUND(((SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = u.id AND c.checkin = 1) / (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = u.id) * 100), 1)
        ELSE 0
    END as taxa_conversao
    FROM usuarios u
    WHERE u.role = 'user' AND u.status = 'aprovado'
    ORDER BY u.pontuacao DESC, total_checkins DESC
    LIMIT 50
");
$ranking = $stmt->fetchAll();

// Encontrar posição do usuário atual
$posicao_usuario = 0;
$dados_usuario = null;
foreach ($ranking as $index => $promoter) {
    if ($promoter['id'] == $user_id) {
        $posicao_usuario = $index + 1;
        $dados_usuario = $promoter;
        break;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">

    <title>Ranking - Sistema Promoters</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">

    <style>
        /* Minha Posição */
        .minha-posicao {
            background: var(--bg-card);
            border: 2px solid var(--border-gold);
            border-radius: 20px;
            padding: 40px;
            margin-bottom: 30px;
            text-align: center;
            box-shadow: 0 10px 40px rgba(255, 215, 0, 0.2);
        }

        .minha-posicao-header {
            font-size: 16px;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 15px;
        }

        .minha-posicao-numero {
            font-size: 72px;
            font-weight: 700;
            color: var(--color-gold);
            margin-bottom: 10px;
            text-shadow: 0 0 30px rgba(255, 215, 0, 0.5);
        }

        .minha-posicao-nome {
            font-size: 24px;
            font-weight: 600;
            margin-bottom: 30px;
        }

        .minha-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 25px;
            margin-top: 30px;
            padding-top: 30px;
            border-top: 2px solid var(--border-color);
        }

        .minha-stat {
            text-align: center;
        }

        .minha-stat-value {
            font-size: 32px;
            font-weight: 700;
            color: var(--color-gold);
            margin-bottom: 5px;
        }

        .minha-stat-label {
            font-size: 13px;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        /* Pódio */
        .podio {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 20px;
            margin-bottom: 40px;
            align-items: end;
        }

        .podio-card {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 20px;
            padding: 30px 25px;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
        }

        .podio-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 40px rgba(255, 215, 0, 0.3);
        }

        .podio-card.primeiro {
            order: 2;
            transform: scale(1.15);
            background: linear-gradient(135deg, #FFD700, #FFA500);
            color: #000;
            border-color: #FFD700;
            box-shadow: 0 15px 50px rgba(255, 215, 0, 0.4);
        }

        .podio-card.primeiro:hover {
            transform: scale(1.18) translateY(-8px);
        }

        .podio-card.segundo {
            order: 1;
        }

        .podio-card.terceiro {
            order: 3;
        }

        .podio-medal {
            font-size: 56px;
            margin-bottom: 15px;
        }

        .podio-nome {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 12px;
        }

        .podio-pontos {
            font-size: 36px;
            font-weight: 700;
            margin-bottom: 20px;
        }

        .podio-card.primeiro .podio-pontos {
            font-size: 42px;
        }

        .podio-stats {
            display: flex;
            justify-content: space-around;
            padding-top: 20px;
            border-top: 1px solid var(--border-color);
        }

        .podio-card.primeiro .podio-stats {
            border-top-color: rgba(0,0,0,0.2);
        }

        .podio-stat {
            text-align: center;
        }

        .podio-stat-value {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 3px;
        }

        .podio-stat-label {
            font-size: 11px;
            opacity: 0.7;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* Lista de Ranking */
        .ranking-list {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 10px 40px rgba(0,0,0,0.3);
        }

        .ranking-item {
            display: grid;
            grid-template-columns: 80px 1fr 110px 110px 110px 110px;
            align-items: center;
            padding: 25px;
            border-bottom: 1px solid var(--border-color);
            transition: all 0.3s ease;
        }

        .ranking-item:hover {
            background: var(--bg-card-hover);
        }

        .ranking-item:last-child {
            border-bottom: none;
        }

        .ranking-item.destaque {
            background: rgba(255, 215, 0, 0.1);
            border-left: 5px solid var(--color-gold);
            box-shadow: inset 0 0 30px rgba(255, 215, 0, 0.1);
        }

        .ranking-posicao {
            font-size: 28px;
            font-weight: 700;
            color: var(--color-gold);
            text-align: center;
        }

        .ranking-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .ranking-avatar {
            width: 55px;
            height: 55px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--color-gold), var(--color-gold-dark));
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 26px;
            font-weight: 700;
            color: #000;
            box-shadow: 0 5px 15px rgba(255, 215, 0, 0.3);
        }

        .ranking-nome {
            font-size: 17px;
            font-weight: 600;
            margin-bottom: 4px;
        }

        .ranking-instagram {
            font-size: 13px;
            color: var(--text-secondary);
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .ranking-stat {
            text-align: center;
        }

        .ranking-stat-value {
            font-size: 20px;
            font-weight: 700;
            color: var(--color-gold);
            margin-bottom: 3px;
        }

        .ranking-stat-label {
            font-size: 11px;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        @media (max-width: 768px) {
            .podio {
                grid-template-columns: 1fr;
            }

            .podio-card.primeiro {
                order: 1;
                transform: scale(1);
            }

            .podio-card.segundo {
                order: 2;
            }

            .podio-card.terceiro {
                order: 3;
            }

            .ranking-item {
                grid-template-columns: 60px 1fr;
                gap: 15px;
            }

            .ranking-stat {
                display: none;
            }

            .minha-stats {
                grid-template-columns: repeat(2, 1fr);
            }
        }
    </style>
</head>
<body>

    <?php include 'assets/sidebar-navbar.php'; ?>

    <div class="main-content">
        <div class="content-wrapper">
            <div class="container">

        <!-- Cabeçalho -->
        <div class="welcome-section">
            <h1 class="welcome-title">
                <i class="fas fa-trophy"></i>
                Ranking de Promoters
            </h1>
            <p class="welcome-subtitle">
                Os melhores promoters do sistema baseado em pontuação e performance
            </p>
        </div>

        <!-- Minha Posição -->
        <?php if ($dados_usuario): ?>
        <div class="minha-posicao">
            <div class="minha-posicao-header">Sua Posição no Ranking</div>
            <div class="minha-posicao-numero">#<?= $posicao_usuario ?></div>
            <div class="minha-posicao-nome"><?= htmlspecialchars($dados_usuario['nome']) ?></div>

            <div class="minha-stats">
                <div class="minha-stat">
                    <div class="minha-stat-value"><i class="fas fa-star"></i> <?= $dados_usuario['pontuacao'] ?></div>
                    <div class="minha-stat-label">Pontos</div>
                </div>
                <div class="minha-stat">
                    <div class="minha-stat-value"><?= $dados_usuario['total_convidados'] ?></div>
                    <div class="minha-stat-label">Convidados</div>
                </div>
                <div class="minha-stat">
                    <div class="minha-stat-value"><?= $dados_usuario['total_checkins'] ?></div>
                    <div class="minha-stat-label">Check-ins</div>
                </div>
                <div class="minha-stat">
                    <div class="minha-stat-value"><?= $dados_usuario['taxa_conversao'] ?>%</div>
                    <div class="minha-stat-label">Taxa</div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Pódio (Top 3) -->
        <?php if (count($ranking) >= 3): ?>
        <div class="podio">
            <!-- 2º Lugar -->
            <div class="podio-card segundo">
                <div class="podio-medal"><i class="fas fa-medal" style="color: #C0C0C0;"></i></div>
                <div class="podio-nome"><?= htmlspecialchars($ranking[1]['nome']) ?></div>
                <div class="podio-pontos" style="color: var(--color-gold);">
                    <?= $ranking[1]['pontuacao'] ?> pts
                </div>
                <div class="podio-stats">
                    <div class="podio-stat">
                        <div class="podio-stat-value"><?= $ranking[1]['total_convidados'] ?></div>
                        <div class="podio-stat-label">Convidados</div>
                    </div>
                    <div class="podio-stat">
                        <div class="podio-stat-value"><?= $ranking[1]['total_checkins'] ?></div>
                        <div class="podio-stat-label">Check-ins</div>
                    </div>
                </div>
            </div>

            <!-- 1º Lugar -->
            <div class="podio-card primeiro">
                <div class="podio-medal"><i class="fas fa-crown" style="color: #000;"></i></div>
                <div class="podio-nome"><?= htmlspecialchars($ranking[0]['nome']) ?></div>
                <div class="podio-pontos">
                    <?= $ranking[0]['pontuacao'] ?> pts
                </div>
                <div class="podio-stats">
                    <div class="podio-stat">
                        <div class="podio-stat-value"><?= $ranking[0]['total_convidados'] ?></div>
                        <div class="podio-stat-label">Convidados</div>
                    </div>
                    <div class="podio-stat">
                        <div class="podio-stat-value"><?= $ranking[0]['total_checkins'] ?></div>
                        <div class="podio-stat-label">Check-ins</div>
                    </div>
                </div>
            </div>

            <!-- 3º Lugar -->
            <div class="podio-card terceiro">
                <div class="podio-medal"><i class="fas fa-medal" style="color: #CD7F32;"></i></div>
                <div class="podio-nome"><?= htmlspecialchars($ranking[2]['nome']) ?></div>
                <div class="podio-pontos" style="color: var(--color-gold);">
                    <?= $ranking[2]['pontuacao'] ?> pts
                </div>
                <div class="podio-stats">
                    <div class="podio-stat">
                        <div class="podio-stat-value"><?= $ranking[2]['total_convidados'] ?></div>
                        <div class="podio-stat-label">Convidados</div>
                    </div>
                    <div class="podio-stat">
                        <div class="podio-stat-value"><?= $ranking[2]['total_checkins'] ?></div>
                        <div class="podio-stat-label">Check-ins</div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Lista Completa -->
        <h2 class="section-title">
            <i class="fas fa-list-ol"></i>
            Classificação Completa
        </h2>

        <div class="ranking-list">
            <?php foreach ($ranking as $index => $promoter): ?>
                <div class="ranking-item <?= $promoter['id'] == $user_id ? 'destaque' : '' ?>">
                    <div class="ranking-posicao">#<?= $index + 1 ?></div>

                    <div class="ranking-info">
                        <div class="ranking-avatar">
                            <?= mb_substr($promoter['nome'], 0, 1) ?>
                        </div>
                        <div>
                            <div class="ranking-nome"><?= htmlspecialchars($promoter['nome']) ?></div>
                            <?php if ($promoter['instagram']): ?>
                                <div class="ranking-instagram">
                                    <i class="fab fa-instagram"></i>
                                    <?= htmlspecialchars($promoter['instagram']) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="ranking-stat">
                        <div class="ranking-stat-value"><?= $promoter['pontuacao'] ?></div>
                        <div class="ranking-stat-label">Pontos</div>
                    </div>

                    <div class="ranking-stat">
                        <div class="ranking-stat-value"><?= $promoter['total_convidados'] ?></div>
                        <div class="ranking-stat-label">Convidados</div>
                    </div>

                    <div class="ranking-stat">
                        <div class="ranking-stat-value"><?= $promoter['total_checkins'] ?></div>
                        <div class="ranking-stat-label">Check-ins</div>
                    </div>

                    <div class="ranking-stat">
                        <div class="ranking-stat-value"><?= $promoter['taxa_conversao'] ?>%</div>
                        <div class="ranking-stat-label">Taxa</div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

            </div><!-- .container -->
        </div><!-- .content-wrapper -->
    </div><!-- .main-content -->

</body>
</html>
