<?php
// redefinir_senha_admin.php - Redefinir senha do administrador
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Conectar diretamente
$DB_HOST = 'localhost';
$DB_PORT = '3306';
$DB_NAME = 'invitmecom_promosis';
$DB_USER = 'invitmecom_promosis';
$DB_PASS = 'rH]&iG%{ysipNDnB';

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Redefinir Senha do Administrador</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; margin-bottom: 20px; }
        h2 { color: #764ba2; margin: 25px 0 15px 0; border-bottom: 2px solid #667eea; padding-bottom: 10px; }
        .success { background: #d4edda; color: #155724; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #28a745; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #dc3545; }
        .info { background: #d1ecf1; color: #0c5460; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #17a2b8; }
        input { width: 100%; padding: 12px; margin: 8px 0; border: 1px solid #ddd; border-radius: 5px; font-size: 14px; }
        label { display: block; margin-top: 15px; font-weight: bold; color: #333; }
        .btn { background: #28a745; color: white; padding: 15px 30px; border: none; border-radius: 8px; font-size: 16px; cursor: pointer; width: 100%; margin-top: 20px; }
        .btn:hover { background: #218838; }
        .btn-link { background: #667eea; display: inline-block; text-decoration: none; margin-top: 10px; }
        .btn-link:hover { background: #5568d3; }
    </style>
</head>
<body>
<div class="container">
    <h1>🔐 Redefinir Senha do Administrador</h1>

<?php
try {
    $pdo = new PDO(
        "mysql:host=$DB_HOST;port=$DB_PORT;dbname=$DB_NAME;charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );

    echo "<div class='success'>";
    echo "<p>✅ Conectado ao banco: <strong>$DB_NAME</strong></p>";
    echo "</div>";

    // Processar redefinição de senha
    if (isset($_POST['redefinir'])) {
        $email = trim($_POST['email']);
        $nova_senha = trim($_POST['nova_senha']);
        $confirmar_senha = trim($_POST['confirmar_senha']);

        // Validações
        if (empty($email) || empty($nova_senha) || empty($confirmar_senha)) {
            echo "<div class='error'>";
            echo "<h3>❌ Erro</h3>";
            echo "<p>Todos os campos são obrigatórios.</p>";
            echo "</div>";
        } elseif ($nova_senha !== $confirmar_senha) {
            echo "<div class='error'>";
            echo "<h3>❌ Erro</h3>";
            echo "<p>As senhas não coincidem.</p>";
            echo "</div>";
        } elseif (strlen($nova_senha) < 6) {
            echo "<div class='error'>";
            echo "<h3>❌ Erro</h3>";
            echo "<p>A senha deve ter no mínimo 6 caracteres.</p>";
            echo "</div>";
        } else {
            // Verificar se usuário existe
            $stmt = $pdo->prepare("SELECT id, nome, email, role FROM usuarios WHERE email = ?");
            $stmt->execute([$email]);
            $user = $stmt->fetch();

            if (!$user) {
                echo "<div class='error'>";
                echo "<h3>❌ Usuário não encontrado</h3>";
                echo "<p>Não existe usuário com o e-mail: <strong>$email</strong></p>";
                echo "</div>";
            } else {
                // Gerar hash da nova senha
                $senha_hash = password_hash($nova_senha, PASSWORD_DEFAULT);

                // Atualizar senha
                $stmt = $pdo->prepare("UPDATE usuarios SET senha = ? WHERE email = ?");

                if ($stmt->execute([$senha_hash, $email])) {
                    echo "<div class='success'>";
                    echo "<h3>🎉 Senha Redefinida com Sucesso!</h3>";
                    echo "<p><strong>Usuário:</strong> {$user['nome']}</p>";
                    echo "<p><strong>E-mail:</strong> {$user['email']}</p>";
                    echo "<p><strong>Role:</strong> {$user['role']}</p>";
                    echo "<p><strong>Nova senha:</strong> " . htmlspecialchars($nova_senha) . "</p>";
                    echo "<hr style='margin: 15px 0;'>";
                    echo "<h4>✅ Agora você pode fazer login!</h4>";
                    echo "<p><a href='login.php' class='btn'>🚀 IR PARA LOGIN</a></p>";
                    echo "<p><a href='testar_login_direto.php' class='btn btn-link' style='text-align: center; width: 100%;'>🧪 TESTAR LOGIN DIRETO</a></p>";
                    echo "</div>";
                } else {
                    echo "<div class='error'>";
                    echo "<h3>❌ Erro ao atualizar senha</h3>";
                    echo "<p>Ocorreu um erro ao tentar atualizar a senha.</p>";
                    echo "</div>";
                }
            }
        }
    }

    // Listar usuários disponíveis
    echo "<h2>👥 Usuários Disponíveis</h2>";

    $stmt = $pdo->query("SELECT id, nome, email, role, status FROM usuarios ORDER BY id ASC");
    $usuarios = $stmt->fetchAll();

    if (empty($usuarios)) {
        echo "<div class='info'>";
        echo "<p>Nenhum usuário encontrado no sistema.</p>";
        echo "</div>";
    } else {
        echo "<div class='info'>";
        echo "<p><strong>Total de usuários:</strong> " . count($usuarios) . "</p>";
        echo "</div>";

        echo "<table style='width: 100%; border-collapse: collapse; margin: 15px 0;'>";
        echo "<tr style='background: #667eea; color: white;'>";
        echo "<th style='padding: 10px; text-align: left;'>ID</th>";
        echo "<th style='padding: 10px; text-align: left;'>Nome</th>";
        echo "<th style='padding: 10px; text-align: left;'>E-mail</th>";
        echo "<th style='padding: 10px; text-align: left;'>Role</th>";
        echo "<th style='padding: 10px; text-align: left;'>Status</th>";
        echo "</tr>";

        foreach ($usuarios as $user) {
            echo "<tr style='border-bottom: 1px solid #ddd;'>";
            echo "<td style='padding: 10px;'>{$user['id']}</td>";
            echo "<td style='padding: 10px;'>{$user['nome']}</td>";
            echo "<td style='padding: 10px;'><strong>{$user['email']}</strong></td>";
            echo "<td style='padding: 10px;'>{$user['role']}</td>";
            echo "<td style='padding: 10px;'>{$user['status']}</td>";
            echo "</tr>";
        }

        echo "</table>";
    }

    // Formulário de redefinição
    echo "<h2>🔑 Redefinir Senha</h2>";
    echo "<form method='POST'>";
    echo "<label>E-mail do Usuário:</label>";
    echo "<input type='email' name='email' required placeholder='Digite o e-mail do usuário' value='admin@sistema.com'>";
    echo "<label>Nova Senha:</label>";
    echo "<input type='password' name='nova_senha' required placeholder='Digite a nova senha (mínimo 6 caracteres)' minlength='6'>";
    echo "<label>Confirmar Nova Senha:</label>";
    echo "<input type='password' name='confirmar_senha' required placeholder='Digite a senha novamente' minlength='6'>";
    echo "<button type='submit' name='redefinir' class='btn'>🔐 REDEFINIR SENHA</button>";
    echo "</form>";

} catch (PDOException $e) {
    echo "<div class='error'>";
    echo "<h3>❌ Erro de Conexão</h3>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}
?>

</div>
</body>
</html>
