<?php
/**
 * Sistema de Tema Dinâmico - White Label v2.0
 * Gera CSS com variáveis baseadas nas configurações do banco
 * Incluir este arquivo no <head> de todas as páginas
 */

// Valores padrão (caso a tabela não exista ainda)
$config_visual = [
    'nome_sistema' => 'PromoTaal',
    'cor_primaria' => '#FFC107',
    'cor_secundaria' => '#1a1a1a',
    'cor_fundo' => '#000000',
    'cor_card' => '#1a1a1a',
    'cor_texto' => '#ffffff',
    'cor_texto_secundario' => '#b0b0b0',
    'cor_borda' => '#333333',
    'cor_sucesso' => '#28a745',
    'cor_erro' => '#dc3545',
    'cor_aviso' => '#ffc107',
    'cor_info' => '#17a2b8',
    'cor_hover' => '#FFD54F',
    'tipo_menu' => 'menu_lateral'
];

// Tentar buscar configurações do banco (se existir)
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT * FROM configuracoes_visual WHERE id = 1");
        $db_config = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($db_config) {
            $config_visual = $db_config;
        }
    } catch (PDOException $e) {
        // Tabela não existe ainda, usar valores padrão
    }
} elseif (file_exists('config.php')) {
    try {
        require_once 'config.php';
        $stmt = $pdo->query("SELECT * FROM configuracoes_visual WHERE id = 1");
        $db_config = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($db_config) {
            $config_visual = $db_config;
        }
    } catch (Exception $e) {
        // Usar valores padrão
    }
}

// Definir constantes (se ainda não definidas)
if (!defined('SISTEMA_NOME')) {
    define('SISTEMA_NOME', $config_visual['nome_sistema']);
}
if (!defined('TIPO_MENU')) {
    define('TIPO_MENU', $config_visual['tipo_menu'] ?? 'menu_lateral');
}
?>
:root {
    /* ========================================
       CORES DO SISTEMA - WHITE LABEL v2.0
       Editável em: Admin > Configurações > Personalização Visual
       ======================================== */

    /* Cor Principal - Usada em botões primários, links, destaques */
    --cor-primaria: <?= $config_visual['cor_primaria'] ?>;

    /* Cor Secundária - Usada em elementos de apoio e fundos alternativos */
    --cor-secundaria: <?= $config_visual['cor_secundaria'] ?>;

    /* Cor de Fundo - Fundo principal do sistema (body) */
    --cor-fundo: <?= $config_visual['cor_fundo'] ?>;

    /* Cor dos Cards - Fundo de cards, modais e containers */
    --cor-card: <?= $config_visual['cor_card'] ?>;

    /* Cor do Texto Principal - Textos principais, títulos */
    --cor-texto: <?= $config_visual['cor_texto'] ?>;

    /* Cor do Texto Secundário - Textos menos importantes, labels */
    --cor-texto-secundario: <?= $config_visual['cor_texto_secundario'] ?>;

    /* Cor das Bordas - Bordas de inputs, cards, separadores */
    --cor-borda: <?= $config_visual['cor_borda'] ?>;

    /* Cor de Sucesso - Mensagens de sucesso, status positivo */
    --cor-sucesso: <?= $config_visual['cor_sucesso'] ?>;

    /* Cor de Erro - Mensagens de erro, alertas críticos */
    --cor-erro: <?= $config_visual['cor_erro'] ?>;

    /* Cor de Aviso - Mensagens de atenção, pendências */
    --cor-aviso: <?= $config_visual['cor_aviso'] ?>;

    /* Cor de Info - Mensagens informativas, dicas */
    --cor-info: <?= $config_visual['cor_info'] ?>;

    /* Cor de Hover - Efeito ao passar o mouse sobre elementos interativos */
    --cor-hover: <?= $config_visual['cor_hover'] ?>;

    /* ========================================
       CORES DERIVADAS (Calculadas automaticamente)
       ======================================== */
    --cor-primaria-escura: color-mix(in srgb, var(--cor-primaria) 80%, black);
    --cor-primaria-clara: color-mix(in srgb, var(--cor-primaria) 80%, white);
    --cor-fundo-transparente: color-mix(in srgb, var(--cor-fundo) 95%, transparent);
}

/* ========================================
   APLICAÇÃO DAS CORES NO SISTEMA
   ======================================== */

/* Fundo principal */
body {
    background-color: var(--cor-fundo);
    color: var(--cor-texto);
}

/* Cards e Containers */
.card, .modal-content, .dashboard-card, .stats-card {
    background-color: var(--cor-card);
    border-color: var(--cor-borda);
    color: var(--cor-texto);
}

/* Textos */
h1, h2, h3, h4, h5, h6 {
    color: var(--cor-texto);
}

p, span, div {
    color: var(--cor-texto);
}

.text-muted, small, .text-secondary {
    color: var(--cor-texto-secundario) !important;
}

/* Botões */
.btn-primary, .btn-warning {
    background-color: var(--cor-primaria);
    border-color: var(--cor-primaria);
    color: #000;
}

.btn-primary:hover, .btn-warning:hover {
    background-color: var(--cor-hover);
    border-color: var(--cor-hover);
}

.btn-success {
    background-color: var(--cor-sucesso);
    border-color: var(--cor-sucesso);
}

.btn-danger {
    background-color: var(--cor-erro);
    border-color: var(--cor-erro);
}

.btn-info {
    background-color: var(--cor-info);
    border-color: var(--cor-info);
}

/* Inputs e Forms */
.form-control, .form-select, input, textarea, select {
    background-color: var(--cor-card);
    border-color: var(--cor-borda);
    color: var(--cor-texto);
}

.form-control:focus, input:focus, textarea:focus, select:focus {
    background-color: var(--cor-card);
    border-color: var(--cor-primaria);
    color: var(--cor-texto);
    box-shadow: 0 0 0 0.2rem color-mix(in srgb, var(--cor-primaria) 25%, transparent);
}

.form-label, label {
    color: var(--cor-texto);
}

/* Tabelas */
.table {
    color: var(--cor-texto);
    border-color: var(--cor-borda);
}

.table thead th {
    background-color: var(--cor-secundaria);
    color: var(--cor-texto);
    border-color: var(--cor-borda);
}

.table tbody tr {
    background-color: var(--cor-card);
    border-color: var(--cor-borda);
}

.table tbody tr:hover {
    background-color: color-mix(in srgb, var(--cor-card) 90%, var(--cor-primaria));
}

/* Alertas */
.alert-success {
    background-color: color-mix(in srgb, var(--cor-sucesso) 20%, var(--cor-card));
    border-color: var(--cor-sucesso);
    color: var(--cor-sucesso);
}

.alert-danger {
    background-color: color-mix(in srgb, var(--cor-erro) 20%, var(--cor-card));
    border-color: var(--cor-erro);
    color: var(--cor-erro);
}

.alert-warning {
    background-color: color-mix(in srgb, var(--cor-aviso) 20%, var(--cor-card));
    border-color: var(--cor-aviso);
    color: var(--cor-aviso);
}

.alert-info {
    background-color: color-mix(in srgb, var(--cor-info) 20%, var(--cor-card));
    border-color: var(--cor-info);
    color: var(--cor-info);
}

/* Badges */
.badge-primary {
    background-color: var(--cor-primaria);
    color: #000;
}

.badge-success {
    background-color: var(--cor-sucesso);
}

.badge-danger {
    background-color: var(--cor-erro);
}

.badge-warning {
    background-color: var(--cor-aviso);
    color: #000;
}

.badge-info {
    background-color: var(--cor-info);
}

/* Links */
a {
    color: var(--cor-primaria);
}

a:hover {
    color: var(--cor-hover);
}

/* Navbar e Menu */
.navbar, .sidebar, .top-nav {
    background-color: var(--cor-secundaria);
    border-color: var(--cor-borda);
}

.nav-link {
    color: var(--cor-texto-secundario);
}

.nav-link:hover, .nav-link.active {
    color: var(--cor-primaria);
}

/* Modal */
.modal-header, .modal-footer {
    border-color: var(--cor-borda);
}

/* Bordas e Separadores */
hr, .border, .border-top, .border-bottom {
    border-color: var(--cor-borda) !important;
}

/* Stats Cards */
.stat-value {
    color: var(--cor-primaria);
}

/* QR Code Container */
.qr-container {
    background-color: var(--cor-card);
    border-color: var(--cor-borda);
}

/* Status Labels */
.status-pendente {
    color: var(--cor-aviso);
}

.status-concluido, .status-aprovado {
    color: var(--cor-sucesso);
}

.status-cancelado {
    color: var(--cor-erro);
}

.status-processando {
    color: var(--cor-info);
}
