<?php
// testar_login_direto.php - Testa login diretamente e mostra detalhes
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Conectar diretamente
$DB_HOST = 'localhost';
$DB_PORT = '3306';
$DB_NAME = 'invitmecom_promosis';
$DB_USER = 'invitmecom_promosis';
$DB_PASS = 'rH]&iG%{ysipNDnB';

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Teste de Login Direto</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; margin-bottom: 20px; }
        h2 { color: #764ba2; margin: 25px 0 15px 0; border-bottom: 2px solid #667eea; padding-bottom: 10px; }
        .success { background: #d4edda; color: #155724; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #28a745; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #dc3545; }
        .warning { background: #fff3cd; color: #856404; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #ffc107; }
        .info { background: #d1ecf1; color: #0c5460; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #17a2b8; }
        table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        table th { background: #667eea; color: white; padding: 12px; text-align: left; }
        table td { padding: 10px 12px; border-bottom: 1px solid #dee2e6; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; font-size: 12px; overflow-x: auto; }
        input { width: 100%; padding: 12px; margin: 8px 0; border: 1px solid #ddd; border-radius: 5px; }
        .btn { background: #28a745; color: white; padding: 15px 30px; border: none; border-radius: 8px; font-size: 16px; cursor: pointer; }
        .btn:hover { background: #218838; }
    </style>
</head>
<body>
<div class="container">
    <h1>🔐 Teste de Login Direto</h1>

<?php
try {
    $pdo = new PDO(
        "mysql:host=$DB_HOST;port=$DB_PORT;dbname=$DB_NAME;charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );

    echo "<div class='success'>";
    echo "<p>✅ Conectado ao banco: <strong>$DB_NAME</strong></p>";
    echo "</div>";

    // Listar TODOS os usuários
    echo "<h2>👥 Todos os Usuários no Banco</h2>";

    $stmt = $pdo->query("SELECT id, nome, email, role, status, ativo FROM usuarios ORDER BY id ASC");
    $usuarios = $stmt->fetchAll();

    if (empty($usuarios)) {
        echo "<div class='warning'>";
        echo "<h3>⚠️ Nenhum usuário encontrado!</h3>";
        echo "<p>A tabela está vazia. Você precisa criar um usuário primeiro.</p>";
        echo "</div>";

        // Formulário para criar usuário
        echo "<h2>👤 Criar Primeiro Usuário</h2>";
        echo "<form method='POST'>";
        echo "<label>Nome:</label>";
        echo "<input type='text' name='nome' required placeholder='Nome Completo'>";
        echo "<label>E-mail:</label>";
        echo "<input type='email' name='email' required placeholder='email@exemplo.com'>";
        echo "<label>Senha:</label>";
        echo "<input type='password' name='senha' required placeholder='Mínimo 6 caracteres' minlength='6'>";
        echo "<button type='submit' name='criar' class='btn'>✅ Criar Administrador</button>";
        echo "</form>";

    } else {
        echo "<div class='info'>";
        echo "<p><strong>Total de usuários:</strong> " . count($usuarios) . "</p>";
        echo "</div>";

        echo "<table>";
        echo "<tr><th>ID</th><th>Nome</th><th>E-mail</th><th>Role</th><th>Status</th><th>Ativo</th><th>Pode Logar?</th></tr>";

        foreach ($usuarios as $user) {
            $pode_logar = ($user['status'] === 'aprovado' && $user['ativo'] == 1);
            $pode_logar_text = $pode_logar ? '<span style="color: green;">✅ SIM</span>' : '<span style="color: red;">❌ NÃO</span>';

            echo "<tr>";
            echo "<td>{$user['id']}</td>";
            echo "<td>{$user['nome']}</td>";
            echo "<td>{$user['email']}</td>";
            echo "<td>{$user['role']}</td>";
            echo "<td><strong>{$user['status']}</strong></td>";
            echo "<td>" . ($user['ativo'] ? '✅' : '❌') . "</td>";
            echo "<td>$pode_logar_text</td>";
            echo "</tr>";
        }

        echo "</table>";

        // Verificar problemas
        $usuarios_bloqueados = array_filter($usuarios, function($u) {
            return $u['status'] !== 'aprovado' || $u['ativo'] != 1;
        });

        if (!empty($usuarios_bloqueados)) {
            echo "<div class='error'>";
            echo "<h3>⚠️ PROBLEMA ENCONTRADO!</h3>";
            echo "<p>Alguns usuários NÃO podem fazer login porque:</p>";
            echo "<ul>";
            foreach ($usuarios_bloqueados as $user) {
                echo "<li><strong>{$user['email']}</strong>: ";
                if ($user['status'] !== 'aprovado') {
                    echo "Status é '<strong>{$user['status']}</strong>' (precisa ser 'aprovado')";
                }
                if ($user['ativo'] != 1) {
                    echo " | Ativo = <strong>{$user['ativo']}</strong> (precisa ser 1)";
                }
                echo "</li>";
            }
            echo "</ul>";

            echo "<h4>🔧 Solução:</h4>";
            echo "<form method='POST'>";
            echo "<p>Selecione o usuário para ativar:</p>";
            echo "<select name='user_id' style='width: 100%; padding: 10px; margin: 10px 0;'>";
            foreach ($usuarios_bloqueados as $user) {
                echo "<option value='{$user['id']}'>{$user['email']} (ID: {$user['id']})</option>";
            }
            echo "</select>";
            echo "<button type='submit' name='ativar' class='btn'>✅ ATIVAR ESTE USUÁRIO</button>";
            echo "</form>";
            echo "</div>";
        } else {
            echo "<div class='success'>";
            echo "<h3>✅ Todos os usuários podem fazer login!</h3>";
            echo "</div>";
        }

        // Formulário de teste de login
        echo "<h2>🧪 Testar Login</h2>";
        echo "<form method='POST'>";
        echo "<label>E-mail:</label>";
        echo "<input type='email' name='test_email' required placeholder='Digite o e-mail do usuário'>";
        echo "<label>Senha:</label>";
        echo "<input type='password' name='test_senha' required placeholder='Digite a senha'>";
        echo "<button type='submit' name='testar' class='btn'>🔐 Testar Login</button>";
        echo "</form>";
    }

    // Processar criação de usuário
    if (isset($_POST['criar'])) {
        $nome = trim($_POST['nome']);
        $email = trim($_POST['email']);
        $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);

        try {
            $stmt = $pdo->prepare("INSERT INTO usuarios (nome, email, senha, role, status, ativo, data_cadastro) VALUES (?, ?, ?, 'admin', 'aprovado', 1, NOW())");
            $stmt->execute([$nome, $email, $senha]);

            echo "<div class='success'>";
            echo "<h3>🎉 Usuário Criado!</h3>";
            echo "<p><strong>Nome:</strong> $nome</p>";
            echo "<p><strong>E-mail:</strong> $email</p>";
            echo "<p><strong>Status:</strong> aprovado</p>";
            echo "<p><strong>Ativo:</strong> Sim</p>";
            echo "<p><a href='testar_login_direto.php' class='btn'>🔄 Atualizar Página</a></p>";
            echo "</div>";
        } catch (PDOException $e) {
            echo "<div class='error'>";
            echo "<h3>❌ Erro ao criar usuário</h3>";
            echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
            echo "</div>";
        }
    }

    // Processar ativação
    if (isset($_POST['ativar'])) {
        $user_id = (int)$_POST['user_id'];

        try {
            $stmt = $pdo->prepare("UPDATE usuarios SET status = 'aprovado', ativo = 1 WHERE id = ?");
            $stmt->execute([$user_id]);

            echo "<div class='success'>";
            echo "<h3>✅ Usuário Ativado!</h3>";
            echo "<p>O usuário ID $user_id foi ativado e aprovado.</p>";
            echo "<p><a href='testar_login_direto.php' class='btn'>🔄 Atualizar Página</a></p>";
            echo "</div>";
        } catch (PDOException $e) {
            echo "<div class='error'>";
            echo "<p>❌ Erro: " . htmlspecialchars($e->getMessage()) . "</p>";
            echo "</div>";
        }
    }

    // Processar teste de login
    if (isset($_POST['testar'])) {
        $test_email = trim($_POST['test_email']);
        $test_senha = $_POST['test_senha'];

        echo "<h2>🧪 Resultado do Teste</h2>";

        try {
            $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = ?");
            $stmt->execute([$test_email]);
            $user = $stmt->fetch();

            if (!$user) {
                echo "<div class='error'>";
                echo "<h3>❌ Usuário não encontrado</h3>";
                echo "<p>Não existe usuário com o e-mail: <strong>$test_email</strong></p>";
                echo "</div>";
            } else {
                echo "<div class='info'>";
                echo "<h4>Usuário Encontrado:</h4>";
                echo "<p><strong>ID:</strong> {$user['id']}</p>";
                echo "<p><strong>Nome:</strong> {$user['nome']}</p>";
                echo "<p><strong>E-mail:</strong> {$user['email']}</p>";
                echo "<p><strong>Role:</strong> {$user['role']}</p>";
                echo "<p><strong>Status:</strong> {$user['status']}</p>";
                echo "<p><strong>Ativo:</strong> " . ($user['ativo'] ? 'Sim' : 'Não') . "</p>";
                echo "</div>";

                // Verificar senha
                if (password_verify($test_senha, $user['senha'])) {
                    echo "<div class='success'>";
                    echo "<h3>✅ SENHA CORRETA!</h3>";
                    echo "</div>";

                    // Verificar se pode logar
                    if ($user['status'] === 'aprovado' && $user['ativo'] == 1) {
                        echo "<div class='success'>";
                        echo "<h3>🎉 LOGIN DEVE FUNCIONAR!</h3>";
                        echo "<p>Todas as condições estão corretas:</p>";
                        echo "<ul>";
                        echo "<li>✅ Usuário existe</li>";
                        echo "<li>✅ Senha correta</li>";
                        echo "<li>✅ Status = aprovado</li>";
                        echo "<li>✅ Ativo = 1</li>";
                        echo "</ul>";
                        echo "<p><strong>Tente fazer login agora:</strong></p>";
                        echo "<p><a href='login.php' class='btn' style='font-size: 20px; padding: 20px 40px;'>🚀 IR PARA LOGIN</a></p>";
                        echo "</div>";
                    } else {
                        echo "<div class='error'>";
                        echo "<h3>❌ NÃO PODE LOGAR</h3>";
                        echo "<p>Problemas encontrados:</p>";
                        echo "<ul>";
                        if ($user['status'] !== 'aprovado') {
                            echo "<li>❌ Status é '{$user['status']}' (precisa ser 'aprovado')</li>";
                        }
                        if ($user['ativo'] != 1) {
                            echo "<li>❌ Ativo = {$user['ativo']} (precisa ser 1)</li>";
                        }
                        echo "</ul>";
                        echo "</div>";
                    }
                } else {
                    echo "<div class='error'>";
                    echo "<h3>❌ SENHA INCORRETA!</h3>";
                    echo "<p>A senha digitada não corresponde à senha cadastrada.</p>";
                    echo "</div>";
                }
            }
        } catch (PDOException $e) {
            echo "<div class='error'>";
            echo "<p>❌ Erro: " . htmlspecialchars($e->getMessage()) . "</p>";
            echo "</div>";
        }
    }

} catch (PDOException $e) {
    echo "<div class='error'>";
    echo "<h3>❌ Erro de Conexão</h3>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}
?>

</div>
</body>
</html>
