<?php
// teste_comissao.php - ARQUIVO TEMPORÁRIO PARA DEBUG
// APAGUE APÓS RESOLVER O PROBLEMA!

require_once 'config.php';
require_once 'functions.php';
verificarLogin();

$user_id = $_SESSION['user_id'];

echo "<h1>🔍 DEBUG - Comissões do Promoter</h1>";
echo "<style>
body { font-family: Arial; padding: 20px; background: #1a1a1a; color: #fff; }
table { width: 100%; border-collapse: collapse; margin: 20px 0; background: #2a2a2a; }
th, td { padding: 12px; border: 1px solid #444; text-align: left; }
th { background: #000; color: #FFD700; }
.ok { color: #00C851; }
.erro { color: #ff4444; }
.info { background: #333; padding: 15px; border-radius: 8px; margin: 15px 0; }
</style>";

// Buscar dados do usuário
$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

echo "<div class='info'>";
echo "<h2>👤 Dados do Promoter</h2>";
echo "ID: <strong>{$usuario['id']}</strong><br>";
echo "Nome: <strong>{$usuario['nome']}</strong><br>";
echo "Email: <strong>{$usuario['email']}</strong><br>";
echo "Pontuação: <strong>{$usuario['pontuacao']}</strong><br>";
echo "</div>";

// Buscar eventos que participa
echo "<h2>🎪 Eventos que Participa</h2>";
$stmt = $pdo->prepare("
    SELECT e.* 
    FROM eventos e
    INNER JOIN produtor_eventos pe ON e.id = pe.evento_id
    WHERE pe.user_id = ?
");
$stmt->execute([$user_id]);
$eventos = $stmt->fetchAll();

if (count($eventos) === 0) {
    echo "<p class='erro'>❌ Você não está participando de nenhum evento!</p>";
    echo "<p>Vá em <a href='eventos.php' style='color: #FFD700;'>Eventos</a> e participe de um evento primeiro.</p>";
    exit;
}

echo "<table>";
echo "<tr><th>ID</th><th>Nome</th><th>Valor Comissão</th><th>Mínimo Lista</th></tr>";
foreach ($eventos as $evt) {
    echo "<tr>";
    echo "<td>{$evt['id']}</td>";
    echo "<td>{$evt['nome']}</td>";
    echo "<td>R$ " . number_format($evt['valor_comissao'], 2, ',', '.') . "</td>";
    echo "<td>{$evt['minimo_lista']}</td>";
    echo "</tr>";
}
echo "</table>";

// Para cada evento, verificar convidados e comissões
foreach ($eventos as $evento) {
    echo "<hr style='margin: 30px 0; border-color: #444;'>";
    echo "<h2>📊 Evento: {$evento['nome']}</h2>";
    
    // Contar convidados
    $stmt = $pdo->prepare("
        SELECT 
            COUNT(*) as total,
            SUM(CASE WHEN checkin = 1 THEN 1 ELSE 0 END) as checkins
        FROM convidados 
        WHERE promoter_id = ? AND evento_id = ?
    ");
    $stmt->execute([$user_id, $evento['id']]);
    $stats = $stmt->fetch();
    
    echo "<div class='info'>";
    echo "<strong>Total de Convidados:</strong> {$stats['total']}<br>";
    echo "<strong>Check-ins Realizados:</strong> {$stats['checkins']}<br>";
    echo "<strong>Mínimo Necessário:</strong> {$evento['minimo_lista']}<br>";
    
    if ($stats['total'] < $evento['minimo_lista']) {
        echo "<p class='erro'>❌ NÃO ATINGIU O MÍNIMO - Sem comissão</p>";
    } else {
        $valor_esperado = $stats['checkins'] * $evento['valor_comissao'];
        echo "<p class='ok'>✅ Atingiu o mínimo!</p>";
        echo "<strong>Valor Esperado:</strong> R$ " . number_format($valor_esperado, 2, ',', '.') . "<br>";
    }
    echo "</div>";
    
    // Listar convidados
    echo "<h3>📋 Lista de Convidados</h3>";
    $stmt = $pdo->prepare("SELECT * FROM convidados WHERE promoter_id = ? AND evento_id = ? ORDER BY created_at DESC");
    $stmt->execute([$user_id, $evento['id']]);
    $convidados = $stmt->fetchAll();
    
    if (count($convidados) > 0) {
        echo "<table>";
        echo "<tr><th>ID</th><th>Nome</th><th>Telefone</th><th>Check-in</th><th>Data Check-in</th></tr>";
        foreach ($convidados as $conv) {
            $checkin_status = $conv['checkin'] ? "<span class='ok'>✅ SIM</span>" : "<span class='erro'>❌ NÃO</span>";
            $checkin_data = $conv['checkin_data'] ? date('d/m/Y H:i', strtotime($conv['checkin_data'])) : '-';
            echo "<tr>";
            echo "<td>{$conv['id']}</td>";
            echo "<td>{$conv['nome']}</td>";
            echo "<td>{$conv['whatsapp']}</td>";
            echo "<td>{$checkin_status}</td>";
            echo "<td>{$checkin_data}</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>Nenhum convidado cadastrado ainda.</p>";
    }
    
    // Verificar comissão no banco
    echo "<h3>💰 Comissão no Banco de Dados</h3>";
    $stmt = $pdo->prepare("SELECT * FROM comissoes WHERE user_id = ? AND evento_id = ?");
    $stmt->execute([$user_id, $evento['id']]);
    $comissao = $stmt->fetch();
    
    if ($comissao) {
        echo "<div class='info'>";
        echo "<strong>ID:</strong> {$comissao['id']}<br>";
        echo "<strong>Valor:</strong> R$ " . number_format($comissao['valor'], 2, ',', '.') . "<br>";
        echo "<strong>Convidados Total:</strong> {$comissao['convidados_total']}<br>";
        echo "<strong>Check-ins:</strong> {$comissao['convidados_checkin']}<br>";
        echo "<strong>Status:</strong> {$comissao['status']}<br>";
        echo "<strong>Criado em:</strong> " . date('d/m/Y H:i', strtotime($comissao['created_at'])) . "<br>";
        echo "</div>";
    } else {
        echo "<p class='erro'>❌ Nenhuma comissão registrada no banco!</p>";
    }
    
    // Botão para forçar atualização
    echo "<form method='POST' style='margin-top: 20px;'>";
    echo "<input type='hidden' name='evento_id' value='{$evento['id']}'>";
    echo "<button type='submit' name='atualizar' style='padding: 15px 30px; background: #FFD700; color: #000; border: none; border-radius: 8px; font-weight: bold; cursor: pointer;'>";
    echo "🔄 FORÇAR ATUALIZAÇÃO DE COMISSÃO";
    echo "</button>";
    echo "</form>";
}

// Processar atualização forçada
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['atualizar'])) {
    $evento_id = intval($_POST['evento_id']);
    echo "<div style='background: #FFD700; color: #000; padding: 15px; border-radius: 8px; margin: 20px 0;'>";
    echo "<h3>🔄 Atualizando Comissão...</h3>";
    
    $resultado = atualizarComissoes($pdo, $user_id, $evento_id);
    
    if ($resultado) {
        echo "<p class='ok'>✅ Comissão atualizada com sucesso!</p>";
        echo "<p><a href='teste_comissao.php' style='color: #000;'>Recarregar página</a></p>";
    } else {
        echo "<p class='erro'>❌ Erro ao atualizar comissão</p>";
    }
    echo "</div>";
}

// Mostrar saldo total
echo "<hr style='margin: 30px 0; border-color: #444;'>";
echo "<h2>💵 Saldo Total</h2>";
$stmt = $pdo->prepare("
    SELECT 
        SUM(CASE WHEN status = 'disponivel' THEN valor ELSE 0 END) as disponivel,
        SUM(CASE WHEN status = 'solicitado' THEN valor ELSE 0 END) as solicitado,
        SUM(CASE WHEN status = 'pago' THEN valor ELSE 0 END) as pago,
        SUM(valor) as total
    FROM comissoes 
    WHERE user_id = ?
");
$stmt->execute([$user_id]);
$saldos = $stmt->fetch();

echo "<div class='info'>";
echo "<strong>Disponível:</strong> R$ " . number_format($saldos['disponivel'] ?? 0, 2, ',', '.') . "<br>";
echo "<strong>Solicitado:</strong> R$ " . number_format($saldos['solicitado'] ?? 0, 2, ',', '.') . "<br>";
echo "<strong>Pago:</strong> R$ " . number_format($saldos['pago'] ?? 0, 2, ',', '.') . "<br>";
echo "<strong>Total Geral:</strong> R$ " . number_format($saldos['total'] ?? 0, 2, ',', '.') . "<br>";
echo "</div>";

echo "<hr style='margin: 30px 0; border-color: #444;'>";
echo "<p style='text-align: center; color: #999; margin-top: 30px;'>";
echo "⚠️ <strong>IMPORTANTE:</strong> Apague este arquivo (teste_comissao.php) após resolver o problema!";
echo "</p>";
?>