<?php
// verificar_correcao.php - Verifica se users foi corrigido para usuarios
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Verificar Correção users → usuarios</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; margin-bottom: 20px; }
        .success { background: #d4edda; color: #155724; padding: 15px; margin: 15px 0; border-radius: 5px; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; margin: 15px 0; border-radius: 5px; }
        .warning { background: #fff3cd; color: #856404; padding: 15px; margin: 15px 0; border-radius: 5px; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; font-size: 12px; overflow-x: auto; }
        .btn { background: #28a745; color: white; padding: 15px 30px; border: none; border-radius: 8px; font-size: 18px; text-decoration: none; display: inline-block; margin: 10px 0; }
    </style>
</head>
<body>
<div class="container">
    <h1>🔍 Verificar Se Correção Foi Aplicada</h1>

<?php
// Verificar login.php
$login_file = __DIR__ . '/login.php';

if (file_exists($login_file)) {
    $conteudo = file_get_contents($login_file);

    $tem_users = (stripos($conteudo, 'FROM usuarios') !== false ||
                  stripos($conteudo, 'INTO usuarios') !== false ||
                  stripos($conteudo, 'JOIN usuarios') !== false);

    $tem_usuarios = (stripos($conteudo, 'FROM usuarios') !== false);

    echo "<h2>📄 Status do login.php</h2>";

    if ($tem_users) {
        echo "<div class='error'>";
        echo "<h3>❌ AINDA NÃO CORRIGIDO!</h3>";
        echo "<p>O arquivo <strong>login.php</strong> ainda contém referências a '<code>users</code>' (inglês).</p>";
        echo "<p><strong>Você precisa:</strong></p>";
        echo "<ol>";
        echo "<li>Acessar: <code>fix_all_users_references.php</code></li>";
        echo "<li>Clicar no botão: <strong>🔨 CORRIGIR TODOS OS ARQUIVOS AGORA</strong></li>";
        echo "<li>Aguardar a confirmação</li>";
        echo "<li>Voltar aqui e atualizar esta página</li>";
        echo "</ol>";

        // Mostrar as linhas problemáticas
        $linhas = file($login_file);
        echo "<h4>Linhas que precisam ser corrigidas:</h4>";
        echo "<pre>";
        foreach ($linhas as $num => $linha) {
            if (stripos($linha, 'FROM usuarios') !== false ||
                stripos($linha, 'INTO usuarios') !== false ||
                stripos($linha, 'JOIN usuarios') !== false) {
                $linha_num = $num + 1;
                echo "Linha $linha_num: " . htmlspecialchars($linha);
            }
        }
        echo "</pre>";
        echo "</div>";

        echo "<div class='warning'>";
        echo "<h3>🔧 Link Direto:</h3>";
        echo "<p><a href='fix_all_users_references.php' class='btn'>➡️ IR PARA O CORRETOR AUTOMÁTICO</a></p>";
        echo "</div>";

    } elseif ($tem_usuarios) {
        echo "<div class='success'>";
        echo "<h3>✅ CORRIGIDO COM SUCESSO!</h3>";
        echo "<p>O arquivo <strong>login.php</strong> agora usa '<code>usuarios</code>' (português) corretamente!</p>";
        echo "<p><strong>Próximo passo:</strong> Tente fazer login agora!</p>";
        echo "<p><a href='login.php' class='btn' style='font-size: 20px; padding: 20px 40px;'>🔐 ACESSAR LOGIN</a></p>";
        echo "</div>";
    } else {
        echo "<div class='warning'>";
        echo "<p>⚠️ Não foram encontradas referências a 'users' nem 'usuarios' no login.php</p>";
        echo "</div>";
    }

} else {
    echo "<div class='error'>";
    echo "<p>❌ Arquivo login.php não encontrado!</p>";
    echo "</div>";
}

?>

</div>
</body>
</html>
