<?php
// verificar_local.php - Descobrir onde estamos
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificar Localização dos Arquivos</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 {
            color: #667eea;
            margin-bottom: 20px;
            font-size: 28px;
        }
        h2 {
            color: #764ba2;
            margin: 25px 0 15px 0;
            font-size: 20px;
            border-bottom: 2px solid #667eea;
            padding-bottom: 10px;
        }
        .info-box {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 15px;
            margin: 15px 0;
            border-radius: 5px;
        }
        .success {
            background: #d4edda;
            border-left-color: #28a745;
            color: #155724;
        }
        .error {
            background: #f8d7da;
            border-left-color: #dc3545;
            color: #721c24;
        }
        .warning {
            background: #fff3cd;
            border-left-color: #ffc107;
            color: #856404;
        }
        code {
            background: #e9ecef;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            font-size: 14px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
        }
        table th {
            background: #667eea;
            color: white;
            padding: 12px;
            text-align: left;
        }
        table td {
            padding: 10px 12px;
            border-bottom: 1px solid #dee2e6;
        }
        table tr:hover {
            background: #f8f9fa;
        }
        .file-exists {
            color: #28a745;
            font-weight: bold;
        }
        .file-missing {
            color: #dc3545;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Verificador de Localização dos Arquivos</h1>

        <h2>📍 Informações do Servidor</h2>
        <table>
            <tr>
                <th>Item</th>
                <th>Valor</th>
            </tr>
            <tr>
                <td><strong>Domínio Atual</strong></td>
                <td><code><?php echo $_SERVER['HTTP_HOST'] ?? 'N/A'; ?></code></td>
            </tr>
            <tr>
                <td><strong>URL Completa</strong></td>
                <td><code><?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}"; ?></code></td>
            </tr>
            <tr>
                <td><strong>Caminho Atual (Script)</strong></td>
                <td><code><?php echo __FILE__; ?></code></td>
            </tr>
            <tr>
                <td><strong>Diretório Atual</strong></td>
                <td><code><?php echo __DIR__; ?></code></td>
            </tr>
            <tr>
                <td><strong>DOCUMENT_ROOT</strong></td>
                <td><code><?php echo $_SERVER['DOCUMENT_ROOT'] ?? 'N/A'; ?></code></td>
            </tr>
            <tr>
                <td><strong>Caminho Real</strong></td>
                <td><code><?php echo realpath(__DIR__); ?></code></td>
            </tr>
        </table>

        <h2>📂 Estrutura de Pastas</h2>
        <div class="info-box">
            <p><strong>Diretório pai:</strong> <code><?php echo dirname(__DIR__); ?></code></p>
            <p><strong>Diretório atual:</strong> <code><?php echo basename(__DIR__); ?></code></p>
        </div>

        <h2>🔍 Arquivos Importantes</h2>
        <?php
        $arquivos_verificar = [
            'config.php',
            'login.php',
            'dashboard.php',
            'install.php',
            'install_direto.php',
            'install_database.sql',
            '.htaccess',
            'forcar_limpar_cache.php',
            'limpar_cache.php'
        ];

        echo "<table>";
        echo "<tr><th>Arquivo</th><th>Status</th><th>Caminho Completo</th></tr>";

        foreach ($arquivos_verificar as $arquivo) {
            $caminho_completo = __DIR__ . '/' . $arquivo;
            $existe = file_exists($caminho_completo);

            echo "<tr>";
            echo "<td><strong>$arquivo</strong></td>";

            if ($existe) {
                $tamanho = filesize($caminho_completo);
                $modificado = date('d/m/Y H:i:s', filemtime($caminho_completo));
                echo "<td class='file-exists'>✅ Existe<br><small>Tamanho: " . number_format($tamanho) . " bytes<br>Modificado: $modificado</small></td>";
            } else {
                echo "<td class='file-missing'>❌ NÃO ENCONTRADO</td>";
            }

            echo "<td><code>$caminho_completo</code></td>";
            echo "</tr>";
        }

        echo "</table>";
        ?>

        <h2>🌐 URLs Possíveis para Testar</h2>
        <?php
        $protocolo = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
        $host = $_SERVER['HTTP_HOST'] ?? 'seu-dominio.com';
        $dir_atual = dirname($_SERVER['REQUEST_URI']);

        $urls_testar = [
            'Login' => "$protocolo://$host$dir_atual/login.php",
            'Install' => "$protocolo://$host$dir_atual/install.php",
            'Install Direto' => "$protocolo://$host$dir_atual/install_direto.php",
            'Limpar Cache' => "$protocolo://$host$dir_atual/forcar_limpar_cache.php",
        ];

        echo "<div class='info-box success'>";
        echo "<p><strong>Com base no domínio atual, teste estas URLs:</strong></p>";
        echo "<ul style='margin: 10px 0; padding-left: 20px;'>";
        foreach ($urls_testar as $nome => $url) {
            $arquivo_local = __DIR__ . '/' . basename($url);
            $existe = file_exists($arquivo_local);
            $status = $existe ? '✅' : '❌';

            echo "<li style='margin: 8px 0;'>";
            echo "$status <strong>$nome:</strong><br>";
            echo "<a href='$url' target='_blank' style='color: #667eea; word-break: break-all;'>$url</a>";
            echo "</li>";
        }
        echo "</ul>";
        echo "</div>";
        ?>

        <h2>⚙️ Configuração do .htaccess</h2>
        <?php
        $htaccess = __DIR__ . '/.htaccess';
        if (file_exists($htaccess)) {
            echo "<div class='info-box success'>";
            echo "<p>✅ Arquivo .htaccess encontrado</p>";
            echo "<p><strong>Conteúdo (primeiras 20 linhas):</strong></p>";
            echo "<pre style='background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto; font-size: 12px;'>";
            $linhas = file($htaccess);
            echo htmlspecialchars(implode('', array_slice($linhas, 0, 20)));
            if (count($linhas) > 20) {
                echo "\n... (+" . (count($linhas) - 20) . " linhas)";
            }
            echo "</pre>";
            echo "</div>";
        } else {
            echo "<div class='info-box warning'>";
            echo "<p>⚠️ Arquivo .htaccess NÃO encontrado</p>";
            echo "<p>Isso pode causar problemas com URLs limpas.</p>";
            echo "</div>";
        }
        ?>

        <h2>🗂️ Listagem do Diretório</h2>
        <?php
        echo "<div class='info-box'>";
        echo "<p><strong>Arquivos encontrados no diretório atual:</strong></p>";
        echo "<ul style='columns: 2; margin: 10px 0; padding-left: 20px;'>";

        $arquivos = scandir(__DIR__);
        foreach ($arquivos as $arquivo) {
            if ($arquivo != '.' && $arquivo != '..') {
                $is_dir = is_dir(__DIR__ . '/' . $arquivo);
                $icon = $is_dir ? '📁' : '📄';
                echo "<li>$icon $arquivo</li>";
            }
        }

        echo "</ul>";
        echo "</div>";
        ?>

        <h2>🎯 Diagnóstico e Recomendações</h2>
        <?php
        // Verificar se estamos em subdiretório
        $document_root = $_SERVER['DOCUMENT_ROOT'] ?? '';
        $current_dir = __DIR__;
        $is_subdirectory = (strpos($current_dir, $document_root) !== false && $current_dir !== $document_root);

        if ($is_subdirectory) {
            $subdir = str_replace($document_root, '', $current_dir);
            echo "<div class='info-box warning'>";
            echo "<p><strong>⚠️ ATENÇÃO: Você está em um SUBDIRETÓRIO</strong></p>";
            echo "<p>Os arquivos estão em: <code>$subdir</code></p>";
            echo "<p><strong>Isso significa que você deve acessar:</strong></p>";
            echo "<ul>";
            echo "<li>❌ NÃO: <code>http://{$_SERVER['HTTP_HOST']}/login.php</code></li>";
            echo "<li>✅ SIM: <code>http://{$_SERVER['HTTP_HOST']}$subdir/login.php</code></li>";
            echo "</ul>";
            echo "</div>";
        } else {
            echo "<div class='info-box success'>";
            echo "<p>✅ Os arquivos estão no diretório raiz do domínio</p>";
            echo "<p>Você pode acessar diretamente: <code>http://{$_SERVER['HTTP_HOST']}/login.php</code></p>";
            echo "</div>";
        }

        // Verificar domínio
        $dominio_atual = $_SERVER['HTTP_HOST'] ?? '';
        echo "<div class='info-box'>";
        echo "<p><strong>💡 Domínio Detectado:</strong> <code>$dominio_atual</code></p>";

        if (strpos($dominio_atual, 'sis.invitme.com.br') !== false) {
            echo "<p>Você está acessando via <strong>sis.invitme.com.br</strong></p>";
            echo "<p>Verifique se este domínio está configurado corretamente no cPanel para apontar para a pasta correta.</p>";
        } elseif (strpos($dominio_atual, 'promo.taal') !== false) {
            echo "<p>Você está acessando via <strong>promo.taal.luminaink.com.br</strong></p>";
        } else {
            echo "<p>Domínio diferente detectado: <code>$dominio_atual</code></p>";
        }
        echo "</div>";
        ?>

        <h2>🚀 Próximos Passos</h2>
        <div class="info-box success">
            <p><strong>Baseado no diagnóstico acima, siga um dos caminhos:</strong></p>
            <ol style="margin: 10px 0; padding-left: 30px;">
                <li style="margin: 8px 0;">
                    <strong>Se os arquivos foram encontrados (✅):</strong><br>
                    Use as URLs sugeridas na seção "URLs Possíveis para Testar" acima
                </li>
                <li style="margin: 8px 0;">
                    <strong>Se muitos arquivos não foram encontrados (❌):</strong><br>
                    Você precisa fazer upload dos arquivos para este diretório: <code><?php echo __DIR__; ?></code>
                </li>
                <li style="margin: 8px 0;">
                    <strong>Se o domínio está errado:</strong><br>
                    Configure o DNS/cPanel para apontar <code>sis.invitme.com.br</code> para a pasta correta
                </li>
            </ol>
        </div>

    </div>
</body>
</html>
