<?php
require_once 'config.php';

echo "<h2>Verificação de Role - Problema User vs Promoter</h2>";

// 1. Verificar estrutura da coluna role
echo "<h3>1. Estrutura da Coluna Role:</h3>";
$stmt = $pdo->query("SHOW COLUMNS FROM usuarios WHERE Field = 'role'");
$column = $stmt->fetch();
echo "<pre>";
print_r($column);
echo "</pre>";

// 2. Verificar últimos 10 usuários cadastrados
echo "<h3>2. Últimos 10 Usuários Cadastrados:</h3>";
$stmt = $pdo->query("SELECT id, nome, email, role, status, data_cadastro FROM usuarios ORDER BY id DESC LIMIT 10");
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>ID</th><th>Nome</th><th>Email</th><th>Role</th><th>Status</th><th>Data</th></tr>";
while ($user = $stmt->fetch()) {
    echo "<tr>";
    echo "<td>{$user['id']}</td>";
    echo "<td>{$user['nome']}</td>";
    echo "<td>{$user['email']}</td>";
    echo "<td><strong>{$user['role']}</strong></td>";
    echo "<td>{$user['status']}</td>";
    echo "<td>{$user['data_cadastro']}</td>";
    echo "</tr>";
}
echo "</table>";

// 3. Verificar se existe algum trigger
echo "<h3>3. Triggers na Tabela Usuarios:</h3>";
$stmt = $pdo->query("SHOW TRIGGERS LIKE 'usuarios'");
$triggers = $stmt->fetchAll();
if (empty($triggers)) {
    echo "<p>Nenhum trigger encontrado.</p>";
} else {
    echo "<pre>";
    print_r($triggers);
    echo "</pre>";
}

// 4. Verificar default da coluna
echo "<h3>4. Verificar se há algum DEFAULT na coluna role:</h3>";
$stmt = $pdo->query("SELECT COLUMN_DEFAULT, COLUMN_TYPE, IS_NULLABLE
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = 'invitmecom_promosis'
    AND TABLE_NAME = 'usuarios'
    AND COLUMN_NAME = 'role'");
$info = $stmt->fetch();
echo "<pre>";
print_r($info);
echo "</pre>";

echo "<h3>5. Teste: Simular INSERT com 'promoter':</h3>";
echo "<p>O código em login.php linha 91 tenta inserir com role='promoter'</p>";
echo "<p><code>INSERT INTO usuarios (..., role, ...) VALUES (..., 'promoter', ...)</code></p>";

// Verificar se 'promoter' está nos valores permitidos do ENUM
if (isset($column['Type'])) {
    echo "<p>Tipo da coluna: <strong>{$column['Type']}</strong></p>";

    // Extrair valores do ENUM
    if (preg_match("/^enum\((.+)\)$/i", $column['Type'], $matches)) {
        $enum_values = str_replace("'", "", $matches[1]);
        echo "<p>Valores permitidos no ENUM: <strong>{$enum_values}</strong></p>";

        if (strpos($enum_values, 'promoter') === false && strpos($enum_values, 'user') !== false) {
            echo "<p style='color: red; font-weight: bold;'>❌ PROBLEMA ENCONTRADO: 'promoter' NÃO está no ENUM, mas 'user' está!</p>";
            echo "<p style='color: red;'>Quando tenta inserir 'promoter' e não está no ENUM, o MySQL pode estar usando o primeiro valor do ENUM, que provavelmente é 'user'</p>";
        } else if (strpos($enum_values, 'promoter') !== false) {
            echo "<p style='color: green; font-weight: bold;'>✓ 'promoter' está no ENUM</p>";
        }
    }
}
?>
