<?php
// verificar_role_usuarios.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$DB_HOST = 'localhost';
$DB_PORT = '3306';
$DB_NAME = 'invitmecom_promosis';
$DB_USER = 'invitmecom_promosis';
$DB_PASS = 'rH]&iG%{ysipNDnB';

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Verificar e Corrigir Coluna 'role'</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; margin-bottom: 20px; }
        h2 { color: #764ba2; margin: 25px 0 15px 0; border-bottom: 2px solid #667eea; padding-bottom: 10px; }
        .success { background: #d4edda; color: #155724; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #28a745; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #dc3545; }
        .warning { background: #fff3cd; color: #856404; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #ffc107; }
        .info { background: #d1ecf1; color: #0c5460; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #17a2b8; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto; font-size: 12px; border: 1px solid #dee2e6; }
        .btn { background: #28a745; color: white; padding: 15px 30px; border: none; border-radius: 8px; font-size: 16px; cursor: pointer; }
        .btn:hover { background: #218838; }
        code { background: #f8f9fa; padding: 2px 6px; border-radius: 3px; font-family: monospace; color: #e83e8c; }
    </style>
</head>
<body>
<div class="container">
    <h1>🔍 Verificar Coluna 'role'</h1>

<?php
try {
    $pdo = new PDO(
        "mysql:host=$DB_HOST;port=$DB_PORT;dbname=$DB_NAME;charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );

    echo "<div class='success'>";
    echo "<p>✅ Conectado ao banco: <strong>$DB_NAME</strong></p>";
    echo "</div>";

    // 1. Verificar definição da coluna role
    echo "<h2>📊 Definição Atual da Coluna 'role'</h2>";

    $stmt = $pdo->query("SHOW COLUMNS FROM usuarios LIKE 'role'");
    $role_info = $stmt->fetch();

    if (!$role_info) {
        echo "<div class='error'>";
        echo "<h3>❌ Coluna 'role' não existe!</h3>";
        echo "<p>A tabela 'usuarios' não tem a coluna 'role'.</p>";
        echo "</div>";
    } else {
        echo "<div class='info'>";
        echo "<p><strong>Campo:</strong> {$role_info['Field']}</p>";
        echo "<p><strong>Tipo:</strong> <code>{$role_info['Type']}</code></p>";
        echo "<p><strong>Null:</strong> {$role_info['Null']}</p>";
        echo "<p><strong>Key:</strong> {$role_info['Key']}</p>";
        echo "<p><strong>Default:</strong> " . ($role_info['Default'] ?? 'NULL') . "</p>";
        echo "<p><strong>Extra:</strong> {$role_info['Extra']}</p>";
        echo "</div>";

        // Verificar se é ENUM
        if (stripos($role_info['Type'], 'enum') !== false) {
            echo "<div class='info'>";
            echo "<h3>🔍 Coluna é ENUM</h3>";

            // Extrair valores do ENUM
            preg_match_all("/'([^']+)'/", $role_info['Type'], $matches);
            $valores_enum = $matches[1];

            echo "<p><strong>Valores permitidos:</strong></p>";
            echo "<ul>";
            foreach ($valores_enum as $valor) {
                echo "<li><code>$valor</code></li>";
            }
            echo "</ul>";
            echo "</div>";

            // Verificar se 'promoter' está nos valores
            if (!in_array('promoter', $valores_enum)) {
                echo "<div class='error'>";
                echo "<h3>❌ PROBLEMA ENCONTRADO!</h3>";
                echo "<p>O valor <code>'promoter'</code> NÃO está nos valores permitidos do ENUM.</p>";
                echo "<p>O cadastro está tentando inserir 'promoter', mas só são aceitos: <strong>" . implode(', ', $valores_enum) . "</strong></p>";
                echo "</div>";

                // Processar correção
                if (isset($_POST['corrigir'])) {
                    echo "<h2>🔨 Corrigindo Coluna 'role'...</h2>";

                    $novos_valores = array_unique(array_merge($valores_enum, ['promoter']));
                    $enum_string = "'" . implode("','", $novos_valores) . "'";

                    $sql = "ALTER TABLE usuarios MODIFY COLUMN role ENUM($enum_string) NOT NULL DEFAULT 'promoter'";

                    echo "<div class='info'>";
                    echo "<p><strong>SQL a ser executado:</strong></p>";
                    echo "<pre>" . htmlspecialchars($sql) . "</pre>";
                    echo "</div>";

                    try {
                        $pdo->exec($sql);

                        echo "<div class='success'>";
                        echo "<h3>🎉 Sucesso!</h3>";
                        echo "<p>Coluna 'role' atualizada com sucesso!</p>";
                        echo "<p><strong>Novos valores permitidos:</strong> " . implode(', ', $novos_valores) . "</p>";
                        echo "<hr style='margin: 20px 0;'>";
                        echo "<h4>✅ Agora você pode cadastrar usuários!</h4>";
                        echo "<p><a href='login.php' class='btn' style='display: inline-block; text-decoration: none;'>🚀 IR PARA LOGIN</a></p>";
                        echo "</div>";

                    } catch (PDOException $e) {
                        echo "<div class='error'>";
                        echo "<h3>❌ Erro ao corrigir</h3>";
                        echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
                        echo "</div>";
                    }

                } else {
                    echo "<div class='warning'>";
                    echo "<h3>🔧 Solução</h3>";
                    echo "<p>Clique no botão abaixo para adicionar 'promoter' aos valores permitidos:</p>";
                    echo "<form method='POST'>";
                    echo "<button type='submit' name='corrigir' class='btn'>🔨 CORRIGIR COLUNA 'role' AGORA</button>";
                    echo "</form>";
                    echo "</div>";
                }

            } else {
                echo "<div class='success'>";
                echo "<h3>✅ Coluna 'role' está correta!</h3>";
                echo "<p>O valor 'promoter' está nos valores permitidos do ENUM.</p>";
                echo "</div>";
            }

        } else {
            echo "<div class='warning'>";
            echo "<h3>⚠️ Coluna não é ENUM</h3>";
            echo "<p>A coluna 'role' é do tipo <code>{$role_info['Type']}</code>, não é ENUM.</p>";
            echo "<p>Pode haver outro problema com a definição da coluna.</p>";
            echo "</div>";
        }
    }

} catch (PDOException $e) {
    echo "<div class='error'>";
    echo "<h3>❌ Erro de Conexão</h3>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}
?>

</div>
</body>
</html>
